/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.jvm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForkedJvm
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(ForkedJvm.class);
    public final Process process;

    public ForkedJvm(Class<?> main) throws IOException {
        String classpath;
        CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new UnsupportedOperationException("Failed to get CodeSource for Essential stage2 loader");
        }
        URL essentialJarUrl = codeSource.getLocation();
        if (essentialJarUrl == null) {
            throw new UnsupportedOperationException("Failed to get location of Essential stage2 loader jar");
        }
        try {
            classpath = Paths.get(essentialJarUrl.toURI()).toAbsolutePath().toString();
        }
        catch (URISyntaxException e) {
            throw new UnsupportedOperationException("Failed to parse " + essentialJarUrl + " as file path:", e);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Paths.get(System.getProperty("java.home"), new String[0]).resolve("bin").resolve("java").toAbsolutePath().toString());
        cmd.add("-cp");
        cmd.add(classpath);
        cmd.add(main.getName());
        LOGGER.debug("Starting forked JVM: " + String.join((CharSequence)" ", cmd));
        this.process = new ProcessBuilder(cmd).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectInput(ProcessBuilder.Redirect.PIPE).start();
        Thread loggerThread = new Thread(() -> {
            Logger logger = LogManager.getLogger((Class)main);
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), StandardCharsets.UTF_8));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    logger.error(line);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error in forked jvm log forwarding:", (Throwable)e);
            }
        }, "ForkedJvm Log Forwarder");
        loggerThread.setDaemon(true);
        loggerThread.start();
    }

    @Override
    public void close() {
        this.process.destroy();
    }
}

