/*
 * Decompiled with CFR 0.152.
 */
package gg.essential;

import com.google.common.net.InetAddresses;
import gg.essential.DI;
import gg.essential.api.EssentialAPI;
import gg.essential.api.commands.CommandRegistry;
import gg.essential.api.config.EssentialConfig;
import gg.essential.api.gui.EssentialComponentFactory;
import gg.essential.api.gui.Notifications;
import gg.essential.api.utils.ShutdownHookUtil;
import gg.essential.api.utils.TrustedHostsUtil;
import gg.essential.api.utils.mojang.MojangAPI;
import gg.essential.commands.EssentialCommandRegistry;
import gg.essential.compatibility.vanilla.difficulty.Net;
import gg.essential.config.EssentialConfigApiImpl;
import gg.essential.config.McEssentialConfig;
import gg.essential.cosmetics.IngameEquippedOutfitsUpdateDispatcher;
import gg.essential.cosmetics.PlayerWearableManager;
import gg.essential.cosmetics.events.CosmeticEventEmitter;
import gg.essential.data.OnboardingData;
import gg.essential.elementa.components.image.FileImageCache;
import gg.essential.elementa.components.image.ImageCache;
import gg.essential.elementa.effects.StencilEffect;
import gg.essential.elementa.font.ElementaFonts;
import gg.essential.event.EventHandler;
import gg.essential.event.client.InitializationEvent;
import gg.essential.event.client.PostInitializationEvent;
import gg.essential.event.client.PreInitializationEvent;
import gg.essential.event.essential.TosAcceptedEvent;
import gg.essential.event.render.RenderTickEvent;
import gg.essential.forge.EssentialForgeMod;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.account.factory.ActiveSessionFactory;
import gg.essential.gui.account.factory.InitialSessionFactory;
import gg.essential.gui.account.factory.MicrosoftAccountSessionFactory;
import gg.essential.gui.account.factory.SessionFactory;
import gg.essential.gui.api.ComponentFactory;
import gg.essential.gui.common.UI3DPlayer;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.elementa.state.v2.StateScheduler;
import gg.essential.gui.image.ResourceImageFactory;
import gg.essential.gui.overlay.OverlayManager;
import gg.essential.gui.overlay.OverlayManagerImpl;
import gg.essential.gui.wardrobe.Wardrobe;
import gg.essential.handlers.EssentialChannelHandler;
import gg.essential.handlers.EssentialGameRules;
import gg.essential.handlers.McMojangSkinManager;
import gg.essential.handlers.MojangSkinManager;
import gg.essential.handlers.NetworkHook;
import gg.essential.handlers.NetworkSubscriptionStateHandler;
import gg.essential.handlers.OptionsScreenOverlay;
import gg.essential.handlers.PauseMenuDisplay;
import gg.essential.handlers.ReAuthChecker;
import gg.essential.handlers.ServerStatusHandler;
import gg.essential.handlers.ShutdownHook;
import gg.essential.handlers.WikiToastListener;
import gg.essential.handlers.WindowedFullscreenHandler;
import gg.essential.handlers.ZoomHandler;
import gg.essential.handlers.discord.DiscordIntegration;
import gg.essential.key.EssentialKeybindingRegistry;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.GsonBuilder;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.lib.kbrewster.eventbus.invokers.InvokerType;
import gg.essential.lib.kbrewster.eventbus.invokers.LMFInvoker;
import gg.essential.lib.kbrewster.eventbus.invokers.ReflectionInvoker;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.skins.PlayerSkinLookup;
import gg.essential.sps.McIntegratedServerManager;
import gg.essential.sps.WindowTitleManager;
import gg.essential.universal.UMinecraft;
import gg.essential.util.AdvancedDrawContext;
import gg.essential.util.AutoUpdate;
import gg.essential.util.EssentialContainerUtil;
import gg.essential.util.EventBus;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.GLUtil;
import gg.essential.util.GuiUtil;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.Multithreading;
import gg.essential.util.OptiFineUtil;
import gg.essential.util.ResourceManagerUtil;
import gg.essential.util.Sk1erModUtils;
import gg.essential.util.USession;
import gg.essential.util.crash.StacktraceDeobfuscator;
import gg.essential.util.lwjgl3.Lwjgl3Loader;
import gg.essential.util.swing.SwingUtil;
import java.io.File;
import java.net.InetAddress;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1131;
import net.minecraft.class_1133;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Essential
implements EssentialAPI {
    public static final String MODID = "essential";
    public static final String NAME = "Essential";
    public static final String VERSION = "1.0.0";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Logger logger = LogManager.getLogger((String)"Essential Logger");
    public static final Logger debug = LogManager.getLogger((String)"Essential Logger - Debug");
    private static final InvokerType invoker = Essential.determineBestInvokerType();
    public static final EventBus EVENT_BUS = new EventBus(invoker, e -> logger.error("Error occurred in method: {}", (Object)e.getMessage(), (Object)e));
    private static Essential instance;
    private static boolean initialized;
    private static boolean getInstanceIsLocked;
    private final File baseDir = this.createEssentialDir();
    public final boolean isNewInstallation = !new File(this.baseDir, "config.toml").exists();
    private final Lwjgl3Loader lwjgl3 = new Lwjgl3Loader(this.baseDir.toPath().resolve("lwjgl3-natives"), GLUtil.INSTANCE.isGL30());
    private final MutableState<@Nullable McIntegratedServerManager> integratedServerManager = StateKt.mutableStateOf(null);
    @NotNull
    private final ConnectionManager connectionManager = new ConnectionManager(new NetworkHook(), this.baseDir, this.lwjgl3, this.integratedServerManager);
    private final List<SessionFactory> sessionFactories = new ArrayList<SessionFactory>();
    private ImageCache imageCache;
    private PlayerWearableManager playerWearableManager;
    private final MojangSkinManager skinManager = new McMojangSkinManager(() -> Wardrobe.getInstance() != null);
    private CosmeticEventEmitter cosmeticEventEmitter;
    private Map<Object, Boolean> dynamicListeners = new HashMap<Object, Boolean>();
    private EssentialGameRules gameRules;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Essential getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<Essential> clazz = Essential.class;
        synchronized (Essential.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            if (getInstanceIsLocked) {
                throw new RuntimeException("A class is attempting to call `Essential.getInstance()` during a call to `Essential#<init>`. See the stacktrace for the culprit.");
            }
            getInstanceIsLocked = true;
            instance = new Essential();
            getInstanceIsLocked = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public @NotNull MutableState<@Nullable McIntegratedServerManager> getIntegratedServerManager() {
        return this.integratedServerManager;
    }

    @NotNull
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @NotNull
    public EssentialKeybindingRegistry getKeybindingRegistry() {
        return EssentialKeybindingRegistry.getInstance();
    }

    @Subscribe
    public void initialize(InitializationEvent event) {
        if (initialized) {
            return;
        }
        initialized = true;
        this.init();
    }

    @Subscribe
    public void preinit(PreInitializationEvent event) {
        DI.INSTANCE.startDI();
        gg.essential.config.EssentialConfig config = gg.essential.config.EssentialConfig.INSTANCE;
        config.initialize(new File(this.baseDir, "config.toml"));
        this.loadSessionFactories();
        this.connectionManager.start();
        PlayerSkinLookup.INSTANCE.supplySkinFromGame(USession.Companion.activeNow().getUuid(), this.skinManager.getActiveSkin());
        this.dispatchStaticInitializers();
    }

    private void dispatchStaticInitializers() {
        Multithreading.runAsync(() -> DiscordIntegration.INSTANCE.getClass());
        Multithreading.runAsync(() -> ElementaFonts.INSTANCE.getClass());
        Multithreading.runAsync(() -> EssentialAPI.Companion.getClass());
        Multithreading.runAsync(() -> AutoUpdate.INSTANCE.getClass());
        Multithreading.runAsync(() -> {
            EssentialPalette.INSTANCE.getClass();
            ResourceImageFactory.Companion.preload();
        });
    }

    private static void dispatchIndependentStaticInitializers() {
        Multithreading.runAsync(() -> gg.essential.config.EssentialConfig.INSTANCE.getClass());
    }

    @Subscribe
    public void postInit(PostInitializationEvent event) {
        this.gameRules = new EssentialGameRules();
    }

    public void registerListener(Object o) {
        EVENT_BUS.register(o);
    }

    public void registerListenerRequiresEssential(Object o) {
        if (gg.essential.config.EssentialConfig.INSTANCE.getEssentialEnabled()) {
            EVENT_BUS.register(o);
            this.dynamicListeners.put(o, true);
        } else {
            this.dynamicListeners.put(o, false);
        }
    }

    public void checkListeners() {
        for (Map.Entry<Object, Boolean> entry2 : this.dynamicListeners.entrySet()) {
            if (!gg.essential.config.EssentialConfig.INSTANCE.getEssentialEnabled()) {
                if (!entry2.getValue().booleanValue()) continue;
                EVENT_BUS.unregister(entry2.getKey());
                entry2.setValue(false);
                continue;
            }
            if (entry2.getValue().booleanValue()) continue;
            EVENT_BUS.register(entry2.getKey());
            entry2.setValue(true);
        }
    }

    public MojangSkinManager getSkinManager() {
        return this.skinManager;
    }

    private void init() {
        gg.essential.config.EssentialConfig essentialConfig = gg.essential.config.EssentialConfig.INSTANCE;
        try {
            if (Sk1erModUtils.isOldModCorePresent() && essentialConfig.getModCoreWarning()) {
                logger.error("Old ModCore has been found!! Uh oh!");
                SwingUtil.showOldModCorePopup();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventHandler.init();
        StencilEffect.Companion.enableStencil();
        McEssentialConfig.INSTANCE.hookUp();
        this.imageCache = new FileImageCache(new File(this.getBaseDir(), "image-cache"), 1L, TimeUnit.HOURS, true);
        PlayerSkinLookup.INSTANCE.loadCache(this.getBaseDir().toPath().resolve("cache"));
        EVENT_BUS.register(EssentialCommandRegistry.INSTANCE);
        this.getKeybindingRegistry().refreshBinds();
        this.registerListener(this.getKeybindingRegistry());
        this.registerListenerRequiresEssential(new NetworkSubscriptionStateHandler());
        this.registerListener(MinecraftUtils.INSTANCE);
        this.registerListenerRequiresEssential(new ServerStatusHandler());
        this.registerListener(GuiUtil.INSTANCE);
        this.registerListener(AdvancedDrawContext.INSTANCE);
        this.registerListener(new PauseMenuDisplay());
        this.registerListenerRequiresEssential(DiscordIntegration.INSTANCE);
        this.registerListener(new OptionsScreenOverlay());
        this.registerListener(this.connectionManager);
        this.registerListener(new WindowedFullscreenHandler());
        this.registerListener(this.connectionManager.getSpsManager());
        this.registerListener(this.connectionManager.getSocialManager());
        this.cosmeticEventEmitter = new CosmeticEventEmitter();
        this.registerListenerRequiresEssential(this.cosmeticEventEmitter);
        this.playerWearableManager = new PlayerWearableManager(this.connectionManager, this.connectionManager.getCosmeticsManager());
        this.registerListener(this.playerWearableManager);
        this.registerListener(WikiToastListener.INSTANCE);
        if (!OptiFineUtil.isLoaded()) {
            this.registerListenerRequiresEssential(ZoomHandler.getInstance());
        }
        this.registerListener(new IngameEquippedOutfitsUpdateDispatcher(this.connectionManager.getSubscriptionManager().getSubscriptionsAndSelf(), this.connectionManager.getCosmeticsManager().getInfraEquippedOutfitsManager()));
        Net.INSTANCE.init();
        Multithreading.runAsync(() -> {
            try {
                EssentialContainerUtil.updateStage1IfOutdated(UMinecraft.getMinecraft().field_1697.toPath());
            }
            catch (Exception e) {
                logger.error("Failed to update loader stage1! Auto-update may not behave as expected!", (Throwable)e);
            }
        });
        this.registerListener(gg.essential.gui.notification.Notifications.INSTANCE);
        this.registerListener(new ReAuthChecker());
        this.registerListener(UI3DPlayer.Companion);
        if (OnboardingData.hasAcceptedTos()) {
            EVENT_BUS.post(new TosAcceptedEvent());
        }
        WindowTitleManager.INSTANCE.register();
        try {
            InetAddresses.toAddrString((InetAddress)InetAddress.getByAddress(new byte[16]));
            class_1133.class.getName();
            class_1131.class.getName();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        EssentialChannelHandler.registerEssentialChannel();
        if (!EssentialForgeMod.USE_NEW_NEOFORGE_RESOURCE_EVENT) {
            ((class_3304)UMinecraft.getMinecraft().method_1478()).method_14477((class_3302)ResourceManagerUtil.INSTANCE);
        }
        AutoUpdate.INSTANCE.getChangelog();
    }

    private File createEssentialDir() {
        File baseDir = new File(UMinecraft.getMinecraft().field_1697, MODID);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        return baseDir;
    }

    private void loadSessionFactories() {
        try {
            Path savePath = ExtensionsKt.getGlobalEssentialDirectory().resolve("microsoft_accounts.json");
            Path oldSavePath = this.baseDir.toPath().resolve("microsoft_accounts.json");
            MicrosoftAccountSessionFactory microsoftAccountSessionFactory = new MicrosoftAccountSessionFactory(savePath, oldSavePath);
            Multithreading.runAsync(microsoftAccountSessionFactory::refreshRefreshTokensIfNecessary);
            this.sessionFactories.add(microsoftAccountSessionFactory);
            this.sessionFactories.add(new ActiveSessionFactory());
            this.sessionFactories.add(new InitialSessionFactory());
        }
        catch (Exception e) {
            logger.error("Failed to load accounts:", (Throwable)e);
        }
    }

    private void createStacktraceDeobfuscator() {
        Multithreading.runAsync(() -> {
            File mappings;
            File mappingsFolder = new File(this.baseDir, "mappings");
            if (!mappingsFolder.exists()) {
                mappingsFolder.mkdir();
            }
            logger.info(((mappings = new File(mappingsFolder, "mappings-" + UMinecraft.getMinecraft().method_1515() + ".csv")).exists() ? "Found MCP method mappings: " : "Downloading MCP method mappings to: ") + mappings.getName());
            StacktraceDeobfuscator.setup(mappings);
        });
    }

    private static InvokerType determineBestInvokerType() {
        if (System.getProperty("java.vm.name", "").contains("OpenJ9")) {
            return new ReflectionInvoker();
        }
        try {
            LMFInvoker lmfInvoker = new LMFInvoker();
            class Dummy {
                Dummy() {
                }

                public void dummy(Object obj) {
                }
            }
            lmfInvoker.setup(new Dummy(), Dummy.class, Object.class, Dummy.class.getMethod("dummy", Object.class));
            return lmfInvoker;
        }
        catch (Throwable e) {
            logger.error("Could not set up LMFInvoker: ", e);
            return new ReflectionInvoker();
        }
    }

    @Subscribe
    public void preRenderTick(RenderTickEvent event) {
        if (!event.isPre()) {
            return;
        }
        StateScheduler.updateSystemTime(Instant.now());
    }

    public void debugKeyFunction() {
    }

    public List<SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Lwjgl3Loader getLwjgl3() {
        return this.lwjgl3;
    }

    @Override
    @NotNull
    public CommandRegistry commandRegistry() {
        return EssentialCommandRegistry.INSTANCE;
    }

    @Override
    @NotNull
    public gg.essential.api.DI di() {
        return DI.INSTANCE;
    }

    @Override
    @NotNull
    public Notifications notifications() {
        return gg.essential.gui.notification.Notifications.INSTANCE;
    }

    @Override
    @NotNull
    public EssentialConfig config() {
        return EssentialConfigApiImpl.INSTANCE;
    }

    @Override
    @NotNull
    public gg.essential.api.utils.GuiUtil guiUtil() {
        return GuiUtil.INSTANCE;
    }

    @Override
    @NotNull
    public gg.essential.api.utils.MinecraftUtils minecraftUtil() {
        return MinecraftUtils.INSTANCE;
    }

    @Override
    @NotNull
    public ShutdownHookUtil shutdownHookUtil() {
        return ShutdownHook.INSTANCE;
    }

    @Override
    @NotNull
    public ImageCache imageCache() {
        return this.imageCache;
    }

    @Override
    @NotNull
    public TrustedHostsUtil trustedHostsUtil() {
        return gg.essential.util.TrustedHostsUtil.INSTANCE;
    }

    @Override
    @NotNull
    public EssentialComponentFactory componentFactory() {
        return ComponentFactory.INSTANCE;
    }

    @Override
    @NotNull
    public MojangAPI mojangAPI() {
        return gg.essential.util.MojangAPI.INSTANCE;
    }

    @Override
    @NotNull
    public gg.essential.api.data.OnboardingData onboardingData() {
        return OnboardingData.INSTANCE;
    }

    public CosmeticEventEmitter getCosmeticEventEmitter() {
        return this.cosmeticEventEmitter;
    }

    public OverlayManager getOverlayManager() {
        return OverlayManagerImpl.INSTANCE;
    }

    @Nullable
    public EssentialGameRules getGameRules() {
        return this.gameRules;
    }

    static {
        initialized = false;
        getInstanceIsLocked = false;
        if (MinecraftUtils.INSTANCE.isDevelopment()) {
            LoggerContext ctx2 = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration conf = ctx2.getConfiguration();
            conf.getLoggerConfig("Essential Logger - Debug").setLevel(Level.ALL);
            ctx2.updateLoggers(conf);
        }
        Essential.dispatchIndependentStaticInitializers();
    }
}

