/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ProfileStatus;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.EssentialModelRenderer;
import gg.essential.cosmetics.WearablesManager;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.mixins.impl.client.renderer.entity.ArmorRenderingUtil;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.model.ModelInstance;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.util.PlayerPoseManager;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.util.UIdentifier;
import gg.essential.util.UIdentifierKt;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public interface CosmeticsRenderState {
    @Nullable
    public WearablesManager wearablesManager();

    @Nullable
    public PlayerPoseManager poseManager();

    public Set<Integer> blockedArmorSlots();

    public class_2960 skinTexture();

    public class_2960 emissiveCapeTexture();

    public boolean onlineIndicator();

    public ModelInstance nametagIcon();

    public boolean isSneaking();

    public void setRenderedPose(PlayerPose var1);

    public void setPoseModified(boolean var1);

    public void setSuppressedArmor(boolean[] var1);

    public float cosmeticFrozenYaw();

    public void setCosmeticFrozenYaw(float var1);

    public static final class Snapshot
    implements CosmeticsRenderState {
        private Live live;
        private WearablesManager wearablesManager;
        private PlayerPoseManager poseManager;
        private Set<Integer> blockedArmorSlots = Collections.emptySet();
        private class_2960 skinTexture;
        private class_2960 emissiveCapeTexture;
        private boolean onlineIndicator;
        private ModelInstance nametagIcon;
        private boolean isSneaking;
        private float cosmeticFrozenYaw;

        @Override
        public WearablesManager wearablesManager() {
            return this.wearablesManager;
        }

        @Override
        public PlayerPoseManager poseManager() {
            return this.poseManager;
        }

        @Override
        public Set<Integer> blockedArmorSlots() {
            return this.blockedArmorSlots;
        }

        @Override
        public class_2960 skinTexture() {
            return this.skinTexture;
        }

        @Override
        public class_2960 emissiveCapeTexture() {
            return this.emissiveCapeTexture;
        }

        @Override
        public boolean onlineIndicator() {
            return this.onlineIndicator;
        }

        @Override
        public ModelInstance nametagIcon() {
            return this.nametagIcon;
        }

        @Override
        public float cosmeticFrozenYaw() {
            return this.cosmeticFrozenYaw;
        }

        @Override
        public boolean isSneaking() {
            return this.isSneaking;
        }

        public void update(class_742 entity) {
            Live live;
            this.live = live = new Live(entity);
            this.wearablesManager = live.wearablesManager();
            this.poseManager = live.poseManager();
            this.blockedArmorSlots = live.blockedArmorSlots();
            this.skinTexture = live.skinTexture();
            this.emissiveCapeTexture = live.emissiveCapeTexture();
            this.onlineIndicator = live.onlineIndicator();
            this.nametagIcon = live.nametagIcon();
            this.isSneaking = live.isSneaking();
            this.cosmeticFrozenYaw = live.cosmeticFrozenYaw();
        }

        @Override
        public void setRenderedPose(PlayerPose pose) {
            Live live = this.live;
            if (live != null) {
                live.setRenderedPose(pose);
            }
        }

        @Override
        public void setPoseModified(boolean poseModified) {
            Live live = this.live;
            if (live != null) {
                live.setPoseModified(poseModified);
            }
        }

        @Override
        public void setSuppressedArmor(boolean[] slots2) {
            Live live = this.live;
            if (live != null) {
                live.setSuppressedArmor(slots2);
            }
        }

        @Override
        public void setCosmeticFrozenYaw(float frozenYaw) {
            Live live = this.live;
            if (live != null) {
                live.setCosmeticFrozenYaw(frozenYaw);
            }
        }
    }

    public static final class Live
    implements CosmeticsRenderState {
        private final class_742 player;

        public Live(class_742 player2) {
            this.player = player2;
        }

        private AbstractClientPlayerExt playerExt() {
            return (AbstractClientPlayerExt)this.player;
        }

        @Override
        public WearablesManager wearablesManager() {
            return EssentialModelRenderer.shouldRender(this.player) ? this.playerExt().getWearablesManager() : null;
        }

        @Override
        public PlayerPoseManager poseManager() {
            if (EssentialConfig.INSTANCE.getDisableEmotes() && !(this.player instanceof EmulatedUI3DPlayer.EmulatedPlayer)) {
                return null;
            }
            return this.playerExt().getPoseManager();
        }

        @Override
        public Set<Integer> blockedArmorSlots() {
            if (!EssentialModelRenderer.shouldRender(this.player)) {
                return Collections.emptySet();
            }
            int armorHidingSetting = ArmorRenderingUtil.getCosmeticArmorSetting((class_1297)this.player);
            if (armorHidingSetting != 1) {
                return Collections.emptySet();
            }
            return this.playerExt().getCosmeticsState().getPartsEquipped();
        }

        @Override
        public class_2960 skinTexture() {
            return this.player.method_52814().comp_1626();
        }

        @Override
        public class_2960 emissiveCapeTexture() {
            if (!EssentialModelRenderer.shouldRender(this.player)) {
                return null;
            }
            UIdentifier identifier2 = this.playerExt().getEmissiveCapeTexture();
            if (identifier2 == null) {
                return null;
            }
            return UIdentifierKt.toMC(identifier2);
        }

        @Override
        public boolean onlineIndicator() {
            UUID uuid;
            if (!EssentialConfig.INSTANCE.getShowEssentialIndicatorOnNametag()) {
                return false;
            }
            ProfileManager profileManager = Essential.getInstance().getConnectionManager().getProfileManager();
            ProfileStatus status2 = profileManager.getStatus(uuid = this.player.method_7334().getId());
            return status2 != ProfileStatus.OFFLINE;
        }

        @Override
        public ModelInstance nametagIcon() {
            if (!EssentialConfig.INSTANCE.getShowEssentialIndicatorOnNametag()) {
                return null;
            }
            EquippedCosmetic cosmetic2 = this.playerExt().getCosmeticsState().getCosmetics().get(CosmeticSlot.ICON);
            if (cosmetic2 == null) {
                return null;
            }
            return this.playerExt().getWearablesManager().getModels().get(cosmetic2.getCosmetic());
        }

        @Override
        public boolean isSneaking() {
            return this.player.method_5715();
        }

        @Override
        public void setRenderedPose(PlayerPose pose) {
            this.playerExt().setRenderedPose(pose);
        }

        @Override
        public void setPoseModified(boolean poseModified) {
            this.playerExt().setPoseModified(poseModified);
        }

        @Override
        public void setSuppressedArmor(boolean[] slots2) {
            System.arraycopy(slots2, 0, this.playerExt().wasArmorRenderingSuppressed(), 0, slots2.length);
        }

        @Override
        public float cosmeticFrozenYaw() {
            return this.playerExt().essential$getCosmeticFrozenYaw();
        }

        @Override
        public void setCosmeticFrozenYaw(float frozenYaw) {
            this.playerExt().essential$setCosmeticFrozenYaw(frozenYaw);
        }
    }
}

