/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import gg.essential.cosmetics.CosmeticsState;
import gg.essential.cosmetics.events.AnimationTarget;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.model.BedrockModel;
import gg.essential.model.EnumPart;
import gg.essential.model.ModelAnimationState;
import gg.essential.model.ModelInstance;
import gg.essential.model.RenderMetadata;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.backend.atlas.TextureAtlas;
import gg.essential.model.molang.MolangQueryEntity;
import gg.essential.model.util.UMatrixStack;
import gg.essential.model.util.UVertexConsumer;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u001d\u001a\u00020\r2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\r0\u001fJ>\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0007J6\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0007J\u000e\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020\rJ\u000e\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020(J\u000e\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\u0017R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lgg/essential/cosmetics/WearablesManager;", "", "renderBackend", "Lgg/essential/model/backend/RenderBackend;", "entity", "Lgg/essential/model/molang/MolangQueryEntity;", "animationTargets", "", "Lgg/essential/cosmetics/events/AnimationTarget;", "onAnimation", "Lkotlin/Function2;", "Lgg/essential/network/cosmetics/Cosmetic;", "", "", "(Lgg/essential/model/backend/RenderBackend;Lgg/essential/model/molang/MolangQueryEntity;Ljava/util/Set;Lkotlin/jvm/functions/Function2;)V", "lastUpdateTime", "", "<set-?>", "", "Lgg/essential/model/ModelInstance;", "models", "getModels", "()Ljava/util/Map;", "Lgg/essential/cosmetics/CosmeticsState;", "state", "getState", "()Lgg/essential/cosmetics/CosmeticsState;", "translucentTextureAtlas", "Lgg/essential/model/backend/atlas/TextureAtlas;", "collectEvents", "consumer", "Lkotlin/Function1;", "Lgg/essential/model/ModelAnimationState$Event;", "render", "matrixStack", "Lgg/essential/model/util/UMatrixStack;", "queue", "Lgg/essential/model/backend/RenderBackend$CommandQueue;", "model", "pose", "Lgg/essential/model/backend/PlayerPose;", "skin", "Lgg/essential/model/backend/RenderBackend$Texture;", "parts", "Lgg/essential/model/EnumPart;", "resetModel", "slot", "Lgg/essential/mod/cosmetics/CosmeticSlot;", "update", "updateLocators", "renderedPose", "updateState", "newState", "Companion", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nWearablesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WearablesManager.kt\ngg/essential/cosmetics/WearablesManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,186:1\n764#2:187\n855#2,2:188\n1601#2,9:190\n1849#2:199\n1850#2:201\n1610#2:202\n1043#2:207\n1192#2,2:208\n1220#2,4:210\n764#2:214\n855#2,2:215\n1601#2,9:217\n1849#2:226\n1850#2:228\n1610#2:229\n1849#2,2:230\n1849#2,2:232\n1849#2,2:234\n1#3:200\n1#3:227\n125#4:203\n152#4,3:204\n*S KotlinDebug\n*F\n+ 1 WearablesManager.kt\ngg/essential/cosmetics/WearablesManager\n*L\n43#1:187\n43#1:188,2\n43#1:190,9\n43#1:199\n43#1:201\n43#1:202\n56#1:207\n57#1:208,2\n57#1:210,4\n60#1:214\n60#1:215,2\n60#1:217,9\n60#1:226\n60#1:228\n60#1:229\n107#1:230,2\n114#1:232,2\n117#1:234,2\n43#1:200\n60#1:227\n47#1:203\n47#1:204,3\n*E\n"})
public final class WearablesManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderBackend renderBackend;
    @NotNull
    private final MolangQueryEntity entity;
    @NotNull
    private final Set<AnimationTarget> animationTargets;
    @NotNull
    private final Function2<Cosmetic, String, Unit> onAnimation;
    @NotNull
    private CosmeticsState state;
    @NotNull
    private Map<Cosmetic, ModelInstance> models;
    @Nullable
    private TextureAtlas translucentTextureAtlas;
    private float lastUpdateTime;
    private static int atlasCounter;

    public WearablesManager(@NotNull RenderBackend renderBackend, @NotNull MolangQueryEntity entity, @NotNull Set<? extends AnimationTarget> animationTargets, @NotNull Function2<? super Cosmetic, ? super String, Unit> onAnimation) {
        Intrinsics.checkNotNullParameter((Object)renderBackend, (String)"renderBackend");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(animationTargets, (String)"animationTargets");
        Intrinsics.checkNotNullParameter(onAnimation, (String)"onAnimation");
        this.renderBackend = renderBackend;
        this.entity = entity;
        this.animationTargets = animationTargets;
        this.onAnimation = onAnimation;
        this.state = CosmeticsState.EMPTY;
        this.models = MapsKt.emptyMap();
        this.lastUpdateTime = Float.NEGATIVE_INFINITY;
    }

    @NotNull
    public final CosmeticsState getState() {
        return this.state;
    }

    @NotNull
    public final Map<Cosmetic, ModelInstance> getModels() {
        return this.models;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateState(@NotNull CosmeticsState newState) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable $this$sortedBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Map<Cosmetic, ModelInstance> oldModels = this.models;
        Iterable $this$filter$iv = oldModels.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ModelInstance modelInstance = (ModelInstance)element$iv$iv;
            boolean bl = false;
            if (!modelInstance.getModel().getTranslucent()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull232 = false;
        $this$filterTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach32 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RenderBackend.Texture it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ModelInstance it2 = (ModelInstance)element$iv$iv;
            boolean bl2 = false;
            if (it2.getModel().getTexture() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List oldTextures = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Map<Cosmetic, BedrockModel> $i$f$mapNotNull232 = newState.getBedrockModels();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator $i$f$forEach32 = $this$mapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach32.hasNext()) {
            ModelInstance modelInstance;
            Map.Entry entry2;
            Map.Entry element$iv$iv$iv = entry2 = $i$f$forEach32.next();
            object = destination$iv$iv2;
            boolean bl = false;
            Cosmetic cosmetic2 = (Cosmetic)element$iv$iv$iv.getKey();
            BedrockModel bedrockModel = (BedrockModel)element$iv$iv$iv.getValue();
            ModelInstance wearable = oldModels.get(cosmetic2);
            if (wearable == null) {
                modelInstance = new ModelInstance(bedrockModel, this.entity, this.animationTargets, newState, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, cosmetic2){
                    final /* synthetic */ WearablesManager this$0;
                    final /* synthetic */ Cosmetic $cosmetic;
                    {
                        this.this$0 = $receiver;
                        this.$cosmetic = $cosmetic;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        WearablesManager.access$getOnAnimation$p(this.this$0).invoke((Object)this.$cosmetic, (Object)it);
                    }
                }));
            } else {
                wearable.switchModel(bedrockModel, newState);
                modelInstance = wearable;
            }
            object.add(modelInstance);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModelInstance it = (ModelInstance)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.getModel().getTranslucent());
                it = (ModelInstance)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getModel().getTranslucent()));
            }
        });
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it3;
            ModelInstance bl = (ModelInstance)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl4 = false;
            object.put(it3.getCosmetic(), element$iv$iv);
        }
        Map newModels2 = destination$iv$iv3;
        Iterable $this$filter$iv2 = newModels2.values();
        boolean $i$f$filter2 = false;
        $this$associateByTo$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModelInstance it4 = (ModelInstance)element$iv$iv;
            boolean bl = false;
            if (!it4.getModel().getTranslucent()) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv4;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void var11_27 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator3 = var11_27.iterator();
        while (iterator3.hasNext()) {
            RenderBackend.Texture it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            ModelInstance it5 = (ModelInstance)element$iv$iv;
            boolean bl5 = false;
            if (it5.getModel().getTexture() == null) continue;
            boolean bl6 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        List newTextures = CollectionsKt.distinct((Iterable)((List)destination$iv$iv4));
        if (!Intrinsics.areEqual((Object)oldTextures, (Object)newTextures)) {
            TextureAtlas textureAtlas = this.translucentTextureAtlas;
            if (textureAtlas != null) {
                textureAtlas.close();
            }
            this.translucentTextureAtlas = null;
        }
        if (this.translucentTextureAtlas == null && newTextures.size() > 1) {
            int n = atlasCounter;
            atlasCounter = n + 1;
            this.translucentTextureAtlas = TextureAtlas.Companion.create(this.renderBackend, "cosmetics-" + n, newTextures);
        }
        for (Map.Entry<Cosmetic, ModelInstance> entry2 : this.models.entrySet()) {
            Cosmetic cosmetic3 = entry2.getKey();
            ModelInstance model = entry2.getValue();
            if (Intrinsics.areEqual(newModels2.get(cosmetic3), (Object)model)) continue;
            model.getLocator().setValid(false);
        }
        this.state = newState;
        this.models = newModels2;
    }

    public final void resetModel(@NotNull CosmeticSlot slot) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        this.updateState(this.state.copyWithout(slot));
    }

    public final void update() {
        ModelInstance it;
        if (this.models.isEmpty()) {
            return;
        }
        float now2 = this.entity.getLifeTime();
        if (this.lastUpdateTime == now2) {
            return;
        }
        this.lastUpdateTime = now2;
        Collection<ModelInstance> modelInstances = this.models.values();
        Iterable $this$forEach$iv = modelInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ModelInstance)element$iv;
            boolean bl = false;
            it.getEssentialAnimationSystem().maybeFireTextureAnimationStartEvent();
            it.getEssentialAnimationSystem().updateAnimationState();
        }
        $this$forEach$iv = modelInstances;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ModelInstance)element$iv;
            boolean bl = false;
            it.getEssentialAnimationSystem().triggerPendingAnimationsForOtherModels(modelInstances);
        }
        $this$forEach$iv = modelInstances;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ModelInstance)element$iv;
            boolean bl = false;
            ModelAnimationState.updateEffects$default(it.getAnimationState(), 0.0f, 1, null);
        }
    }

    public final void updateLocators(@NotNull PlayerPose renderedPose) {
        Intrinsics.checkNotNullParameter((Object)renderedPose, (String)"renderedPose");
        Iterator<Map.Entry<Cosmetic, ModelInstance>> iterator2 = this.models.entrySet().iterator();
        while (iterator2.hasNext()) {
            ModelInstance model = iterator2.next().getValue();
            model.updateLocators(renderedPose, this.state);
        }
    }

    public final void render(@NotNull UMatrixStack matrixStack, @NotNull RenderBackend.CommandQueue queue, @NotNull PlayerPose pose, @NotNull RenderBackend.Texture skin, @NotNull Set<? extends EnumPart> parts) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        TextureAtlas atlas = this.translucentTextureAtlas;
        Iterator<Map.Entry<Cosmetic, ModelInstance>> iterator2 = this.models.entrySet().iterator();
        while (iterator2.hasNext()) {
            ModelInstance model = iterator2.next().getValue();
            RenderBackend.CommandQueue modelQueue2 = model.getModel().getTranslucent() && atlas != null ? (arg_0, arg_1, arg_2, arg_3) -> WearablesManager.render$lambda$10(queue, atlas, arg_0, arg_1, arg_2, arg_3) : queue;
            this.render(matrixStack, modelQueue2, model, pose, skin, parts);
        }
    }

    public static /* synthetic */ void render$default(WearablesManager wearablesManager2, UMatrixStack uMatrixStack, RenderBackend.CommandQueue commandQueue, PlayerPose playerPose, RenderBackend.Texture texture, Set set2, int n, Object object) {
        if ((n & 0x10) != 0) {
            set2 = ArraysKt.toSet((Object[])EnumPart.values());
        }
        wearablesManager2.render(uMatrixStack, commandQueue, playerPose, texture, set2);
    }

    public final void render(@NotNull UMatrixStack matrixStack, @NotNull RenderBackend.CommandQueue queue, @NotNull ModelInstance model, @NotNull PlayerPose pose, @NotNull RenderBackend.Texture skin, @NotNull Set<? extends EnumPart> parts) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        Cosmetic cosmetic2 = model.getCosmetic();
        Set set2 = this.state.getHiddenBones().get(cosmetic2.getId());
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        RenderMetadata renderMetadata = new RenderMetadata(pose, skin, 0, this.state.getSides().get(cosmetic2.getId()), set2, this.state.getPositionAdjustment(cosmetic2), SetsKt.minus(parts, (Iterable)this.state.getHiddenParts().getOrDefault(cosmetic2.getId(), SetsKt.emptySet())));
        model.render(matrixStack, queue, (List)MapsKt.getValue(this.state.getRenderGeometries(), (Object)cosmetic2.getId()), renderMetadata);
    }

    public static /* synthetic */ void render$default(WearablesManager wearablesManager2, UMatrixStack uMatrixStack, RenderBackend.CommandQueue commandQueue, ModelInstance modelInstance, PlayerPose playerPose, RenderBackend.Texture texture, Set set2, int n, Object object) {
        if ((n & 0x20) != 0) {
            set2 = ArraysKt.toSet((Object[])EnumPart.values());
        }
        wearablesManager2.render(uMatrixStack, commandQueue, modelInstance, playerPose, texture, set2);
    }

    public final void collectEvents(@NotNull Function1<? super ModelAnimationState.Event, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        for (ModelInstance model : this.models.values()) {
            List<ModelAnimationState.Event> pendingEvents = model.getAnimationState().getPendingEvents();
            if (!(!((Collection)pendingEvents).isEmpty())) continue;
            for (ModelAnimationState.Event event : pendingEvents) {
                consumer.invoke((Object)event);
            }
            pendingEvents.clear();
        }
    }

    private static final void render$lambda$10(RenderBackend.CommandQueue $queue, TextureAtlas $atlas, RenderBackend.Texture texture, boolean translucent, boolean emissive, Function1 render2) {
        Intrinsics.checkNotNullParameter((Object)$queue, (String)"$queue");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)render2, (String)"render");
        $queue.submit($atlas.getAtlasTexture(), translucent, emissive, (Function1<? super UVertexConsumer, Unit>)((Function1)new Function1<UVertexConsumer, Unit>((Function1<? super UVertexConsumer, Unit>)render2, $atlas, texture){
            final /* synthetic */ Function1<UVertexConsumer, Unit> $render;
            final /* synthetic */ TextureAtlas $atlas;
            final /* synthetic */ RenderBackend.Texture $texture;
            {
                this.$render = $render;
                this.$atlas = $atlas;
                this.$texture = $texture;
                super(1);
            }

            public final void invoke(@NotNull UVertexConsumer vertexConsumer) {
                Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
                this.$render.invoke((Object)this.$atlas.offsetVertexConsumer(this.$texture, vertexConsumer));
            }
        }));
    }

    public static final /* synthetic */ Function2 access$getOnAnimation$p(WearablesManager $this) {
        return $this.onAnimation;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgg/essential/cosmetics/WearablesManager$Companion;", "", "()V", "atlasCounter", "", "cosmetics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

