/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.boxmask;

import gg.essential.cosmetics.boxmask.ModelClipper;
import gg.essential.model.Box3;
import gg.essential.model.Cube;
import gg.essential.model.Face;
import gg.essential.model.PositionTexVertex;
import gg.essential.model.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004H\u0002J>\u0010\t\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0004j\u0002`\n2\u0016\u0010\u000b\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0004j\u0002`\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0004H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lgg/essential/cosmetics/boxmask/ModelClipperImpl;", "Lgg/essential/cosmetics/boxmask/ModelClipper;", "()V", "apply", "", "Lgg/essential/model/Cube;", "cubeList", "renderExclusions", "Lgg/essential/model/Box3;", "compute", "Lgg/essential/model/RenderGeometry;", "geometry", "masks", "generateARegion", "", "intersectedFace", "Lgg/essential/cosmetics/boxmask/ModelClipperImpl$IntersectedFace;", "minYIntersect", "", "EnumRegion", "FaceRegion", "IntersectedFace", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nModelClipperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelClipperImpl.kt\ngg/essential/cosmetics/boxmask/ModelClipperImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1547#2:129\n1618#2,3:130\n1547#2:133\n1618#2,3:134\n*S KotlinDebug\n*F\n+ 1 ModelClipperImpl.kt\ngg/essential/cosmetics/boxmask/ModelClipperImpl\n*L\n26#1:129\n26#1:130,3\n30#1:133\n30#1:134,3\n*E\n"})
public final class ModelClipperImpl
implements ModelClipper {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<List<Cube>> compute(@NotNull List<? extends List<Cube>> geometry, @NotNull List<Box3> masks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter(masks, (String)"masks");
        if (masks.isEmpty()) {
            return geometry;
        }
        Iterable $this$map$iv = geometry;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.apply((List<Cube>)it, masks));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Cube> apply(List<Cube> cubeList, List<Box3> renderExclusions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = cubeList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void orgCube;
            Cube cube = (Cube)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Cube cube2 = orgCube.deepCopy();
            Iterator<Face> iterator2 = cube2.getQuadList().iterator();
            List newFaces = new ArrayList();
            while (iterator2.hasNext()) {
                Face next = iterator2.next();
                Box3 selfBox = new Box3(null, null, 3, null);
                PositionTexVertex[] vertices = next.vertexPositions;
                Vector3 a = vertices[0].vector3.clone();
                Vector3 b = vertices[1].vector3.clone();
                Vector3 c = vertices[2].vector3.clone();
                Vector3 d = vertices[3].vector3.clone();
                Object[] objectArray = new Vector3[]{a, b, c, d};
                selfBox.setFromPoints(CollectionsKt.listOf((Object[])objectArray));
                boolean matched = false;
                IntersectedFace intersectedFace = new IntersectedFace(next, cube2.getMirror());
                for (Box3 exclusion : renderExclusions) {
                    Box3 intersect = selfBox.clone().intersect(exclusion);
                    if (Intrinsics.areEqual((Object)intersect, (Object)selfBox)) {
                        iterator2.remove();
                        matched = false;
                        break;
                    }
                    if (intersect.isEmpty()) continue;
                    matched = true;
                    float xHeight = intersect.getMax().x - intersect.getMin().x;
                    float zHeight = intersect.getMax().z - intersect.getMin().z;
                    float minYIntersect = Math.min(intersect.getMin().y, intersectedFace.getARegion().getPoints()[3].vector3.y);
                    if (xHeight == 0.0f) {
                        this.generateARegion(intersectedFace, minYIntersect);
                        continue;
                    }
                    if (!(zHeight == 0.0f)) continue;
                    this.generateARegion(intersectedFace, minYIntersect);
                }
                if (!matched) continue;
                iterator2.remove();
                newFaces.addAll((Collection)intersectedFace.generateFaces());
            }
            cube2.getQuadList().addAll(newFaces);
            collection.add(cube2);
        }
        return (List)destination$iv$iv;
    }

    private final void generateARegion(IntersectedFace intersectedFace, float minYIntersect) {
        float texY;
        intersectedFace.getARegion().getPoints()[2].vector3.y = minYIntersect;
        intersectedFace.getARegion().getPoints()[3].vector3.y = minYIntersect;
        intersectedFace.getARegion().getPoints()[2].texturePositionY = texY = intersectedFace.getARegion().getPoints()[1].texturePositionY + (minYIntersect - intersectedFace.getARegion().getPoints()[0].vector3.y) / intersectedFace.getARegion().getSpacialYDistance() * intersectedFace.getARegion().getTextureYDistance();
        intersectedFace.getARegion().getPoints()[3].texturePositionY = texY;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/cosmetics/boxmask/ModelClipperImpl$EnumRegion;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "cosmetics"})
    private static final class EnumRegion
    extends Enum<EnumRegion> {
        public static final /* enum */ EnumRegion A = new EnumRegion();
        public static final /* enum */ EnumRegion B = new EnumRegion();
        public static final /* enum */ EnumRegion C = new EnumRegion();
        public static final /* enum */ EnumRegion D = new EnumRegion();
        private static final /* synthetic */ EnumRegion[] $VALUES;

        public static EnumRegion[] values() {
            return (EnumRegion[])$VALUES.clone();
        }

        public static EnumRegion valueOf(String value) {
            return Enum.valueOf(EnumRegion.class, value);
        }

        static {
            $VALUES = enumRegionArray = new EnumRegion[]{EnumRegion.A, EnumRegion.B, EnumRegion.C, EnumRegion.D};
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0005R\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lgg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion;", "", "region", "Lgg/essential/cosmetics/boxmask/ModelClipperImpl$EnumRegion;", "base", "Lgg/essential/model/Face;", "mirror", "", "(Lgg/essential/cosmetics/boxmask/ModelClipperImpl$EnumRegion;Lgg/essential/model/Face;Z)V", "points", "", "Lgg/essential/model/PositionTexVertex;", "getPoints", "()[Lgg/essential/model/PositionTexVertex;", "setPoints", "([Lgg/essential/model/PositionTexVertex;)V", "[Lgg/essential/model/PositionTexVertex;", "spacialYDistance", "", "getSpacialYDistance", "()F", "setSpacialYDistance", "(F)V", "textureYDistance", "getTextureYDistance", "setTextureYDistance", "flipFace", "", "toFace", "cosmetics"})
    @SourceDebugExtension(value={"SMAP\nModelClipperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelClipperImpl.kt\ngg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,128:1\n11328#2:129\n11663#2,3:130\n11418#2:137\n11529#2,4:138\n11328#2:146\n11663#2,3:147\n37#3:133\n36#3,3:134\n37#3:142\n36#3,3:143\n37#3:150\n36#3,3:151\n*S KotlinDebug\n*F\n+ 1 ModelClipperImpl.kt\ngg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion\n*L\n106#1:129\n106#1:130,3\n119#1:137\n119#1:138,4\n125#1:146\n125#1:147,3\n106#1:133\n106#1:134,3\n121#1:142\n121#1:143,3\n125#1:150\n125#1:151,3\n*E\n"})
    private static final class FaceRegion {
        @NotNull
        private PositionTexVertex[] points;
        private float spacialYDistance;
        private float textureYDistance;

        /*
         * WARNING - void declaration
         */
        public FaceRegion(@NotNull EnumRegion region, @NotNull Face base, boolean mirror) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            PositionTexVertex[] positionTexVertexArray = base.vertexPositions;
            FaceRegion faceRegion = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var12_13 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.copy());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            PositionTexVertex[] positionTexVertexArray2 = thisCollection$iv.toArray(new PositionTexVertex[0]);
            if (positionTexVertexArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            faceRegion.points = positionTexVertexArray2;
            if (mirror) {
                this.flipFace();
            }
            if (region == EnumRegion.A) {
                this.spacialYDistance = this.points[2].vector3.y - this.points[1].vector3.y;
                this.textureYDistance = this.points[2].texturePositionY - this.points[1].texturePositionY;
            }
        }

        @NotNull
        public final PositionTexVertex[] getPoints() {
            return this.points;
        }

        public final void setPoints(@NotNull PositionTexVertex[] positionTexVertexArray) {
            Intrinsics.checkNotNullParameter((Object)positionTexVertexArray, (String)"<set-?>");
            this.points = positionTexVertexArray;
        }

        public final float getSpacialYDistance() {
            return this.spacialYDistance;
        }

        public final void setSpacialYDistance(float f) {
            this.spacialYDistance = f;
        }

        public final float getTextureYDistance() {
            return this.textureYDistance;
        }

        public final void setTextureYDistance(float f) {
            this.textureYDistance = f;
        }

        /*
         * WARNING - void declaration
         */
        public final void flipFace() {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            PositionTexVertex[] positionTexVertexArray = this.points;
            FaceRegion faceRegion = this;
            boolean $i$f$mapIndexed = false;
            void var3_4 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$mapIndexed$iv).length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i2;
                int n = index$iv$iv++;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.points[this.points.length - i2 - 1]);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PositionTexVertex[] positionTexVertexArray2 = thisCollection$iv.toArray(new PositionTexVertex[0]);
            if (positionTexVertexArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            faceRegion.points = positionTexVertexArray2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Face toFace() {
            void $this$mapTo$iv$iv;
            PositionTexVertex[] $this$map$iv = this.points;
            boolean $i$f$map = false;
            PositionTexVertex[] positionTexVertexArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.copy());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PositionTexVertex[] positionTexVertexArray2 = thisCollection$iv.toArray(new PositionTexVertex[0]);
            if (positionTexVertexArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            PositionTexVertex[] positionTexVertexArray3 = positionTexVertexArray2;
            return new Face(positionTexVertexArray3);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lgg/essential/cosmetics/boxmask/ModelClipperImpl$IntersectedFace;", "", "base", "Lgg/essential/model/Face;", "mirror", "", "(Lgg/essential/model/Face;Z)V", "aRegion", "Lgg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion;", "getARegion", "()Lgg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion;", "generateFaces", "", "cosmetics"})
    private static final class IntersectedFace {
        @NotNull
        private final FaceRegion aRegion;

        public IntersectedFace(@NotNull Face base, boolean mirror) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.aRegion = new FaceRegion(EnumRegion.A, base, mirror);
        }

        @NotNull
        public final FaceRegion getARegion() {
            return this.aRegion;
        }

        @NotNull
        public final List<Face> generateFaces() {
            return CollectionsKt.listOf((Object)this.aRegion.toFace());
        }
    }
}

