/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.events;

import gg.essential.cosmetics.IngameEquippedOutfitsManager;
import gg.essential.cosmetics.IngameEquippedOutfitsUpdateDispatcher;
import gg.essential.cosmetics.events.AnimationEventType;
import gg.essential.event.entity.PlayerTickEvent;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.model.ModelInstance;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import kotlin.Pair;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;

public class CosmeticEventEmitter {
    public void triggerEvent(UUID playerUuid, CosmeticSlot slot, String event) {
        IngameEquippedOutfitsUpdateDispatcher.Companion.sendUpdates(Collections.singletonList(new Pair((Object)playerUuid, Collections.singletonList(new IngameEquippedOutfitsManager.Update.AnimationEvent(slot, event)))));
    }

    public static void doTriggerEvent(UUID playerUuid, CosmeticSlot slot, String event) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        AbstractClientPlayerExt player2 = CosmeticEventEmitter.findPlayerByCosmeticsSourceUuid(world, playerUuid);
        if (player2 == null) {
            return;
        }
        if (event.equals("reset")) {
            player2.getWearablesManager().resetModel(slot);
            return;
        }
        Map<Cosmetic, ModelInstance> essentialCosmeticModels = player2.getWearablesManager().getModels();
        for (ModelInstance value : essentialCosmeticModels.values()) {
            if (slot != value.getCosmetic().getType().getSlot()) continue;
            value.getEssentialAnimationSystem().fireTriggerFromAnimation(event, null);
        }
    }

    private static AbstractClientPlayerExt findPlayerByCosmeticsSourceUuid(class_638 world, UUID uuid) {
        for (class_1657 player2 : world.method_18456()) {
            AbstractClientPlayerExt playerExt;
            if (!(player2 instanceof AbstractClientPlayerExt) || !(playerExt = (AbstractClientPlayerExt)player2).getCosmeticsSourceUuid().equals(uuid)) continue;
            return playerExt;
        }
        return null;
    }

    public void fireEvent(class_742 player2, AnimationEventType type) {
        Map<Cosmetic, ModelInstance> essentialCosmeticModels = ((AbstractClientPlayerExt)player2).getWearablesManager().getModels();
        for (ModelInstance value : essentialCosmeticModels.values()) {
            value.getEssentialAnimationSystem().processEvent(type);
        }
    }

    @Subscribe
    public void tick(PlayerTickEvent tickEvent) {
        if (tickEvent.isPre()) {
            return;
        }
        class_1657 playerEntity = tickEvent.getPlayer();
        if (!(playerEntity instanceof class_742)) {
            return;
        }
        this.fireEvent((class_742)playerEntity, AnimationEventType.TICK);
    }
}

