/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.handler;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.sparkuniverse.toolbox.serialization.DateTimeTypeAdapter;
import com.sparkuniverse.toolbox.serialization.UUIDTypeAdapter;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.screenshot.handler.ScreenshotChecksumManager;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.GsonBuilder;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.lib.gson.annotations.SerializedName;
import gg.essential.network.connectionmanager.media.IScreenshotMetadataManager;
import gg.essential.util.DispatchersKt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\fJ\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\fJ\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0 2\u0006\u0010\u001a\u001a\u00020\fJ\u0012\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\rJ\u001a\u0010&\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager;", "Lgg/essential/network/connectionmanager/media/IScreenshotMetadataManager;", "metadataFolder", "Ljava/io/File;", "screenshotChecksumManager", "Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;", "(Ljava/io/File;Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;)V", "gson", "Lgg/essential/lib/gson/Gson;", "kotlin.jvm.PlatformType", "metadataCache", "", "", "Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "negativeChecksumCache", "", "", "stateByChecksum", "Lgg/essential/gui/elementa/state/v2/MutableState;", "deleteMetadata", "", "metadata", "file", "getMetadata", "path", "Ljava/nio/file/Path;", "checksum", "getMetadataCache", "mediaId", "getOrCreateMetadata", "handleExternalDelete", "fileName", "Lgg/essential/gui/elementa/state/v2/State;", "readMetadata", "imageChecksum", "tryRecoverMetadata", "updateMetadata", "screenshotMetadata", "updateState", "newMetadata", "writeMetadata", "Companion", "SerializedMetadata", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nScreenshotMetadataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotMetadataManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotMetadataManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,240:1\n1#2:241\n288#3,2:242\n372#4,7:244\n*S KotlinDebug\n*F\n+ 1 ScreenshotMetadataManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotMetadataManager\n*L\n116#1:242,2\n180#1:244,7\n*E\n"})
public final class ScreenshotMetadataManager
implements IScreenshotMetadataManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File metadataFolder;
    @NotNull
    private final ScreenshotChecksumManager screenshotChecksumManager;
    private final Gson gson;
    @NotNull
    private final Map<String, ClientScreenshotMetadata> metadataCache;
    private final Set<String> negativeChecksumCache;
    @NotNull
    private final Map<String, MutableState<ClientScreenshotMetadata>> stateByChecksum;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenshotMetadataManager.class);

    public ScreenshotMetadataManager(@NotNull File metadataFolder, @NotNull ScreenshotChecksumManager screenshotChecksumManager) {
        Intrinsics.checkNotNullParameter((Object)metadataFolder, (String)"metadataFolder");
        Intrinsics.checkNotNullParameter((Object)screenshotChecksumManager, (String)"screenshotChecksumManager");
        this.metadataFolder = metadataFolder;
        this.screenshotChecksumManager = screenshotChecksumManager;
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter()).registerTypeAdapter((Type)((Object)DateTime.class), new DateTimeTypeAdapter()).create();
        this.metadataCache = new ConcurrentHashMap();
        this.negativeChecksumCache = Sets.newConcurrentHashSet();
        ConcurrentMap concurrentMap = new MapMaker().weakValues().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"makeMap(...)");
        this.stateByChecksum = concurrentMap;
    }

    public final void updateMetadata(@NotNull ClientScreenshotMetadata screenshotMetadata) {
        Intrinsics.checkNotNullParameter((Object)screenshotMetadata, (String)"screenshotMetadata");
        this.metadataCache.put(screenshotMetadata.getChecksum(), screenshotMetadata);
        this.writeMetadata(screenshotMetadata);
        this.updateState(screenshotMetadata.getChecksum(), screenshotMetadata);
    }

    private final ClientScreenshotMetadata readMetadata(String imageChecksum) {
        ClientScreenshotMetadata clientScreenshotMetadata;
        try {
            String fileContents = FilesKt.readText$default((File)new File(this.metadataFolder, imageChecksum), null, (int)1, null);
            SerializedMetadata serializedMetadata = this.gson.fromJson(fileContents, SerializedMetadata.class);
            clientScreenshotMetadata = serializedMetadata != null ? serializedMetadata.toMod() : null;
        }
        catch (JsonSyntaxException exception) {
            LOGGER.error("Metadata corrupt for checksum " + imageChecksum + ". Attempting recovery.", (Throwable)exception);
            clientScreenshotMetadata = this.tryRecoverMetadata(imageChecksum);
        }
        catch (FileNotFoundException ignored) {
            clientScreenshotMetadata = null;
        }
        return clientScreenshotMetadata;
    }

    private final ClientScreenshotMetadata tryRecoverMetadata(String checksum) {
        ClientScreenshotMetadata metadata2;
        block2: {
            ClientScreenshotMetadata clientScreenshotMetadata;
            Path path = (Path)CollectionsKt.firstOrNull(this.screenshotChecksumManager.getPathsForChecksum(checksum));
            if (path != null) {
                Path it = path;
                boolean bl = false;
                clientScreenshotMetadata = ClientScreenshotMetadata.Companion.createUnknown(it, checksum);
            } else {
                clientScreenshotMetadata = null;
            }
            ClientScreenshotMetadata clientScreenshotMetadata2 = metadata2 = clientScreenshotMetadata;
            if (clientScreenshotMetadata2 == null) break block2;
            ClientScreenshotMetadata it = clientScreenshotMetadata2;
            boolean bl = false;
            this.writeMetadata(it);
        }
        return metadata2;
    }

    private final ClientScreenshotMetadata getMetadata(String checksum) {
        ClientScreenshotMetadata metadata2;
        if (this.negativeChecksumCache.contains(checksum)) {
            return null;
        }
        ClientScreenshotMetadata clientScreenshotMetadata = this.metadataCache.get(checksum);
        if (clientScreenshotMetadata == null) {
            ClientScreenshotMetadata clientScreenshotMetadata2 = this.readMetadata(checksum);
            if (clientScreenshotMetadata2 != null) {
                ClientScreenshotMetadata clientScreenshotMetadata3;
                ClientScreenshotMetadata metadata3 = clientScreenshotMetadata3 = clientScreenshotMetadata2;
                boolean bl = false;
                this.metadataCache.put(checksum, metadata3);
                this.updateState(metadata3.getChecksum(), metadata3);
                clientScreenshotMetadata = clientScreenshotMetadata3;
            } else {
                clientScreenshotMetadata = null;
            }
        }
        if ((metadata2 = clientScreenshotMetadata) == null) {
            this.negativeChecksumCache.add(checksum);
        }
        return metadata2;
    }

    @Override
    @Nullable
    public ClientScreenshotMetadata getMetadata(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return this.getMetadata(file);
    }

    @Override
    @Nullable
    public ClientScreenshotMetadata getMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = this.screenshotChecksumManager.get(file);
        if (string == null) {
            return null;
        }
        String imageChecksum = string;
        return this.getMetadata(imageChecksum);
    }

    @Nullable
    public final ClientScreenshotMetadata getMetadataCache(@NotNull String mediaId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)mediaId, (String)"mediaId");
            Iterable $this$firstOrNull$iv = this.metadataCache.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ClientScreenshotMetadata it = (ClientScreenshotMetadata)element$iv;
                boolean bl = false;
                if (!it.getMediaIds().contains(mediaId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void writeMetadata(ClientScreenshotMetadata metadata2) {
        this.negativeChecksumCache.remove(metadata2.getChecksum());
        try {
            File file = new File(this.metadataFolder, metadata2.getChecksum());
            String string = this.gson.toJson(SerializedMetadata.Companion.fromMod(metadata2));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void handleExternalDelete(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = this.screenshotChecksumManager.remove(fileName);
        if (string == null) {
            return;
        }
        String checksum = string;
        ClientScreenshotMetadata metadata2 = this.getMetadata(checksum);
        if (metadata2 != null) {
            this.deleteMetadata(metadata2);
        }
    }

    private final void deleteMetadata(ClientScreenshotMetadata metadata2) {
        File metadataFile = new File(this.metadataFolder, metadata2.getChecksum());
        this.metadataCache.remove(metadata2.getChecksum());
        this.updateState(metadata2.getChecksum(), null);
        metadataFile.delete();
    }

    public final void deleteMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ClientScreenshotMetadata metadata2 = this.getMetadata(file);
        if (metadata2 != null) {
            this.deleteMetadata(metadata2);
            this.screenshotChecksumManager.delete(file);
        }
    }

    @Override
    @NotNull
    public synchronized ClientScreenshotMetadata getOrCreateMetadata(@NotNull Path path) {
        ClientScreenshotMetadata clientScreenshotMetadata;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNull((Object)file);
        ClientScreenshotMetadata existingMetadata = this.getMetadata(file);
        if (existingMetadata != null) {
            return existingMetadata;
        }
        String string = this.screenshotChecksumManager.get(file);
        if (string == null) {
            throw new IllegalStateException("No checksum for file " + file + ". Was the file deleted?");
        }
        String checksum = string;
        ClientScreenshotMetadata it = clientScreenshotMetadata = ClientScreenshotMetadata.Companion.createUnknown(path, checksum);
        boolean bl = false;
        this.updateMetadata(it);
        return clientScreenshotMetadata;
    }

    private final void updateState(String checksum, ClientScreenshotMetadata newMetadata) {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)DispatchersKt.getClient(Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, checksum, newMetadata, null){
            int label;
            final /* synthetic */ ScreenshotMetadataManager this$0;
            final /* synthetic */ String $checksum;
            final /* synthetic */ ClientScreenshotMetadata $newMetadata;
            {
                this.this$0 = $receiver;
                this.$checksum = $checksum;
                this.$newMetadata = $newMetadata;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        ResultKt.throwOnFailure((Object)object);
                        MutableState mutableState2 = (MutableState)ScreenshotMetadataManager.access$getStateByChecksum$p(this.this$0).get(this.$checksum);
                        if (mutableState2 != null) {
                            mutableState2.set(this.$newMetadata);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public final State<ClientScreenshotMetadata> metadata(@NotNull String checksum) {
        MutableState<ClientScreenshotMetadata> mutableState2;
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        Map<String, MutableState<ClientScreenshotMetadata>> $this$getOrPut$iv = this.stateByChecksum;
        boolean $i$f$getOrPut = false;
        MutableState<ClientScreenshotMetadata> value$iv = $this$getOrPut$iv.get(checksum);
        if (value$iv == null) {
            boolean bl = false;
            MutableState<ClientScreenshotMetadata> answer$iv = StateKt.mutableStateOf(this.getMetadata(checksum));
            $this$getOrPut$iv.put(checksum, answer$iv);
            mutableState2 = answer$iv;
        } else {
            mutableState2 = value$iv;
        }
        return mutableState2;
    }

    public static final /* synthetic */ Map access$getStateByChecksum$p(ScreenshotMetadataManager $this) {
        return $this.stateByChecksum;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u001d\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000 22\u00020\u0001:\u00012B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u0012\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\t\u0010&\u001a\u00020\fH\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0011\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0010H\u00c6\u0003Jo\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0010H\u00c6\u0001J\u0013\u0010+\u001a\u00020\f2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\u0006\u0010/\u001a\u000200J\t\u00101\u001a\u00020\u0007H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\r\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0019\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017\u00a8\u00063"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager$SerializedMetadata;", "", "authorId", "Ljava/util/UUID;", "time", "Lcom/sparkuniverse/toolbox/util/DateTime;", "checksum", "", "editTime", "locationMetadata", "Lgg/essential/handlers/screenshot/ClientScreenshotMetadata$Location;", "favorite", "", "edited", "mediaId", "moreMediaIds", "", "(Ljava/util/UUID;Lcom/sparkuniverse/toolbox/util/DateTime;Ljava/lang/String;Lcom/sparkuniverse/toolbox/util/DateTime;Lgg/essential/handlers/screenshot/ClientScreenshotMetadata$Location;ZZLjava/lang/String;Ljava/util/List;)V", "getAuthorId", "()Ljava/util/UUID;", "getChecksum", "()Ljava/lang/String;", "getEditTime", "()Lcom/sparkuniverse/toolbox/util/DateTime;", "getEdited", "()Z", "getFavorite", "getLocationMetadata", "()Lgg/essential/handlers/screenshot/ClientScreenshotMetadata$Location;", "getMediaId", "getMoreMediaIds", "()Ljava/util/List;", "getTime", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toMod", "Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "toString", "Companion", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nScreenshotMetadataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotMetadataManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotMetadataManager$SerializedMetadata\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
    private static final class SerializedMetadata {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @SerializedName(value="authorId", alternate={"a"})
        @NotNull
        private final UUID authorId;
        @SerializedName(value="time", alternate={"b"})
        @NotNull
        private final DateTime time;
        @SerializedName(value="checksum", alternate={"c"})
        @NotNull
        private final String checksum;
        @SerializedName(value="editTime")
        @Nullable
        private final DateTime editTime;
        @SerializedName(value="locationMetadata", alternate={"d"})
        @NotNull
        private final ClientScreenshotMetadata.Location locationMetadata;
        @SerializedName(value="favorite", alternate={"e"})
        private final boolean favorite;
        @SerializedName(value="edited", alternate={"f"})
        private final boolean edited;
        @Nullable
        private final String mediaId;
        @Nullable
        private final List<String> moreMediaIds;

        public SerializedMetadata(@NotNull UUID authorId, @NotNull DateTime time2, @NotNull String checksum, @Nullable DateTime editTime, @NotNull ClientScreenshotMetadata.Location locationMetadata, boolean favorite, boolean edited, @Nullable String mediaId, @Nullable List<String> moreMediaIds) {
            Intrinsics.checkNotNullParameter((Object)authorId, (String)"authorId");
            Intrinsics.checkNotNullParameter((Object)time2, (String)"time");
            Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
            Intrinsics.checkNotNullParameter((Object)locationMetadata, (String)"locationMetadata");
            this.authorId = authorId;
            this.time = time2;
            this.checksum = checksum;
            this.editTime = editTime;
            this.locationMetadata = locationMetadata;
            this.favorite = favorite;
            this.edited = edited;
            this.mediaId = mediaId;
            this.moreMediaIds = moreMediaIds;
        }

        public /* synthetic */ SerializedMetadata(UUID uUID, DateTime dateTime, String string, DateTime dateTime2, ClientScreenshotMetadata.Location location, boolean bl, boolean bl2, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x80) != 0) {
                string2 = null;
            }
            if ((n & 0x100) != 0) {
                list = null;
            }
            this(uUID, dateTime, string, dateTime2, location, bl, bl2, string2, list);
        }

        @NotNull
        public final UUID getAuthorId() {
            return this.authorId;
        }

        @NotNull
        public final DateTime getTime() {
            return this.time;
        }

        @NotNull
        public final String getChecksum() {
            return this.checksum;
        }

        @Nullable
        public final DateTime getEditTime() {
            return this.editTime;
        }

        @NotNull
        public final ClientScreenshotMetadata.Location getLocationMetadata() {
            return this.locationMetadata;
        }

        public final boolean getFavorite() {
            return this.favorite;
        }

        public final boolean getEdited() {
            return this.edited;
        }

        @Nullable
        public final String getMediaId() {
            return this.mediaId;
        }

        @Nullable
        public final List<String> getMoreMediaIds() {
            return this.moreMediaIds;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ClientScreenshotMetadata toMod() {
            Set set2;
            UUID uUID = this.authorId;
            DateTime dateTime = this.time;
            String string = this.checksum;
            DateTime dateTime2 = this.editTime;
            ClientScreenshotMetadata.Location location = this.locationMetadata;
            boolean bl = this.favorite;
            boolean bl2 = this.edited;
            if (this.mediaId == null) {
                set2 = SetsKt.emptySet();
            } else if (this.moreMediaIds == null) {
                set2 = SetsKt.setOf((Object)this.mediaId);
            } else {
                void $this$toMod_u24lambda_u240;
                Set set3;
                Set set4 = set3 = SetsKt.createSetBuilder();
                boolean bl3 = bl2;
                boolean bl4 = bl;
                ClientScreenshotMetadata.Location location2 = location;
                DateTime dateTime3 = dateTime2;
                String string2 = string;
                DateTime dateTime4 = dateTime;
                UUID uUID2 = uUID;
                boolean bl5 = false;
                $this$toMod_u24lambda_u240.add(this.mediaId);
                $this$toMod_u24lambda_u240.addAll((Collection)this.moreMediaIds);
                Unit unit = Unit.INSTANCE;
                uUID = uUID2;
                dateTime = dateTime4;
                string = string2;
                dateTime2 = dateTime3;
                location = location2;
                bl = bl4;
                bl2 = bl3;
                set2 = SetsKt.build((Set)set3);
            }
            String string3 = null;
            Set set5 = set2;
            boolean bl6 = bl2;
            boolean bl7 = bl;
            ClientScreenshotMetadata.Location location3 = location;
            DateTime dateTime5 = dateTime2;
            String string4 = string;
            DateTime dateTime6 = dateTime;
            UUID uUID3 = uUID;
            return new ClientScreenshotMetadata(uUID3, dateTime6, string4, dateTime5, location3, bl7, bl6, set5, string3);
        }

        @NotNull
        public final UUID component1() {
            return this.authorId;
        }

        @NotNull
        public final DateTime component2() {
            return this.time;
        }

        @NotNull
        public final String component3() {
            return this.checksum;
        }

        @Nullable
        public final DateTime component4() {
            return this.editTime;
        }

        @NotNull
        public final ClientScreenshotMetadata.Location component5() {
            return this.locationMetadata;
        }

        public final boolean component6() {
            return this.favorite;
        }

        public final boolean component7() {
            return this.edited;
        }

        @Nullable
        public final String component8() {
            return this.mediaId;
        }

        @Nullable
        public final List<String> component9() {
            return this.moreMediaIds;
        }

        @NotNull
        public final SerializedMetadata copy(@NotNull UUID authorId, @NotNull DateTime time2, @NotNull String checksum, @Nullable DateTime editTime, @NotNull ClientScreenshotMetadata.Location locationMetadata, boolean favorite, boolean edited, @Nullable String mediaId, @Nullable List<String> moreMediaIds) {
            Intrinsics.checkNotNullParameter((Object)authorId, (String)"authorId");
            Intrinsics.checkNotNullParameter((Object)time2, (String)"time");
            Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
            Intrinsics.checkNotNullParameter((Object)locationMetadata, (String)"locationMetadata");
            return new SerializedMetadata(authorId, time2, checksum, editTime, locationMetadata, favorite, edited, mediaId, moreMediaIds);
        }

        public static /* synthetic */ SerializedMetadata copy$default(SerializedMetadata serializedMetadata, UUID uUID, DateTime dateTime, String string, DateTime dateTime2, ClientScreenshotMetadata.Location location, boolean bl, boolean bl2, String string2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = serializedMetadata.authorId;
            }
            if ((n & 2) != 0) {
                dateTime = serializedMetadata.time;
            }
            if ((n & 4) != 0) {
                string = serializedMetadata.checksum;
            }
            if ((n & 8) != 0) {
                dateTime2 = serializedMetadata.editTime;
            }
            if ((n & 0x10) != 0) {
                location = serializedMetadata.locationMetadata;
            }
            if ((n & 0x20) != 0) {
                bl = serializedMetadata.favorite;
            }
            if ((n & 0x40) != 0) {
                bl2 = serializedMetadata.edited;
            }
            if ((n & 0x80) != 0) {
                string2 = serializedMetadata.mediaId;
            }
            if ((n & 0x100) != 0) {
                list = serializedMetadata.moreMediaIds;
            }
            return serializedMetadata.copy(uUID, dateTime, string, dateTime2, location, bl, bl2, string2, list);
        }

        @NotNull
        public String toString() {
            return "SerializedMetadata(authorId=" + this.authorId + ", time=" + this.time + ", checksum=" + this.checksum + ", editTime=" + this.editTime + ", locationMetadata=" + this.locationMetadata + ", favorite=" + this.favorite + ", edited=" + this.edited + ", mediaId=" + this.mediaId + ", moreMediaIds=" + this.moreMediaIds + ')';
        }

        public int hashCode() {
            int result = this.authorId.hashCode();
            result = result * 31 + this.time.hashCode();
            result = result * 31 + this.checksum.hashCode();
            result = result * 31 + (this.editTime == null ? 0 : this.editTime.hashCode());
            result = result * 31 + this.locationMetadata.hashCode();
            result = result * 31 + Boolean.hashCode(this.favorite);
            result = result * 31 + Boolean.hashCode(this.edited);
            result = result * 31 + (this.mediaId == null ? 0 : this.mediaId.hashCode());
            result = result * 31 + (this.moreMediaIds == null ? 0 : ((Object)this.moreMediaIds).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedMetadata)) {
                return false;
            }
            SerializedMetadata serializedMetadata = (SerializedMetadata)other;
            if (!Intrinsics.areEqual((Object)this.authorId, (Object)serializedMetadata.authorId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.time, (Object)serializedMetadata.time)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.checksum, (Object)serializedMetadata.checksum)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.editTime, (Object)serializedMetadata.editTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.locationMetadata, (Object)serializedMetadata.locationMetadata)) {
                return false;
            }
            if (this.favorite != serializedMetadata.favorite) {
                return false;
            }
            if (this.edited != serializedMetadata.edited) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mediaId, (Object)serializedMetadata.mediaId)) {
                return false;
            }
            return Intrinsics.areEqual(this.moreMediaIds, serializedMetadata.moreMediaIds);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager$SerializedMetadata$Companion;", "", "()V", "fromMod", "Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager$SerializedMetadata;", "mod", "Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "essential-gui-essential"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SerializedMetadata fromMod(@NotNull ClientScreenshotMetadata mod) {
                Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
                ClientScreenshotMetadata $this$fromMod_u24lambda_u240 = mod;
                boolean bl = false;
                Iterator<String> mediaIdsIter = $this$fromMod_u24lambda_u240.getMediaIds().iterator();
                String firstMediaId = mediaIdsIter.hasNext() ? mediaIdsIter.next() : null;
                List moreMediaIds = mediaIdsIter.hasNext() ? SequencesKt.toList((Sequence)SequencesKt.asSequence(mediaIdsIter)) : null;
                return new SerializedMetadata($this$fromMod_u24lambda_u240.getAuthorId(), $this$fromMod_u24lambda_u240.getTime(), $this$fromMod_u24lambda_u240.getChecksum(), $this$fromMod_u24lambda_u240.getEditTime(), $this$fromMod_u24lambda_u240.getLocationMetadata(), $this$fromMod_u24lambda_u240.getFavorite(), $this$fromMod_u24lambda_u240.getEdited(), firstMediaId, moreMediaIds);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

