/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.providers;

import gg.essential.Essential;
import gg.essential.gui.screenshot.providers.AsyncUploadBackendImpl;
import gg.essential.gui.screenshot.providers.NotAsyncUploadBackend;
import gg.essential.gui.screenshot.providers.UploadBackend;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\r\u001a\u000f\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0001\u0010\u0002\"\"\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\"\"\u0010\n\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u0005\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\"4\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e0\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\"0\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lgg/essential/gui/screenshot/providers/UploadBackend;", "makeUploadBackend", "()Lgg/essential/gui/screenshot/providers/UploadBackend;", "", "asyncErrored", "Z", "getAsyncErrored", "()Z", "setAsyncErrored", "(Z)V", "currentHintsFailed", "getCurrentHintsFailed", "setCurrentHintsFailed", "", "Lkotlin/Pair;", "", "glVersions", "Ljava/util/List;", "getGlVersions", "()Ljava/util/List;", "setGlVersions", "(Ljava/util/List;)V", "workingGlVersion", "Lkotlin/Pair;", "getWorkingGlVersion", "()Lkotlin/Pair;", "setWorkingGlVersion", "(Lkotlin/Pair;)V", "Essential 1.21.7-fabric"})
public final class MinecraftWindowedTextureProviderKt {
    private static boolean asyncErrored;
    private static boolean currentHintsFailed;
    @Nullable
    private static Pair<Integer, Integer> workingGlVersion;
    @NotNull
    private static List<Pair<Integer, Integer>> glVersions;

    public static final boolean getAsyncErrored() {
        return asyncErrored;
    }

    public static final void setAsyncErrored(boolean bl) {
        asyncErrored = bl;
    }

    public static final boolean getCurrentHintsFailed() {
        return currentHintsFailed;
    }

    public static final void setCurrentHintsFailed(boolean bl) {
        currentHintsFailed = bl;
    }

    @Nullable
    public static final Pair<Integer, Integer> getWorkingGlVersion() {
        return workingGlVersion;
    }

    public static final void setWorkingGlVersion(@Nullable Pair<Integer, Integer> pair) {
        workingGlVersion = pair;
    }

    @NotNull
    public static final List<Pair<Integer, Integer>> getGlVersions() {
        return glVersions;
    }

    public static final void setGlVersions(@NotNull List<Pair<Integer, Integer>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        glVersions = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final UploadBackend makeUploadBackend() {
        long window;
        boolean supported;
        String string = System.getProperty("essential.async_texture_loading");
        boolean bl = supported = string != null ? Boolean.parseBoolean(string) : true;
        if (!supported || asyncErrored) {
            return new NotAsyncUploadBackend();
        }
        long mcWindow = GLFW.glfwGetCurrentContext();
        GLFWErrorCallback previousErrorCallback = GLFW.glfwSetErrorCallback(null);
        try {
            if (!currentHintsFailed) {
                Essential.logger.debug("Trying current window hints");
                long window2 = MinecraftWindowedTextureProviderKt.makeUploadBackend$createWindow(mcWindow, null);
                if (window2 != 0L) {
                    UploadBackend uploadBackend2 = new AsyncUploadBackendImpl(window2);
                    return uploadBackend2;
                }
                currentHintsFailed = true;
                Essential.logger.debug("Current window hints failed, trying GL versions");
            }
            GLFW.glfwDefaultWindowHints();
            GLFW.glfwWindowHint((int)139265, (int)196609);
            GLFW.glfwWindowHint((int)139275, (int)221185);
            GLFW.glfwWindowHint((int)139270, (int)GLFW.glfwGetWindowAttrib((long)mcWindow, (int)139270));
            if (workingGlVersion == null) {
                for (Pair<Integer, Integer> pair : glVersions) {
                    int major = ((Number)pair.component1()).intValue();
                    int minor = ((Number)pair.component2()).intValue();
                    Essential.logger.debug("Trying GL version " + major + "." + minor);
                    long window3 = MinecraftWindowedTextureProviderKt.makeUploadBackend$createWindow(mcWindow, (Pair<Integer, Integer>)TuplesKt.to((Object)major, (Object)minor));
                    if (window3 == 0L) continue;
                    Essential.logger.debug("Found working GL version " + major + "." + minor);
                    workingGlVersion = TuplesKt.to((Object)major, (Object)minor);
                    GLFW.glfwGetError(null);
                    UploadBackend uploadBackend3 = new AsyncUploadBackendImpl(window3);
                    return uploadBackend3;
                }
            }
        }
        finally {
            GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)((GLFWErrorCallbackI)previousErrorCallback));
        }
        Pair<Integer, Integer> version = workingGlVersion;
        if (version != null && (window = MinecraftWindowedTextureProviderKt.makeUploadBackend$createWindow(mcWindow, version)) != 0L) {
            return new AsyncUploadBackendImpl(window);
        }
        Essential.logger.warn("Failed to create GLFW window! Falling back to non-async uploads.");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl2 = false;
            PointerBuffer p = stack.mallocPointer(1);
            int error2 = GLFW.glfwGetError((PointerBuffer)p);
            if (error2 != 0) {
                Essential.logger.warn("GLFW Error {}: {}", (Object)error2, (Object)MemoryUtil.memUTF8Safe((long)p.get(0)));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        asyncErrored = true;
        return new NotAsyncUploadBackend();
    }

    private static final long makeUploadBackend$createWindow(long mcWindow, Pair<Integer, Integer> version) {
        if (version != null) {
            int major = ((Number)version.component1()).intValue();
            int minor = ((Number)version.component2()).intValue();
            GLFW.glfwWindowHint((int)139266, (int)major);
            GLFW.glfwWindowHint((int)139267, (int)minor);
            if (major > 3 && minor > 2) {
                GLFW.glfwWindowHint((int)139272, (int)GLFW.glfwGetWindowAttrib((long)mcWindow, (int)139272));
            } else {
                GLFW.glfwWindowHint((int)139272, (int)0);
            }
        }
        GLFW.glfwWindowHint((int)131076, (int)0);
        long window = GLFW.glfwCreateWindow((int)1, (int)1, (CharSequence)"Essential screenshot uploader", (long)0L, (long)mcWindow);
        GLFW.glfwWindowHint((int)131076, (int)1);
        return window;
    }

    public static final /* synthetic */ UploadBackend access$makeUploadBackend() {
        return MinecraftWindowedTextureProviderKt.makeUploadBackend();
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)4, (Object)6), TuplesKt.to((Object)4, (Object)5), TuplesKt.to((Object)4, (Object)4), TuplesKt.to((Object)4, (Object)3), TuplesKt.to((Object)4, (Object)2), TuplesKt.to((Object)4, (Object)1), TuplesKt.to((Object)4, (Object)0), TuplesKt.to((Object)3, (Object)3), TuplesKt.to((Object)3, (Object)2), TuplesKt.to((Object)3, (Object)1), TuplesKt.to((Object)3, (Object)0), TuplesKt.to((Object)2, (Object)1), TuplesKt.to((Object)2, (Object)0)};
        glVersions = CollectionsKt.listOf((Object[])objectArray);
    }
}

