/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import gg.essential.config.EssentialConfig;
import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.IconCosmeticRenderer;
import gg.essential.data.OnboardingData;
import gg.essential.mixins.ext.client.network.NetHandlerPlayClientExt;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.UResolution;
import gg.essential.util.HelpersKt;
import gg.essential.util.UDrawContext;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4597;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class OnlineIndicator {
    public static final ThreadLocal<Boolean> currentlyDrawingPlayerEntityName = ThreadLocal.withInitial(() -> false);
    private static final class_2960 TAB_LIST_ICON = HelpersKt.identifier("essential", "textures/tab_list_icon.png");

    public static boolean currentlyDrawingPlayerEntityName() {
        return currentlyDrawingPlayerEntityName.get();
    }

    public static void drawNametagIndicator(UMatrixStack matrixStack, class_4597 vertexConsumerProvider, CosmeticsRenderState cState, String str, int light) {
        IconCosmeticRenderer.INSTANCE.drawNameTagIconAndVersionConsistentPadding(matrixStack, vertexConsumerProvider, cState, str, light);
    }

    public static int getTextBackgroundOpacity() {
        return (int)(UMinecraft.getMinecraft().field_1690.method_19343(0.25f) * 255.0f);
    }

    public static void drawTabIndicatorOuter(UDrawContext drawContext, class_640 networkPlayerInfo, int x, int y) {
        OnlineIndicator.drawTabIndicator(drawContext, networkPlayerInfo, x, y);
    }

    private static void drawTabIndicator(UDrawContext drawContext, class_640 networkPlayerInfo, int x, int y) {
        float size;
        float centreY;
        float centreX;
        if (!OnboardingData.hasAcceptedTos() || !EssentialConfig.INSTANCE.getShowEssentialIndicatorOnTab() || networkPlayerInfo == null) {
            return;
        }
        EquippedCosmetic cosmetic2 = IconCosmeticRenderer.INSTANCE.getIconCosmetic(networkPlayerInfo);
        if (cosmetic2 == null) {
            return;
        }
        if (UResolution.getScaleFactor() < 4.0) {
            centreX = (float)x - 7.5f;
            centreY = (float)y + 1.5f;
            size = 5.0f;
        } else {
            centreX = (float)x - 7.5f - 0.375f;
            centreY = (float)y + 1.5f - 0.375f;
            size = 3.75f;
        }
        IconCosmeticRenderer.INSTANCE.drawTextureInTabList(drawContext, centreX, centreY, TAB_LIST_ICON, size, false);
    }

    public static UUID findUUIDFromDisplayName(class_2561 displayName) {
        String[] nameParts;
        if (displayName == null) {
            return null;
        }
        class_634 netHandler = UMinecraft.getNetHandler();
        if (netHandler == null) {
            return null;
        }
        Map<String, UUID> nameToIdCache = ((NetHandlerPlayClientExt)netHandler).essential$getNameIdCache();
        String unformattedText = displayName.getString();
        for (String part : nameParts = unformattedText.replaceAll("\\W", " ").split(" ")) {
            if (part.isEmpty() || !nameToIdCache.containsKey(part)) continue;
            return nameToIdCache.get(part);
        }
        return null;
    }

    public static void beforeTabDraw() {
    }

    public static void afterTabDraw() {
    }
}

