/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers.io;

import gg.essential.handlers.io.FileEventType;
import gg.essential.handlers.io.FileSystemEvent;
import gg.essential.util.DispatchersKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u0010H\u0002J$\u0010\u001e\u001a\u00020\u00102\u001c\u0010\u001f\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\rj\u0002`\u0011J$\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00032\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u0010H\u0002J\b\u0010&\u001a\u00020\u0010H\u0002J\u0014\u0010'\u001a\n \u001c*\u0004\u0018\u00010\u00150\u0015*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\rj\u0002`\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lgg/essential/handlers/io/DirectoryWatcher;", "", "base", "Ljava/nio/file/Path;", "recursive", "", "batchOperationDelay", "", "batchOperationUnit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/nio/file/Path;ZJLjava/util/concurrent/TimeUnit;)V", "delayedBatchEventListeners", "", "Lkotlin/Function1;", "", "Lgg/essential/handlers/io/FileSystemEvent;", "", "Lgg/essential/handlers/io/FileSystemEventListConsumer;", "filesystemOperations", "keys", "", "Ljava/nio/file/WatchKey;", "operationDrainer", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "watchService", "Ljava/nio/file/WatchService;", "kotlin.jvm.PlatformType", "init", "onBatchUpdate", "event", "processEvent", "path", "kind", "Ljava/nio/file/WatchEvent$Kind;", "initialScan", "processEvents", "scheduleOperationDrainer", "registerCMD", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nDirectoryWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryWatcher.kt\ngg/essential/handlers/io/DirectoryWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1855#2,2:158\n1#3:160\n*S KotlinDebug\n*F\n+ 1 DirectoryWatcher.kt\ngg/essential/handlers/io/DirectoryWatcher\n*L\n82#1:158,2\n*E\n"})
public final class DirectoryWatcher {
    @NotNull
    private final Path base;
    private final boolean recursive;
    private final long batchOperationDelay;
    @NotNull
    private final TimeUnit batchOperationUnit;
    private final WatchService watchService;
    @NotNull
    private final Map<WatchKey, Path> keys;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private Job operationDrainer;
    @NotNull
    private final List<FileSystemEvent> filesystemOperations;
    @NotNull
    private final List<Function1<List<FileSystemEvent>, Unit>> delayedBatchEventListeners;

    public DirectoryWatcher(@NotNull Path base, boolean recursive, long batchOperationDelay, @NotNull TimeUnit batchOperationUnit) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)((Object)batchOperationUnit), (String)"batchOperationUnit");
        this.base = base;
        this.recursive = recursive;
        this.batchOperationDelay = batchOperationDelay;
        this.batchOperationUnit = batchOperationUnit;
        this.watchService = this.base.getFileSystem().newWatchService();
        this.keys = new LinkedHashMap();
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DispatchersKt.getClient(Dispatchers.INSTANCE)));
        this.filesystemOperations = new ArrayList();
        this.delayedBatchEventListeners = new ArrayList();
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("essential-watch-service-" + this.base.getFileName())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DirectoryWatcher this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.init();
                        this.this$0.processEvents();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void init() {
        if (this.recursive) {
            WatchEvent.Kind<Path> kind = StandardWatchEventKinds.ENTRY_CREATE;
            Intrinsics.checkNotNullExpressionValue(kind, (String)"ENTRY_CREATE");
            this.processEvent(this.base, kind, true);
        } else {
            this.registerCMD(this.base);
        }
    }

    private final void processEvents() {
        while (true) {
            WatchKey key = this.watchService.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                Path base;
                WatchEvent.Kind<?> kind = event.kind();
                Object obj = event.context();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.nio.file.Path");
                Path name2 = (Path)obj;
                if (this.keys.get(key) == null) continue;
                Path path = base.resolve(name2);
                Intrinsics.checkNotNull((Object)path);
                Intrinsics.checkNotNull(kind);
                this.processEvent(path, kind, false);
            }
            key.reset();
        }
    }

    public final void onBatchUpdate(@NotNull Function1<? super List<FileSystemEvent>, Unit> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.delayedBatchEventListeners.add(event);
    }

    private final void processEvent(Path path, WatchEvent.Kind<?> kind, boolean initialScan) {
        if (this.recursive) {
            WatchEvent.Kind<?> kind2 = kind;
            if (Intrinsics.areEqual(kind2, StandardWatchEventKinds.ENTRY_CREATE)) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.registerCMD(path);
                    Iterable $this$forEach$iv = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path it = (Path)element$iv;
                        boolean bl = false;
                        WatchEvent.Kind<Path> kind3 = StandardWatchEventKinds.ENTRY_CREATE;
                        Intrinsics.checkNotNullExpressionValue(kind3, (String)"ENTRY_CREATE");
                        this.processEvent(it, kind3, initialScan);
                    }
                }
            } else if (Intrinsics.areEqual(kind2, StandardWatchEventKinds.ENTRY_DELETE)) {
                this.keys.entrySet().removeIf(arg_0 -> DirectoryWatcher.processEvent$lambda$1((Function1)new Function1<Map.Entry<WatchKey, Path>, Boolean>(path){
                    final /* synthetic */ Path $path;
                    {
                        this.$path = $path;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Map.Entry<WatchKey, Path> entry2) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter(entry2, (String)"<name for destructuring parameter 0>");
                        WatchKey key = entry2.getKey();
                        Path child = entry2.getValue();
                        if (child.startsWith(this.$path)) {
                            key.cancel();
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }
                }, arg_0));
            }
        }
        if (initialScan) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(kind, this, path, null){
            int label;
            final /* synthetic */ WatchEvent.Kind<?> $kind;
            final /* synthetic */ DirectoryWatcher this$0;
            final /* synthetic */ Path $path;
            {
                this.$kind = $kind;
                this.this$0 = $receiver;
                this.$path = $path;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WatchEvent.Kind<?> kind = this.$kind;
                        if (Intrinsics.areEqual(kind, StandardWatchEventKinds.ENTRY_CREATE)) {
                            DirectoryWatcher.access$getFilesystemOperations$p(this.this$0).add(new FileSystemEvent(this.$path, FileEventType.CREATE));
                        } else if (Intrinsics.areEqual(kind, StandardWatchEventKinds.ENTRY_DELETE)) {
                            DirectoryWatcher.access$getFilesystemOperations$p(this.this$0).add(new FileSystemEvent(this.$path, FileEventType.DELETE));
                        } else if (Intrinsics.areEqual(kind, StandardWatchEventKinds.ENTRY_MODIFY)) {
                            DirectoryWatcher.access$getFilesystemOperations$p(this.this$0).add(new FileSystemEvent(this.$path, FileEventType.MODIFY));
                        }
                        DirectoryWatcher.access$scheduleOperationDrainer(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void scheduleOperationDrainer() {
        Job job = this.operationDrainer;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.operationDrainer = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DirectoryWatcher this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)DirectoryWatcher.access$getBatchOperationUnit$p(this.this$0).toMillis(DirectoryWatcher.access$getBatchOperationDelay$p(this.this$0)), (Continuation)((Continuation)this));
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        list = CollectionsKt.toList((Iterable)DirectoryWatcher.access$getFilesystemOperations$p(this.this$0));
                        DirectoryWatcher.access$getFilesystemOperations$p(this.this$0).clear();
                        $this$forEach$iv = DirectoryWatcher.access$getDelayedBatchEventListeners$p(this.this$0);
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Function1)element$iv;
                            $i$a$-forEach-DirectoryWatcher$scheduleOperationDrainer$1$1 = false;
                            it.invoke((Object)list);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final WatchKey registerCMD(Path $this$registerCMD) {
        Object object = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
        Object it = object = $this$registerCMD.register(this.watchService, (WatchEvent.Kind<?>)object);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        this.keys.put((WatchKey)it, $this$registerCMD);
        return object;
    }

    private static final boolean processEvent$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getFilesystemOperations$p(DirectoryWatcher $this) {
        return $this.filesystemOperations;
    }

    public static final /* synthetic */ void access$scheduleOperationDrainer(DirectoryWatcher $this) {
        $this.scheduleOperationDrainer();
    }

    public static final /* synthetic */ TimeUnit access$getBatchOperationUnit$p(DirectoryWatcher $this) {
        return $this.batchOperationUnit;
    }

    public static final /* synthetic */ long access$getBatchOperationDelay$p(DirectoryWatcher $this) {
        return $this.batchOperationDelay;
    }

    public static final /* synthetic */ List access$getDelayedBatchEventListeners$p(DirectoryWatcher $this) {
        return $this.delayedBatchEventListeners;
    }
}

