/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.image.imagescaling;

import gg.essential.image.imagescaling.ResampleFilter;

final class Lanczos3Filter
implements ResampleFilter {
    private static final float PI_FLOAT = (float)Math.PI;

    Lanczos3Filter() {
    }

    private float sincModified(float value) {
        return (float)Math.sin(value) / value;
    }

    @Override
    public final float apply(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        if (value < 0.0f) {
            value = -value;
        }
        if (value < 3.0f) {
            return this.sincModified(value *= (float)Math.PI) * this.sincModified(value / 3.0f);
        }
        return 0.0f;
    }

    @Override
    public float getSamplingRadius() {
        return 3.0f;
    }

    @Override
    public String getName() {
        return "Lanczos3";
    }
}

