/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.lib.apache.commons;

import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?: |\\u00A0|\\s|[\\s&&[^ ]])\\s*");

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String str, String separator) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String removeStart(String str, String remove2) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove2)) {
            return str;
        }
        if (str.startsWith(remove2)) {
            return str.substring(remove2.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove2) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove2)) {
            return str;
        }
        if (str.endsWith(remove2)) {
            return str.substring(0, str.length() - remove2.length());
        }
        return str;
    }

    public static String replaceOnce(String text2, String searchString, String replacement) {
        return StringUtils.replace(text2, searchString, replacement, 1);
    }

    public static String replace(String text2, String searchString, String replacement, int max) {
        if (StringUtils.isEmpty(text2) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text2;
        }
        int start2 = 0;
        int end = text2.indexOf(searchString, start2);
        if (end == -1) {
            return text2;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text2.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text2.substring(start2, end)).append(replacement);
            start2 = end + replLength;
            if (--max == 0) break;
            end = text2.indexOf(searchString, start2);
        }
        buf.append(text2.substring(start2));
        return buf.toString();
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i2 = repeat - 1; i2 >= 0; --i2) {
            buf[i2] = ch;
        }
        return new String(buf);
    }
}

