/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.utils;

import java.lang.reflect.Field;

interface InternalField<O, T> {
    public T get(O var1);

    public void set(O var1, T var2);

    public static <O, T> InternalField<O, T> of(final Class<?> clazz, final String name2) {
        Field impl;
        try {
            impl = clazz.getDeclaredField(name2);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Failed to find field %s::%s! Please report to LlamaLad7!", clazz, name2), e);
        }
        impl.setAccessible(true);
        return new InternalField<O, T>(){

            @Override
            public T get(O owner) {
                try {
                    return impl.get(owner);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(String.format("Failed to get %s::%s on %s! Please report to LlamaLad7!", clazz, name2, owner), e);
                }
            }

            @Override
            public void set(O owner, T newValue) {
                try {
                    impl.set(owner, newValue);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(String.format("Failed to set %s::%s to %s on %s! Please report to LlamaLad7!", clazz, name2, newValue, owner), e);
                }
            }
        };
    }

    public static <O, T> InternalField<O, T> of(String clazz, String name2) {
        try {
            return InternalField.of(Class.forName(clazz), name2);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Failed to find class %s! Please report to LlamaLad7!", clazz), e);
        }
    }
}

