/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

interface InternalMethod<O, R> {
    public R call(O var1, Object ... var2);

    public static <O, R> InternalMethod<O, R> of(Class<?> clazz, String name2, Class<?> ... argTypes) {
        Method impl;
        try {
            impl = clazz.getDeclaredMethod(name2, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Failed to find method %s::%s(%s)! Please report to LlamaLad7!", clazz, name2, Arrays.stream(argTypes).map(Class::getName).collect(Collectors.joining(", "))), e);
        }
        impl.setAccessible(true);
        return (owner, args) -> {
            try {
                return impl.invoke(owner, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(String.format("Failed to call %s::%s(%s) with args [%s]! Please report to LlamaLad7!", clazz, name2, Arrays.stream(argTypes).map(Class::getName).collect(Collectors.joining(", ")), Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "))), e);
            }
        };
    }

    public static <O, R> InternalMethod<O, R> of(String clazz, String name2, Class<?> ... argTypes) {
        try {
            return InternalMethod.of(Class.forName(clazz), name2, argTypes);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Failed to find class %s! Please report to LlamaLad7!", clazz), e);
        }
    }
}

