/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.sps;

import gg.essential.Essential;
import gg.essential.network.connectionmanager.ice.IceManager;
import gg.essential.sps.SpsAddress;
import gg.essential.sps.quic.jvm.UtilKt;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.class_3521;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_3521.class})
public class Mixin_ResolveSpsResourcePackUrl {
    @ModifyVariable(method={"download"}, at=@At(value="HEAD"), argsOnly=true)
    private static URL resolveSpsUrl(URL url) throws MalformedURLException {
        if (SpsAddress.parse(url.getHost()) == null) {
            return url;
        }
        IceManager iceManager = Essential.getInstance().getConnectionManager().getIceManager();
        Integer proxyHttpPort = iceManager.getProxyHttpPort();
        if (proxyHttpPort == null) {
            Essential.logger.warn("Received resource pack url with SPS target but http proxy is not available: {}", (Object)url);
            return url;
        }
        return new URL(url.getProtocol(), UtilKt.getLOCALHOST().getHostAddress(), proxyHttpPort, url.getFile());
    }
}

