/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.molang;

import gg.essential.model.molang.AbsExpr;
import gg.essential.model.molang.AddExpr;
import gg.essential.model.molang.AssignmentExpr;
import gg.essential.model.molang.CeilExpr;
import gg.essential.model.molang.ClampExpr;
import gg.essential.model.molang.ComparisonExpr;
import gg.essential.model.molang.CosExpr;
import gg.essential.model.molang.DivExpr;
import gg.essential.model.molang.FloorExpr;
import gg.essential.model.molang.LiteralExpr;
import gg.essential.model.molang.LogicalAndExpr;
import gg.essential.model.molang.LogicalOrExpr;
import gg.essential.model.molang.MolangExpression;
import gg.essential.model.molang.MolangParserException;
import gg.essential.model.molang.MolangVariable;
import gg.essential.model.molang.MulExpr;
import gg.essential.model.molang.NegExpr;
import gg.essential.model.molang.QueryExpr;
import gg.essential.model.molang.RandomExpr;
import gg.essential.model.molang.ReturnExpr;
import gg.essential.model.molang.RoundExpr;
import gg.essential.model.molang.SinExpr;
import gg.essential.model.molang.StatementsExpr;
import gg.essential.model.molang.SubExpr;
import gg.essential.model.molang.TernaryExpr;
import gg.essential.model.molang.TruncExpr;
import gg.essential.model.molang.VariableExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012J\u0006\u0010\u001e\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0012J\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0012J\u0006\u0010#\u001a\u00020\u0012J/\u0010$\u001a\u00020%2!\u0010&\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020%0'H\u0086\b\u00f8\u0001\u0000J\u000e\u0010$\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0006J\u000e\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020%2\u0006\u0010*\u001a\u00020,J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020\u0012R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00060"}, d2={"Lgg/essential/model/molang/Parser;", "", "str", "", "(Ljava/lang/String;)V", "curr", "", "getCurr", "()C", "i", "", "getI", "()I", "setI", "(I)V", "getStr", "()Ljava/lang/String;", "fullyParseMolang", "Lgg/essential/model/molang/MolangExpression;", "parseAssignment", "parseComparisons", "parseEqualityChecks", "parseExpression", "parseIdentifier", "parseLiteral", "Lgg/essential/model/molang/LiteralExpr;", "parseLogicalAnds", "parseLogicalOrs", "parseMolang", "parseNullCoalescing", "parseProduct", "parseSimpleExpression", "parseStatement", "parseStatements", "parseSum", "parseTernary", "reads", "", "f", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "char", "s", "Lkotlin/ranges/CharRange;", "skipWhitespace", "", "tryFullyParseMolang", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nMolangExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MolangExpression.kt\ngg/essential/model/molang/Parser\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,561:1\n297#1,9:562\n297#1,9:571\n297#1,9:580\n297#1,9:589\n383#2,4:598\n1#3:602\n*S KotlinDebug\n*F\n+ 1 MolangExpression.kt\ngg/essential/model/molang/Parser\n*L\n295#1:562,9\n296#1:571,9\n317#1:580,9\n334#1:589,9\n335#1:598,4\n*E\n"})
final class Parser {
    @NotNull
    private final String str;
    private int i;

    public Parser(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = str.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.str = string;
    }

    @NotNull
    public final String getStr() {
        return this.str;
    }

    public final int getI() {
        return this.i;
    }

    public final void setI(int n) {
        this.i = n;
    }

    public final char getCurr() {
        return this.str.charAt(this.i);
    }

    public final boolean reads(char c) {
        boolean bl;
        Parser this_$iv = this;
        boolean $i$f$reads = false;
        if (this_$iv.getI() >= this_$iv.getStr().length()) {
            bl = false;
        } else {
            char it = this_$iv.getCurr();
            boolean bl2 = false;
            if (it == c) {
                int n = this_$iv.getI();
                this_$iv.setI(n + 1);
                this_$iv.skipWhitespace();
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public final boolean reads(@NotNull CharRange charRange) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)charRange, (String)"char");
        Parser this_$iv = this;
        boolean $i$f$reads = false;
        if (this_$iv.getI() >= this_$iv.getStr().length()) {
            bl = false;
        } else {
            char it = this_$iv.getCurr();
            boolean bl2 = false;
            char c = charRange.getFirst();
            boolean bl3 = it <= charRange.getLast() ? c <= it : false;
            if (bl3) {
                int n = this_$iv.getI();
                this_$iv.setI(n + 1);
                this_$iv.skipWhitespace();
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public final boolean reads(@NotNull Function1<? super Character, Boolean> f) {
        boolean bl;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$reads = false;
        if (this.getI() >= this.getStr().length()) {
            bl = false;
        } else if (((Boolean)f.invoke((Object)Character.valueOf(this.getCurr()))).booleanValue()) {
            int n = this.getI();
            this.setI(n + 1);
            this.skipWhitespace();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean reads(@NotNull String s) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (StringsKt.startsWith$default((String)this.str, (String)s, (int)this.i, (boolean)false, (int)4, null)) {
            this.i += s.length();
            this.skipWhitespace();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void skipWhitespace() {
        boolean bl;
        do {
            Parser this_$iv = this;
            boolean $i$f$reads = false;
            if (this_$iv.getI() >= this_$iv.getStr().length()) {
                bl = false;
                continue;
            }
            char it = this_$iv.getCurr();
            boolean bl2 = false;
            if (CharsKt.isWhitespace((char)it)) {
                int n = this_$iv.getI();
                this_$iv.setI(n + 1);
                this_$iv.skipWhitespace();
                bl = true;
                continue;
            }
            bl = false;
        } while (bl);
    }

    @NotNull
    public final LiteralExpr parseLiteral() {
        int start2 = this.i;
        while (this.reads(new CharRange('0', '9'))) {
        }
        if (this.reads('.')) {
            while (this.reads(new CharRange('0', '9'))) {
            }
        }
        this.reads('f');
        return new LiteralExpr(Float.parseFloat(StringsKt.replace$default((String)StringsKt.slice((String)this.str, (IntRange)RangesKt.until((int)start2, (int)this.i)), (String)" ", (String)"", (boolean)false, (int)4, null)));
    }

    @NotNull
    public final String parseIdentifier() {
        String string;
        block4: {
            boolean bl;
            int start2 = this.i;
            do {
                Parser this_$iv = this;
                boolean $i$f$reads = false;
                if (this_$iv.getI() >= this_$iv.getStr().length()) {
                    bl = false;
                    continue;
                }
                int it = this_$iv.getCurr();
                boolean bl2 = false;
                if (Character.isLetterOrDigit((char)it) || it == 95) {
                    it = this_$iv.getI();
                    this_$iv.setI(it + 1);
                    this_$iv.skipWhitespace();
                    bl = true;
                    continue;
                }
                bl = false;
            } while (bl);
            String $this$dropLastWhile$iv = StringsKt.slice((String)this.str, (IntRange)RangesKt.until((int)start2, (int)this.i));
            boolean $i$f$dropLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$dropLastWhile$iv.charAt(index$iv);
                boolean bl3 = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$dropLastWhile$iv;
                int n = 0;
                int n2 = index$iv + 1;
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block4;
            }
            string = "";
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final MolangExpression parseSimpleExpression() {
        List args;
        String qualified;
        String qualifier;
        MolangExpression molangExpression;
        block68: {
            QueryExpr queryExpr;
            if (this.reads('(')) {
                MolangExpression molangExpression2;
                MolangExpression it = molangExpression2 = this.parseExpression();
                boolean bl = false;
                this.reads(')');
                molangExpression = molangExpression2;
                return molangExpression;
            }
            if (this.reads('{')) {
                MolangExpression molangExpression3;
                MolangExpression it = molangExpression3 = this.parseStatements();
                boolean bl = false;
                this.reads('}');
                molangExpression = molangExpression3;
                return molangExpression;
            }
            char c = this.getCurr();
            boolean bl = '0' <= c ? c < ':' : false;
            if (bl) {
                molangExpression = this.parseLiteral();
                return molangExpression;
            }
            if (this.getCurr() == '-') {
                this.reads('-');
                molangExpression = new NegExpr(this.parseSimpleExpression());
                return molangExpression;
            }
            qualifier = this.parseIdentifier();
            if (((CharSequence)qualifier).length() == 0) {
                throw new IllegalArgumentException("Unexpected identifier at index " + this.i);
            }
            if (!this.reads(".")) {
                throw new IllegalArgumentException("Expected `.` at index " + this.i);
            }
            qualified = this.parseIdentifier();
            if (((CharSequence)qualified).length() == 0) {
                throw new IllegalArgumentException("Unexpected identifier at index " + this.i);
            }
            args = new ArrayList();
            if (this.reads('(')) {
                do {
                    args.add(this.parseExpression());
                } while (this.reads(','));
                this.reads(')');
            }
            String string = qualifier;
            switch (string.hashCode()) {
                case 113: {
                    if (string.equals("q")) break;
                    throw new IllegalArgumentException("Unknown qualifier `" + qualifier + '`');
                }
                case 118: {
                    if (!string.equals("v")) {
                        throw new IllegalArgumentException("Unknown qualifier `" + qualifier + '`');
                    }
                    break block68;
                }
                case 107944136: {
                    if (string.equals("query")) break;
                    throw new IllegalArgumentException("Unknown qualifier `" + qualifier + '`');
                }
                case -1249586564: {
                    if (!string.equals("variable")) {
                        throw new IllegalArgumentException("Unknown qualifier `" + qualifier + '`');
                    }
                    break block68;
                }
                case 3344136: {
                    if (!string.equals("math")) throw new IllegalArgumentException("Unknown qualifier `" + qualifier + '`');
                    switch (qualified) {
                        case "pi": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 0);
                            molangExpression = new LiteralExpr((float)Math.PI);
                            return molangExpression;
                        }
                        case "cos": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 1);
                            molangExpression = new CosExpr((MolangExpression)args.get(0));
                            return molangExpression;
                        }
                        case "sin": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 1);
                            molangExpression = new SinExpr((MolangExpression)args.get(0));
                            return molangExpression;
                        }
                        case "floor": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 1);
                            molangExpression = new FloorExpr((MolangExpression)args.get(0));
                            return molangExpression;
                        }
                        case "ceil": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 1);
                            molangExpression = new CeilExpr((MolangExpression)args.get(0));
                            return molangExpression;
                        }
                        case "round": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 1);
                            molangExpression = new RoundExpr((MolangExpression)args.get(0));
                            return molangExpression;
                        }
                        case "trunc": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 1);
                            molangExpression = new TruncExpr((MolangExpression)args.get(0));
                            return molangExpression;
                        }
                        case "abs": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 1);
                            molangExpression = new AbsExpr((MolangExpression)args.get(0));
                            return molangExpression;
                        }
                        case "clamp": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 3);
                            molangExpression = new ClampExpr((MolangExpression)args.get(0), (MolangExpression)args.get(1), (MolangExpression)args.get(2));
                            return molangExpression;
                        }
                        case "random": {
                            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 2);
                            molangExpression = new RandomExpr((MolangExpression)args.get(0), (MolangExpression)args.get(1));
                            return molangExpression;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown math function `" + qualified + '`');
                        }
                    }
                }
            }
            Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 0);
            switch (qualified) {
                case "anim_time": {
                    queryExpr = QueryExpr.AnimTime.INSTANCE;
                    break;
                }
                case "life_time": {
                    queryExpr = QueryExpr.LifeTime.INSTANCE;
                    break;
                }
                case "modified_move_speed": {
                    queryExpr = QueryExpr.ModifiedMoveSpeed.INSTANCE;
                    break;
                }
                case "modified_distance_moved": {
                    queryExpr = QueryExpr.ModifiedDistanceMoved.INSTANCE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown query `" + qualified + '`');
                }
            }
            molangExpression = queryExpr;
            return molangExpression;
        }
        Parser.parseSimpleExpression$checkArgs(args, qualifier, qualified, 0);
        molangExpression = new VariableExpr(qualified);
        return molangExpression;
        throw new IllegalArgumentException("Unknown qualifier `" + qualifier + '`');
    }

    @NotNull
    public final MolangExpression parseProduct() {
        MolangExpression left = this.parseSimpleExpression();
        while (true) {
            MolangExpression molangExpression;
            if (this.reads('*')) {
                molangExpression = new MulExpr(left, this.parseSimpleExpression());
            } else if (this.reads('/')) {
                molangExpression = new DivExpr(left, this.parseSimpleExpression());
            } else {
                return left;
            }
            left = molangExpression;
        }
    }

    @NotNull
    public final MolangExpression parseSum() {
        MolangExpression left = this.parseProduct();
        while (true) {
            MolangExpression molangExpression;
            if (this.reads('+')) {
                molangExpression = new AddExpr(left, this.parseProduct());
            } else if (this.reads('-')) {
                molangExpression = new SubExpr(left, this.parseProduct());
            } else {
                return left;
            }
            left = molangExpression;
        }
    }

    @NotNull
    public final MolangExpression parseComparisons() {
        MolangExpression left = this.parseSum();
        return this.reads("<=") ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.LessThanOrEqual) : (this.reads(">=") ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.GreaterThanOrEqual) : (this.reads('<') ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.LessThan) : (this.reads('>') ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.GreaterThan) : left)));
    }

    @NotNull
    public final MolangExpression parseEqualityChecks() {
        MolangExpression left = this.parseComparisons();
        return this.reads("==") ? (MolangExpression)new ComparisonExpr(left, this.parseComparisons(), ComparisonExpr.Op.Equal) : (this.reads("!=") ? (MolangExpression)new ComparisonExpr(left, this.parseComparisons(), ComparisonExpr.Op.NotEqual) : left);
    }

    @NotNull
    public final MolangExpression parseLogicalAnds() {
        MolangExpression left = this.parseEqualityChecks();
        while (this.reads("&&")) {
            left = new LogicalAndExpr(left, this.parseEqualityChecks());
        }
        return left;
    }

    @NotNull
    public final MolangExpression parseLogicalOrs() {
        MolangExpression left = this.parseLogicalAnds();
        while (this.reads("||")) {
            left = new LogicalOrExpr(left, this.parseLogicalAnds());
        }
        return left;
    }

    @NotNull
    public final MolangExpression parseTernary() {
        MolangExpression molangExpression;
        MolangExpression condition = this.parseLogicalOrs();
        if (this.reads('?')) {
            MolangExpression trueCase = this.parseTernary();
            this.reads(':');
            MolangExpression falseCase = this.parseTernary();
            molangExpression = new TernaryExpr(condition, trueCase, falseCase);
        } else {
            molangExpression = condition;
        }
        return molangExpression;
    }

    @NotNull
    public final MolangExpression parseNullCoalescing() {
        return this.parseTernary();
    }

    @NotNull
    public final MolangExpression parseExpression() {
        return this.parseNullCoalescing();
    }

    @NotNull
    public final MolangExpression parseAssignment() {
        MolangExpression left = this.parseExpression();
        if (!this.reads('=')) {
            return left;
        }
        if (!(left instanceof MolangVariable)) {
            throw new IllegalArgumentException("Cannot assign value to " + left);
        }
        MolangExpression right = this.parseExpression();
        return new AssignmentExpr((MolangVariable)((Object)left), right);
    }

    @NotNull
    public final MolangExpression parseStatement() {
        return this.reads("return") ? (MolangExpression)new ReturnExpr(this.parseExpression()) : this.parseAssignment();
    }

    @NotNull
    public final MolangExpression parseStatements() {
        MolangExpression first = this.parseStatement();
        if (!this.reads(';')) {
            return first;
        }
        Object[] objectArray = new MolangExpression[]{first};
        List statements = CollectionsKt.mutableListOf((Object[])objectArray);
        while (this.i < this.str.length() && this.getCurr() != '}') {
            statements.add(this.parseStatement());
            this.reads(';');
        }
        return new StatementsExpr(statements);
    }

    @NotNull
    public final MolangExpression parseMolang() {
        this.skipWhitespace();
        return this.parseStatements();
    }

    @NotNull
    public final MolangExpression fullyParseMolang() {
        MolangExpression molangExpression;
        MolangExpression it = molangExpression = this.parseMolang();
        boolean bl = false;
        if (this.i < this.str.length()) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to fully parse input, remaining: ");
            String string = this.str.substring(this.i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            throw new IllegalArgumentException(stringBuilder.append(string).toString());
        }
        return molangExpression;
    }

    @NotNull
    public final MolangExpression tryFullyParseMolang() {
        MolangExpression molangExpression;
        try {
            molangExpression = this.fullyParseMolang();
        }
        catch (Exception e) {
            throw new MolangParserException("Failed to parse `" + this.str + "`:", e);
        }
        return molangExpression;
    }

    private static final void parseSimpleExpression$checkArgs(List<MolangExpression> args, String qualifier, String qualified, int count) {
        if (args.size() != count) {
            throw new IllegalArgumentException('`' + qualifier + '.' + qualified + "` takes " + count + " arguments but " + args.size() + " were given");
        }
    }
}

