/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.cosmetics;

import gg.essential.cosmetics.DiagnosticsKt;
import gg.essential.cosmetics.skinmask.SkinMask;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.Response;
import gg.essential.mod.EssentialAsset;
import gg.essential.mod.asset.AssetProvider;
import gg.essential.mod.cosmetics.featured.FeaturedPageCollection;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.file.AnimationFile;
import gg.essential.model.file.ModelFile;
import gg.essential.model.file.ParticlesFile;
import gg.essential.model.file.SoundDefinitionsFile;
import gg.essential.network.connectionmanager.cosmetics.AssetLoader;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.util.HttpUtils;
import gg.essential.util.LimitedExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.future.FutureKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \"2\u00020\u0001:\u000b\u001f !\"#$%&'()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u001e\u001a\u00020\u0003*\u00020\u0012H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;", "", "cachePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "assets", "", "", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetState;", "diskExecutor", "Lgg/essential/util/LimitedExecutor;", "networkExecutor", "pool", "Ljava/util/concurrent/ThreadPoolExecutor;", "getAsset", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Asset;", "T", "asset", "Lgg/essential/mod/EssentialAsset;", "priority", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;", "type", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "getAssetBytes", "Ljava/util/concurrent/CompletableFuture;", "", "getKnownAsset", "checksum", "getProvider", "Lgg/essential/mod/asset/AssetProvider;", "getAssetCachePath", "Asset", "AssetState", "AssetType", "Companion", "Download", "JsonAssetType", "ParseException", "Priority", "SaveToCache", "Step", "TryLoadFromCache", "essential-gui-essential"})
public final class AssetLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path cachePath;
    @NotNull
    private final ThreadPoolExecutor pool;
    @NotNull
    private final LimitedExecutor networkExecutor;
    @NotNull
    private final LimitedExecutor diskExecutor;
    @NotNull
    private final Map<String, AssetState> assets;
    private static final Logger logger = LoggerFactory.getLogger(AssetLoader.class);

    /*
     * WARNING - void declaration
     */
    public AssetLoader(@NotNull Path cachePath) {
        void threadId;
        Intrinsics.checkNotNullParameter((Object)cachePath, (String)"cachePath");
        this.cachePath = cachePath;
        AtomicInteger atomicInteger = new AtomicInteger();
        BlockingQueue blockingQueue = new LinkedBlockingQueue();
        TimeUnit timeUnit = TimeUnit.SECONDS;
        long l = 10L;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        AssetLoader assetLoader = this;
        boolean bl = false;
        ThreadFactory threadFactory = arg_0 -> AssetLoader.pool$lambda$1$lambda$0((AtomicInteger)threadId, arg_0);
        ThreadFactory threadFactory2 = threadFactory;
        BlockingQueue blockingQueue2 = blockingQueue;
        TimeUnit timeUnit2 = timeUnit;
        long l2 = l;
        int n3 = n;
        int n4 = n2;
        assetLoader.pool = new ThreadPoolExecutor(n4, n3, l2, timeUnit2, (BlockingQueue<Runnable>)blockingQueue2, threadFactory2);
        this.networkExecutor = new LimitedExecutor(this.pool, 10, new PriorityBlockingQueue());
        this.diskExecutor = new LimitedExecutor(this.pool, 10, new PriorityBlockingQueue());
        this.assets = new ConcurrentHashMap();
    }

    @NotNull
    public final CompletableFuture<byte[]> getAssetBytes(@NotNull EssentialAsset asset, @NotNull Priority priority) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        AssetState assetState = this.assets.computeIfAbsent(asset.getChecksum(), arg_0 -> AssetLoader.getAssetBytes$lambda$2((Function1)new Function1<String, AssetState>(this, asset){
            final /* synthetic */ AssetLoader this$0;
            final /* synthetic */ EssentialAsset $asset;
            {
                this.this$0 = $receiver;
                this.$asset = $asset;
                super(1);
            }

            @NotNull
            public final AssetState invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.new AssetState(this.$asset);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)assetState, (String)"computeIfAbsent(...)");
        AssetState state2 = assetState;
        state2.ensurePriorityAtLeast(priority);
        return state2.getFuture();
    }

    @NotNull
    public final AssetProvider getProvider(@NotNull Priority priority) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        return new AssetProvider(this, priority){
            final /* synthetic */ AssetLoader this$0;
            final /* synthetic */ Priority $priority;
            {
                this.this$0 = $receiver;
                this.$priority = $priority;
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public Object getBytes(@NotNull EssentialAsset var1_1, @NotNull Continuation<? super byte[]> var2_2) {
                if (!(var2_2 instanceof getProvider.getBytes.1)) ** GOTO lbl-1000
                var4_3 = var2_2;
                if ((var4_3.label & -2147483648) != 0) {
                    var4_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var2_2){
                        /* synthetic */ Object result;
                        final /* synthetic */ getProvider.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.getBytes(null, (Continuation<? super byte[]>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.label = 1;
                        v0 = FutureKt.await((CompletionStage)this.this$0.getAssetBytes((EssentialAsset)asset, this.$priority), (Continuation)$continuation);
                        if (v0 == var5_5) {
                            return var5_5;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"await(...)");
                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
    }

    @NotNull
    public final <T> Asset<T> getAsset(@NotNull EssentialAsset asset, @NotNull Priority priority, @NotNull AssetType<T> type) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        AssetState assetState = this.assets.computeIfAbsent(asset.getChecksum(), arg_0 -> AssetLoader.getAsset$lambda$3((Function1)new Function1<String, AssetState>(this, asset){
            final /* synthetic */ AssetLoader this$0;
            final /* synthetic */ EssentialAsset $asset;
            {
                this.this$0 = $receiver;
                this.$asset = $asset;
                super(1);
            }

            @NotNull
            public final AssetState invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.new AssetState(this.$asset);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)assetState, (String)"computeIfAbsent(...)");
        AssetState state2 = assetState;
        state2.ensurePriorityAtLeast(priority);
        Asset asset2 = state2.getParsed().computeIfAbsent(type, arg_0 -> AssetLoader.getAsset$lambda$4((Function1)new Function1<AssetType<?>, Asset<?>>(state2, type, asset){
            final /* synthetic */ AssetState $state;
            final /* synthetic */ AssetType<T> $type;
            final /* synthetic */ EssentialAsset $asset;
            {
                this.$state = $state;
                this.$type = $type;
                this.$asset = $asset;
                super(1);
            }

            @NotNull
            public final Asset<?> invoke(@NotNull AssetType<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                CompletionStage completionStage = this.$state.getFuture().thenApplyAsync(arg_0 -> getAsset.1.invoke$lambda$0((Function1)new Function1<byte[], T>(this.$type, this.$asset){
                    final /* synthetic */ AssetType<T> $type;
                    final /* synthetic */ EssentialAsset $asset;
                    {
                        this.$type = $type;
                        this.$asset = $asset;
                        super(1);
                    }

                    public final T invoke(byte[] bytes) {
                        Object object;
                        try {
                            Function2<EssentialAsset, byte[], T> function2 = this.$type.getParse();
                            Intrinsics.checkNotNull((Object)bytes);
                            object = function2.invoke((Object)this.$asset, (Object)bytes);
                        }
                        catch (Exception e) {
                            Intrinsics.checkNotNull((Object)bytes);
                            throw new ParseException(this.$asset, this.$type, bytes, e);
                        }
                        return (T)object;
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApplyAsync(...)");
                CompletionStage future2 = completionStage;
                return new Asset<T>(this.$state.getInfo(), this.$type, this.$state.getFuture(), future2);
            }

            private static final Object invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return $tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNull((Object)asset2, (String)"null cannot be cast to non-null type gg.essential.network.connectionmanager.cosmetics.AssetLoader.Asset<T of gg.essential.network.connectionmanager.cosmetics.AssetLoader.getAsset>");
        return asset2;
    }

    @Nullable
    public final CompletableFuture<byte[]> getKnownAsset(@NotNull String checksum, @NotNull Priority priority) {
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        AssetState assetState = this.assets.get(checksum);
        if (assetState == null) {
            return null;
        }
        AssetState state2 = assetState;
        state2.ensurePriorityAtLeast(priority);
        return state2.getFuture();
    }

    private final Path getAssetCachePath(EssentialAsset $this$getAssetCachePath) {
        String checksum = $this$getAssetCachePath.getChecksum();
        Path path = this.cachePath.resolve(String.valueOf(checksum.charAt(0))).resolve(String.valueOf(checksum.charAt(1)));
        String string = checksum.substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Path path2 = path.resolve(string);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private static final Thread pool$lambda$1$lambda$0(AtomicInteger $threadId, Runnable it) {
        Intrinsics.checkNotNullParameter((Object)$threadId, (String)"$threadId");
        return new Thread(it, "Essential Asset Loader " + $threadId.incrementAndGet());
    }

    private static final AssetState getAssetBytes$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AssetState)$tmp0.invoke(p0);
    }

    private static final AssetState getAsset$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AssetState)$tmp0.invoke(p0);
    }

    private static final Asset getAsset$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Asset)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B9\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR'\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR#\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u0018\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Asset;", "T", "", "info", "Lgg/essential/mod/EssentialAsset;", "type", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "bytes", "Ljava/util/concurrent/CompletableFuture;", "", "parsed", "(Lgg/essential/mod/EssentialAsset;Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;)V", "getBytes", "()Ljava/util/concurrent/CompletableFuture;", "diagnostics", "", "Lgg/essential/network/cosmetics/Cosmetic$Diagnostic;", "getDiagnostics", "diagnostics$delegate", "Lkotlin/Lazy;", "getInfo", "()Lgg/essential/mod/EssentialAsset;", "getParsed", "parsedOrNull", "getParsedOrNull", "parsedOrNull$delegate", "getType", "()Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "essential-gui-essential"})
    public static final class Asset<T> {
        @NotNull
        private final EssentialAsset info;
        @NotNull
        private final AssetType<T> type;
        @NotNull
        private final CompletableFuture<byte[]> bytes;
        @NotNull
        private final CompletableFuture<T> parsed;
        @NotNull
        private final Lazy diagnostics$delegate;
        @NotNull
        private final Lazy parsedOrNull$delegate;

        public Asset(@NotNull EssentialAsset info, @NotNull AssetType<T> type, @NotNull CompletableFuture<byte[]> bytes, @NotNull CompletableFuture<T> parsed) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter(bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter(parsed, (String)"parsed");
            this.info = info;
            this.type = type;
            this.bytes = bytes;
            this.parsed = parsed;
            this.diagnostics$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CompletableFuture<List<? extends Cosmetic.Diagnostic>>>(this){
                final /* synthetic */ Asset<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final CompletableFuture<List<Cosmetic.Diagnostic>> invoke() {
                    return this.this$0.getType() instanceof JsonAssetType ? this.this$0.getBytes().thenApplyAsync(arg_0 -> diagnostics.2.invoke$lambda$0((Function1)new Function1<byte[], List<? extends Cosmetic.Diagnostic>>(this.this$0){
                        final /* synthetic */ Asset<T> this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final List<Cosmetic.Diagnostic> invoke(byte[] bytes) {
                            List list;
                            Intrinsics.checkNotNull((Object)bytes);
                            String fileContent = StringsKt.decodeToString((byte[])bytes);
                            try {
                                ((JsonAssetType)this.this$0.getType()).getStrictJson().decodeFromString((DeserializationStrategy)((JsonAssetType)this.this$0.getType()).getSerializer(), fileContent);
                                list = CollectionsKt.emptyList();
                            }
                            catch (SerializationException e) {
                                list = CollectionsKt.listOf((Object)DiagnosticsKt.diagnoseParsingException(Cosmetic.Diagnostic.Type.Warning, e, fileContent));
                            }
                            catch (Exception e) {
                                String msg = "Failed to parse as " + this.this$0.getType() + " with strict validation";
                                list = CollectionsKt.listOf((Object)Cosmetic.Diagnostic.Companion.warning$default(Cosmetic.Diagnostic.Companion, msg, ExceptionsKt.stackTraceToString((Throwable)e), null, null, null, null, 60, null));
                            }
                            return list;
                        }
                    }, arg_0)) : CompletableFuture.completedFuture(CollectionsKt.emptyList());
                }

                private static final List invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (List)$tmp0.invoke(p0);
                }
            }));
            this.parsedOrNull$delegate = LazyKt.lazy((Function0)new Function0<CompletableFuture<T>>(this){
                final /* synthetic */ Asset<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final CompletableFuture<T> invoke() {
                    return this.this$0.getParsed().exceptionally(arg_0 -> parsedOrNull.2.invoke$lambda$0(this.this$0, arg_0));
                }

                private static final Object invoke$lambda$0(Asset this$0, Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    AssetLoader.access$getLogger$cp().error("Failed to load " + this$0.getType() + " from " + this$0.getInfo().getUrl(), t);
                    return null;
                }
            });
        }

        @NotNull
        public final EssentialAsset getInfo() {
            return this.info;
        }

        @NotNull
        public final AssetType<T> getType() {
            return this.type;
        }

        @NotNull
        public final CompletableFuture<byte[]> getBytes() {
            return this.bytes;
        }

        @NotNull
        public final CompletableFuture<T> getParsed() {
            return this.parsed;
        }

        @NotNull
        public final CompletableFuture<List<Cosmetic.Diagnostic>> getDiagnostics() {
            Lazy lazy2 = this.diagnostics$delegate;
            Object object = lazy2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (CompletableFuture)object;
        }

        @NotNull
        public final CompletableFuture<T> getParsedOrNull() {
            Lazy lazy2 = this.parsedOrNull$delegate;
            Object object = lazy2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (CompletableFuture)object;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR%\u0010\u000e\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetState;", "", "info", "Lgg/essential/mod/EssentialAsset;", "(Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;Lgg/essential/mod/EssentialAsset;)V", "currentStep", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step;", "future", "Ljava/util/concurrent/CompletableFuture;", "", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "getInfo", "()Lgg/essential/mod/EssentialAsset;", "parsed", "", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Asset;", "getParsed", "()Ljava/util/Map;", "priority", "Ljava/util/concurrent/atomic/AtomicReference;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;", "kotlin.jvm.PlatformType", "ensurePriorityAtLeast", "", "atLeast", "nextStep", "step", "essential-gui-essential"})
    private final class AssetState {
        @NotNull
        private final EssentialAsset info;
        @NotNull
        private final CompletableFuture<byte[]> future;
        @NotNull
        private final Map<AssetType<?>, Asset<?>> parsed;
        @NotNull
        private final AtomicReference<Priority> priority;
        @Nullable
        private Step currentStep;

        public AssetState(EssentialAsset info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.info = info;
            this.future = new CompletableFuture();
            this.parsed = new ConcurrentHashMap();
            this.priority = new AtomicReference<Priority>(Priority.Passive);
            this.currentStep = new TryLoadFromCache(this);
        }

        @NotNull
        public final EssentialAsset getInfo() {
            return this.info;
        }

        @NotNull
        public final CompletableFuture<byte[]> getFuture() {
            return this.future;
        }

        @NotNull
        public final Map<AssetType<?>, Asset<?>> getParsed() {
            return this.parsed;
        }

        public final void ensurePriorityAtLeast(@NotNull Priority atLeast) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)((Object)atLeast), (String)"atLeast");
                if (this.priority.getAndUpdate(arg_0 -> AssetState.ensurePriorityAtLeast$lambda$0(atLeast, arg_0)).compareTo((Enum)atLeast) >= 0) break block1;
                Step step = this.currentStep;
                if (step != null) {
                    step.submit(atLeast);
                }
            }
        }

        public final void nextStep(@NotNull Step step) {
            Intrinsics.checkNotNullParameter((Object)step, (String)"step");
            this.currentStep = step;
            Priority priority = this.priority.get();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)priority), (String)"get(...)");
            step.submit(priority);
        }

        private static final Priority ensurePriorityAtLeast$lambda$0(Priority $atLeast, Priority it) {
            Intrinsics.checkNotNullParameter((Object)((Object)$atLeast), (String)"$atLeast");
            return it.compareTo((Enum)$atLeast) < 0 ? $atLeast : it;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\r\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015B=\u00126\u0010\u0003\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u000bRA\u0010\u0003\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "T", "", "parse", "Lkotlin/Function2;", "Lgg/essential/mod/EssentialAsset;", "Lkotlin/ParameterName;", "name", "asset", "", "bytes", "(Lkotlin/jvm/functions/Function2;)V", "getParse", "()Lkotlin/jvm/functions/Function2;", "Animation", "FeaturedPageCollection", "Mask", "Model", "Particle", "Raw", "SoundDefinitions", "Texture", "essential-gui-essential"})
    public static abstract class AssetType<T> {
        @NotNull
        private final Function2<EssentialAsset, byte[], T> parse;

        public AssetType(@NotNull Function2<? super EssentialAsset, ? super byte[], ? extends T> parse) {
            Intrinsics.checkNotNullParameter(parse, (String)"parse");
            this.parse = parse;
        }

        @NotNull
        public final Function2<EssentialAsset, byte[], T> getParse() {
            return this.parse;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType$Animation;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$JsonAssetType;", "Lgg/essential/model/file/AnimationFile;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "essential-gui-essential"})
        public static final class Animation
        extends JsonAssetType<AnimationFile> {
            @NotNull
            public static final Animation INSTANCE = new Animation();

            private Animation() {
                super(AnimationFile.Companion.serializer(), null, null, 6, null);
            }

            @NotNull
            public String toString() {
                return "Animation";
            }

            public int hashCode() {
                return -10236994;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Animation)) {
                    return false;
                }
                Animation cfr_ignored_0 = (Animation)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType$FeaturedPageCollection;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$JsonAssetType;", "Lgg/essential/mod/cosmetics/featured/FeaturedPageCollection;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "essential-gui-essential"})
        public static final class FeaturedPageCollection
        extends JsonAssetType<gg.essential.mod.cosmetics.featured.FeaturedPageCollection> {
            @NotNull
            public static final FeaturedPageCollection INSTANCE = new FeaturedPageCollection();

            private FeaturedPageCollection() {
                super(gg.essential.mod.cosmetics.featured.FeaturedPageCollection.Companion.serializer(), null, null, 6, null);
            }

            @NotNull
            public String toString() {
                return "FeaturedPageCollection";
            }

            public int hashCode() {
                return -1852830623;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FeaturedPageCollection)) {
                    return false;
                }
                FeaturedPageCollection cfr_ignored_0 = (FeaturedPageCollection)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType$Mask;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "Lgg/essential/cosmetics/skinmask/SkinMask;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "essential-gui-essential"})
        public static final class Mask
        extends AssetType<SkinMask> {
            @NotNull
            public static final Mask INSTANCE = new Mask();

            private Mask() {
                super(1.INSTANCE);
            }

            @NotNull
            public String toString() {
                return "Mask";
            }

            public int hashCode() {
                return -452486542;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Mask)) {
                    return false;
                }
                Mask cfr_ignored_0 = (Mask)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType$Model;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$JsonAssetType;", "Lgg/essential/model/file/ModelFile;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "essential-gui-essential"})
        public static final class Model
        extends JsonAssetType<ModelFile> {
            @NotNull
            public static final Model INSTANCE = new Model();

            private Model() {
                super(ModelFile.Companion.serializer(), null, null, 6, null);
            }

            @NotNull
            public String toString() {
                return "Model";
            }

            public int hashCode() {
                return -1141778333;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Model)) {
                    return false;
                }
                Model cfr_ignored_0 = (Model)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType$Particle;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$JsonAssetType;", "Lgg/essential/model/file/ParticlesFile;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "essential-gui-essential"})
        public static final class Particle
        extends JsonAssetType<ParticlesFile> {
            @NotNull
            public static final Particle INSTANCE = new Particle();

            private Particle() {
                super(ParticlesFile.Companion.serializer(), null, null, 6, null);
            }

            @NotNull
            public String toString() {
                return "Particle";
            }

            public int hashCode() {
                return -1064317172;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Particle)) {
                    return false;
                }
                Particle cfr_ignored_0 = (Particle)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType$Raw;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "essential-gui-essential"})
        public static final class Raw
        extends AssetType<byte[]> {
            @NotNull
            public static final Raw INSTANCE = new Raw();

            private Raw() {
                super(1.INSTANCE);
            }

            @NotNull
            public String toString() {
                return "Raw";
            }

            public int hashCode() {
                return 539597794;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Raw)) {
                    return false;
                }
                Raw cfr_ignored_0 = (Raw)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType$SoundDefinitions;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$JsonAssetType;", "Lgg/essential/model/file/SoundDefinitionsFile;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "essential-gui-essential"})
        public static final class SoundDefinitions
        extends JsonAssetType<SoundDefinitionsFile> {
            @NotNull
            public static final SoundDefinitions INSTANCE = new SoundDefinitions();

            private SoundDefinitions() {
                super(SoundDefinitionsFile.Companion.serializer(), null, null, 6, null);
            }

            @NotNull
            public String toString() {
                return "SoundDefinitions";
            }

            public int hashCode() {
                return 1877270391;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SoundDefinitions)) {
                    return false;
                }
                SoundDefinitions cfr_ignored_0 = (SoundDefinitions)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType$Texture;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "Lgg/essential/model/backend/RenderBackend$Texture;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "essential-gui-essential"})
        public static final class Texture
        extends AssetType<RenderBackend.Texture> {
            @NotNull
            public static final Texture INSTANCE = new Texture();

            private Texture() {
                super(1.INSTANCE);
            }

            @NotNull
            public String toString() {
                return "Texture";
            }

            public int hashCode() {
                return -382121003;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Texture)) {
                    return false;
                }
                Texture cfr_ignored_0 = (Texture)other;
                return true;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Download;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step;", "assetState", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetState;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;", "(Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetState;)V", "run", "", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nAssetLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetLoader.kt\ngg/essential/network/connectionmanager/cosmetics/AssetLoader$Download\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n1#2:354\n*E\n"})
    private final class Download
    extends Step {
        @NotNull
        private final AssetState assetState;

        public Download(AssetState assetState) {
            Intrinsics.checkNotNullParameter((Object)assetState, (String)"assetState");
            super(AssetLoader.this.networkExecutor);
            this.assetState = assetState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void run() {
            try {
                block23: {
                    block24: {
                        var2_1 = StringsKt.substringBefore$default((String)this.assetState.getInfo().getUrl(), (String)":", null, (int)2, null);
                        switch (var2_1.hashCode()) {
                            case 3143036: {
                                if (var2_1.equals("file")) break;
                                ** break;
                            }
                            case 3076010: {
                                if (!var2_1.equals("data")) {
                                    ** break;
                                }
                                break block24;
                            }
                            case 3213448: {
                                if (!var2_1.equals("http")) {
                                    ** break;
                                }
                                ** GOTO lbl18
                            }
                            case 99617003: {
                                if (!var2_1.equals("https")) ** break;
lbl18:
                                // 2 sources

                                request = new Request.Builder().url(this.assetState.getInfo().getUrl()).header("User-Agent", "Mozilla/4.76 (Essential Asset Downloader)").build();
                                var4_4 = HttpUtils.getHttpClient().join().newCall((Request)request).execute();
                                var5_5 = null;
                                try {
                                    response = (Response)var4_4;
                                    $i$a$-use-AssetLoader$Download$run$bytes$1 = false;
                                    if (!response.isSuccessful()) {
                                        throw new IOException("Unexpected response " + response);
                                    }
                                    v0 = response.body();
                                    Intrinsics.checkNotNull((Object)v0);
                                    response = v0.bytes();
                                    v1 /* !! */  = (char[])response;
                                    break block23;
                                }
                                catch (Throwable response) {
                                    var5_5 = response;
                                    throw response;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)var4_4, (Throwable)var5_5);
                                }
                            }
                        }
                        request = new URL(this.assetState.getInfo().getUrl()).openStream();
                        var4_4 = null;
                        try {
                            it /* !! */  = (char[])((InputStream)request);
                            $i$a$-use-AssetLoader$Download$run$bytes$2 = false;
                            Intrinsics.checkNotNull((Object)it /* !! */ );
                            it /* !! */  = (char[])ByteStreamsKt.readBytes((InputStream)it /* !! */ );
                            v1 /* !! */  = it /* !! */ ;
                        }
                        catch (Throwable it) {
                            var4_4 = it;
                            throw it;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)request, (Throwable)var4_4);
                        }
                    }
                    path = StringsKt.removePrefix((String)this.assetState.getInfo().getUrl(), (CharSequence)"data:");
                    it /* !! */  = new char[]{','};
                    var4_4 = StringsKt.split$default((CharSequence)path, (char[])it /* !! */ , (boolean)false, (int)2, (int)2, null);
                    options = (String)var4_4.get(0);
                    data = (String)var4_4.get(1);
                    if (StringsKt.endsWith$default((String)options, (String)";base64", (boolean)false, (int)2, null)) {
                        v1 /* !! */  = (char[])Base64.getDecoder().decode(data);
                    } else {
                        v2 = URLDecoder.decode(data, "UTF-8");
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"decode(...)");
                        v1 /* !! */  = (char[])StringsKt.encodeToByteArray((String)v2);
                    }
                    break block23;
lbl67:
                    // 5 sources

                    throw new IllegalArgumentException("unsupported url scheme: " + this.assetState.getInfo().getUrl());
                }
                var2_1 = v1 /* !! */ ;
            }
            catch (IOException e) {
                this.assetState.getFuture().completeExceptionally(e);
                return;
            }
            bytes = var2_1;
            this.assetState.getFuture().complete((byte[])bytes);
            Intrinsics.checkNotNull((Object)bytes);
            new SaveToCache(this.assetState, (byte[])bytes).submit(Priority.Background);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$JsonAssetType;", "T", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "serializer", "Lkotlinx/serialization/KSerializer;", "json", "Lkotlinx/serialization/json/Json;", "strictJson", "(Lkotlinx/serialization/KSerializer;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/Json;)V", "getJson", "()Lkotlinx/serialization/json/Json;", "getSerializer", "()Lkotlinx/serialization/KSerializer;", "getStrictJson", "essential-gui-essential"})
    public static abstract class JsonAssetType<T>
    extends AssetType<T> {
        @NotNull
        private final KSerializer<T> serializer;
        @NotNull
        private final Json json;
        @NotNull
        private final Json strictJson;

        public JsonAssetType(final @NotNull KSerializer<T> serializer2, final @NotNull Json json2, @NotNull Json strictJson) {
            Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            Intrinsics.checkNotNullParameter((Object)strictJson, (String)"strictJson");
            super((Function2)new Function2<EssentialAsset, byte[], T>(){

                public final T invoke(@NotNull EssentialAsset essentialAsset, @NotNull byte[] bytes) {
                    Intrinsics.checkNotNullParameter((Object)essentialAsset, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                    return json2.decodeFromString((DeserializationStrategy)serializer2, StringsKt.decodeToString((byte[])bytes));
                }
            });
            this.serializer = serializer2;
            this.json = json2;
            this.strictJson = strictJson;
        }

        public /* synthetic */ JsonAssetType(KSerializer kSerializer, Json json2, Json json3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                json2 = JsonKt.Json$default(null, (Function1)1.INSTANCE, (int)1, null);
            }
            if ((n & 4) != 0) {
                json3 = JsonKt.Json((Json)json2, (Function1)2.INSTANCE);
            }
            this(kSerializer, json2, json3);
        }

        @NotNull
        public final KSerializer<T> getSerializer() {
            return this.serializer;
        }

        @NotNull
        public final Json getJson() {
            return this.json;
        }

        @NotNull
        public final Json getStrictJson() {
            return this.strictJson;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\u0018\u00002\u00060\u0001j\u0002`\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$ParseException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "asset", "Lgg/essential/mod/EssentialAsset;", "type", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "bytes", "", "cause", "", "(Lgg/essential/mod/EssentialAsset;Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;[BLjava/lang/Throwable;)V", "getAsset", "()Lgg/essential/mod/EssentialAsset;", "getBytes", "()[B", "getType", "()Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetType;", "essential-gui-essential"})
    public static final class ParseException
    extends Exception {
        @NotNull
        private final EssentialAsset asset;
        @NotNull
        private final AssetType<?> type;
        @NotNull
        private final byte[] bytes;

        public ParseException(@NotNull EssentialAsset asset, @NotNull AssetType<?> type, @NotNull byte[] bytes, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(cause);
            this.asset = asset;
            this.type = type;
            this.bytes = bytes;
        }

        @NotNull
        public final EssentialAsset getAsset() {
            return this.asset;
        }

        @NotNull
        public final AssetType<?> getType() {
            return this.type;
        }

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;", "", "(Ljava/lang/String;I)V", "Passive", "BackgroundUnlikely", "Background", "Low", "High", "Blocking", "essential-gui-essential"})
    public static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority Passive = new Priority();
        public static final /* enum */ Priority BackgroundUnlikely = new Priority();
        public static final /* enum */ Priority Background = new Priority();
        public static final /* enum */ Priority Low = new Priority();
        public static final /* enum */ Priority High = new Priority();
        public static final /* enum */ Priority Blocking = new Priority();
        private static final /* synthetic */ Priority[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Priority[] values() {
            return (Priority[])$VALUES.clone();
        }

        public static Priority valueOf(String value) {
            return Enum.valueOf(Priority.class, value);
        }

        @NotNull
        public static EnumEntries<Priority> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = priorityArray = new Priority[]{Priority.Passive, Priority.BackgroundUnlikely, Priority.Background, Priority.Low, Priority.High, Priority.Blocking};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$SaveToCache;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step;", "assetState", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetState;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;", "bytes", "", "(Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetState;[B)V", "run", "", "essential-gui-essential"})
    private final class SaveToCache
    extends Step {
        @NotNull
        private final AssetState assetState;
        @NotNull
        private final byte[] bytes;

        public SaveToCache(@NotNull AssetState assetState, byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)assetState, (String)"assetState");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            super(AssetLoader.this.diskExecutor);
            this.assetState = assetState;
            this.bytes = bytes;
        }

        @Override
        public void run() {
            Path cachePath = AssetLoader.this.getAssetCachePath(this.assetState.getInfo());
            try {
                Files.createDirectories(cachePath.getParent(), new FileAttribute[0]);
                Files.write(cachePath, this.bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error("Failed to cache \"" + this.assetState.getInfo().getUrl() + "\" at \"" + cachePath + "\": ", (Throwable)e);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\n0\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step;", "Ljava/lang/Runnable;", "executor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "priority", "Ljava/util/concurrent/atomic/AtomicReference;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;", "kotlin.jvm.PlatformType", "state", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step$State;", "submit", "", "atLeast", "PrioritizedJob", "State", "essential-gui-essential"})
    private static abstract class Step
    implements Runnable {
        @NotNull
        private final Executor executor;
        @NotNull
        private final AtomicReference<State> state;
        @NotNull
        private final AtomicReference<Priority> priority;

        public Step(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            this.executor = executor;
            this.state = new AtomicReference<State>(State.Pending);
            this.priority = new AtomicReference<Priority>(Priority.Passive);
        }

        public final void submit(@NotNull Priority atLeast) {
            Intrinsics.checkNotNullParameter((Object)((Object)atLeast), (String)"atLeast");
            if (this.state.get() != State.Pending) {
                return;
            }
            if (this.priority.getAndUpdate(arg_0 -> Step.submit$lambda$0(atLeast, arg_0)).compareTo((Enum)atLeast) < 0) {
                this.executor.execute(new PrioritizedJob(atLeast));
            }
        }

        private static final Priority submit$lambda$0(Priority $atLeast, Priority it) {
            Intrinsics.checkNotNullParameter((Object)((Object)$atLeast), (String)"$atLeast");
            return it.compareTo((Enum)$atLeast) < 0 ? $atLeast : it;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\f\u0012\b\u0012\u00060\u0000R\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\u0000R\u00020\u0003H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step$PrioritizedJob;", "Ljava/lang/Runnable;", "", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step;", "priority", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;", "(Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step;Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;)V", "compareTo", "", "other", "run", "", "essential-gui-essential"})
        private final class PrioritizedJob
        implements Runnable,
        Comparable<PrioritizedJob> {
            @NotNull
            private final Priority priority;

            public PrioritizedJob(Priority priority) {
                Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
                this.priority = priority;
            }

            @Override
            public int compareTo(@NotNull PrioritizedJob other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return -this.priority.compareTo((Enum)other.priority);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!Step.this.state.compareAndSet(State.Pending, State.Running)) {
                    return;
                }
                try {
                    Step.this.run();
                }
                finally {
                    Step.this.state.set(State.Done);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step$State;", "", "(Ljava/lang/String;I)V", "Pending", "Running", "Done", "essential-gui-essential"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State Pending = new State();
            public static final /* enum */ State Running = new State();
            public static final /* enum */ State Done = new State();
            private static final /* synthetic */ State[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            @NotNull
            public static EnumEntries<State> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = stateArray = new State[]{State.Pending, State.Running, State.Done};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$TryLoadFromCache;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Step;", "assetState", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetState;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;", "(Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$AssetState;)V", "run", "", "tryLoadFromCache", "", "asset", "Lgg/essential/mod/EssentialAsset;", "essential-gui-essential"})
    private final class TryLoadFromCache
    extends Step {
        @NotNull
        private final AssetState assetState;

        public TryLoadFromCache(AssetState assetState) {
            Intrinsics.checkNotNullParameter((Object)assetState, (String)"assetState");
            super(AssetLoader.this.diskExecutor);
            this.assetState = assetState;
        }

        @Override
        public void run() {
            byte[] bytes = this.tryLoadFromCache(this.assetState.getInfo());
            if (bytes != null) {
                this.assetState.getFuture().complete(bytes);
            } else {
                this.assetState.nextStep(new Download(this.assetState));
            }
        }

        @Nullable
        public final byte[] tryLoadFromCache(@NotNull EssentialAsset asset) {
            Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
            Path cachePath = AssetLoader.this.getAssetCachePath(asset);
            if (!Files.exists(cachePath, new LinkOption[0])) {
                return null;
            }
            try {
                String string;
                byte[] bytes = Files.readAllBytes(cachePath);
                switch (asset.getChecksum().length()) {
                    case 64: {
                        string = DigestUtils.sha256Hex((byte[])bytes);
                        break;
                    }
                    case 40: {
                        string = DigestUtils.sha1Hex((byte[])bytes);
                        break;
                    }
                    case 32: {
                        string = DigestUtils.md5Hex((byte[])bytes);
                        break;
                    }
                    default: {
                        logger.warn("Unknown checksum format for " + asset.getUrl() + ": " + asset.getChecksum());
                        return null;
                    }
                }
                String checksum = string;
                if (!StringsKt.equals((String)checksum, (String)asset.getChecksum(), (boolean)true)) {
                    logger.warn("Checksum mismatch for {}: {}", (Object)cachePath, (Object)checksum);
                    return null;
                }
                return bytes;
            }
            catch (IOException e) {
                logger.warn("Failed to read asset from cache at " + cachePath + ": ", (Throwable)e);
                return null;
            }
        }
    }
}

