/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.notices;

import gg.essential.gui.wardrobe.components.Gifting;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsData;
import gg.essential.network.connectionmanager.notices.NoticeListener;
import gg.essential.network.connectionmanager.notices.NoticesManager;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.notices.NoticeType;
import gg.essential.notices.model.Notice;
import gg.essential.util.EssentialGuiExtensionsKt;
import gg.essential.util.UUIDUtil;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\r\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lgg/essential/network/connectionmanager/notices/GiftedCosmeticNoticeListener;", "Lgg/essential/network/connectionmanager/notices/NoticeListener;", "Lgg/essential/network/connectionmanager/notices/NoticesManager;", "noticeManager", "Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;", "cosmeticsData", "<init>", "(Lgg/essential/network/connectionmanager/notices/NoticesManager;Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;)V", "Lgg/essential/notices/model/Notice;", "notice", "", "noticeAdded", "(Lgg/essential/notices/model/Notice;)V", "noticeRemoved", "onConnect", "()V", "Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;", "Lgg/essential/network/connectionmanager/notices/NoticesManager;", "Essential 1.21.7-fabric"})
public final class GiftedCosmeticNoticeListener
implements NoticeListener {
    @NotNull
    private final NoticesManager noticeManager;
    @NotNull
    private final CosmeticsData cosmeticsData;

    public GiftedCosmeticNoticeListener(@NotNull NoticesManager noticeManager, @NotNull CosmeticsData cosmeticsData) {
        Intrinsics.checkNotNullParameter((Object)noticeManager, (String)"noticeManager");
        Intrinsics.checkNotNullParameter((Object)cosmeticsData, (String)"cosmeticsData");
        this.noticeManager = noticeManager;
        this.cosmeticsData = cosmeticsData;
    }

    @Override
    public void noticeAdded(@NotNull Notice notice) {
        Intrinsics.checkNotNullParameter((Object)notice, (String)"notice");
        if (notice.getType() != NoticeType.GIFTED_COSMETIC_TOAST) {
            return;
        }
        Object object = notice.getMetadata().get("gifted_by_id");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        UUID uuid = UUID.fromString(string);
        Object object2 = notice.getMetadata().get("cosmetic_id");
        String string2 = object2 instanceof String ? (String)object2 : null;
        if (string2 == null) {
            return;
        }
        String cosmeticId = string2;
        Cosmetic cosmetic2 = this.cosmeticsData.getCosmetic(cosmeticId);
        if (cosmetic2 == null) {
            return;
        }
        Cosmetic cosmetic3 = cosmetic2;
        CompletableFuture<String> completableFuture = UUIDUtil.getName(uuid);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getName(...)");
        EssentialGuiExtensionsKt.thenAcceptOnMainThread(completableFuture, (Function1)new Function1<String, Unit>(cosmetic3, uuid, this, notice){
            final /* synthetic */ Cosmetic $cosmetic;
            final /* synthetic */ UUID $uuid;
            final /* synthetic */ GiftedCosmeticNoticeListener this$0;
            final /* synthetic */ Notice $notice;
            {
                this.$cosmetic = $cosmetic;
                this.$uuid = $uuid;
                this.this$0 = $receiver;
                this.$notice = $notice;
                super(1);
            }

            public final void invoke(String name2) {
                UUID uUID = this.$uuid;
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"$uuid");
                Intrinsics.checkNotNull((Object)name2);
                Gifting.showGiftReceivedToast(this.$cosmetic, uUID, name2);
                GiftedCosmeticNoticeListener.access$getNoticeManager$p(this.this$0).dismissNotice(this.$notice.getId());
            }
        });
    }

    @Override
    public void noticeRemoved(@Nullable Notice notice) {
    }

    @Override
    public void onConnect() {
    }

    public static final /* synthetic */ NoticesManager access$getNoticeManager$p(GiftedCosmeticNoticeListener $this) {
        return $this.noticeManager;
    }
}

