/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.telemetry;

import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.telemetry.ClientTelemetryPacket;
import gg.essential.connectionmanager.common.packet.telemetry.ServerRecognizedTelemetryPacket;
import gg.essential.elementa.state.v2.ReferenceHolder;
import gg.essential.event.client.InitializationEvent;
import gg.essential.event.essential.TosAcceptedEvent;
import gg.essential.event.network.server.ServerJoinEvent;
import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.ReferenceHolderImpl;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.JsonElement;
import gg.essential.lib.gson.JsonObject;
import gg.essential.lib.gson.JsonPrimitive;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.network.connectionmanager.telemetry.ImpressionTelemetryManager;
import gg.essential.network.connectionmanager.telemetry.TelemetryManagerKt;
import gg.essential.sps.SpsAddress;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ModLoaderUtil;
import gg.essential.util.Multithreading;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class TelemetryManager
implements NetworkedManager {
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final SequentialPacketQueue telemetryQueue;
    @NotNull
    private final List<ClientTelemetryPacket> packetList = new ArrayList<ClientTelemetryPacket>();
    @Nullable
    private List<String> recognizedTelemetryKeys = null;
    @NotNull
    private final ReferenceHolder referenceHolder = new ReferenceHolderImpl();
    @Nullable
    private Function0<Unit> modPartnerEffect = null;

    public TelemetryManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.telemetryQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutSkip().create();
        connectionManager.registerPacketHandler(ServerRecognizedTelemetryPacket.class, packet -> {
            this.setRecognizedTelemetryKeys(packet.getRecognizedTelemetry());
            return Unit.INSTANCE;
        });
        Essential.EVENT_BUS.register(this);
        final String bytes = System.getProperty("essential.stage2.downloaded.bytes");
        final String ms = System.getProperty("essential.stage2.downloaded.millis");
        if (StringUtils.isNumeric((CharSequence)bytes) && StringUtils.isNumeric((CharSequence)ms)) {
            try {
                this.enqueue(new ClientTelemetryPacket("UPDATE_DOWNLOAD_SPEED", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("downloadBytes", Integer.parseInt(bytes));
                        this.put("downloadMs", Integer.parseInt(ms));
                    }
                }));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    private void setRecognizedTelemetryKeys(@NotNull List<String> keys) {
        this.recognizedTelemetryKeys = keys;
        if (!this.packetList.isEmpty()) {
            ArrayList<ClientTelemetryPacket> pendingPackets = new ArrayList<ClientTelemetryPacket>(this.packetList);
            this.packetList.clear();
            pendingPackets.forEach(this::enqueue);
        }
    }

    public void enqueue(@NotNull ClientTelemetryPacket packet) {
        if (this.connectionManager.isOpen() && this.connectionManager.isAuthenticated() && this.recognizedTelemetryKeys != null) {
            if (this.recognizedTelemetryKeys.contains(packet.getKey())) {
                this.telemetryQueue.enqueue(packet);
            }
        } else {
            this.packetList.add(packet);
        }
    }

    @Override
    public void onConnected() {
        this.recognizedTelemetryKeys = null;
        this.modPartnerEffect = StateKt.effect(this.referenceHolder, (Function1<? super Observer, Unit>)((Function1)observer -> {
            final List<String> loadedPartnerModIds2 = ModLoaderUtil.loadedPartnerModIds.get((Observer)observer);
            if (loadedPartnerModIds2 == null) {
                return Unit.INSTANCE;
            }
            this.enqueue(new ClientTelemetryPacket("PARTNERED_MODS", (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("partnered_mod_ids", loadedPartnerModIds2);
                }
            }));
            return Unit.INSTANCE;
        }));
    }

    @Override
    public void onDisconnect() {
        if (this.modPartnerEffect != null) {
            this.modPartnerEffect.invoke();
            this.modPartnerEffect = null;
        }
    }

    @Subscribe
    private void init(InitializationEvent event) {
        TelemetryManagerKt.setupAbFeatureTracking(this, this.referenceHolder);
        TelemetryManagerKt.setupSettingsTracking(this, this.referenceHolder);
        ImpressionTelemetryManager.INSTANCE.initialize();
        this.enqueue(new ClientTelemetryPacket("LANGUAGE", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("lang", UMinecraft.getMinecraft().field_1690.field_1883);
            }
        }));
        this.queueInstallerTelemetryPacket();
        this.queueIntegrationModTelemetryPacket();
    }

    public void clientActionPerformed(@NotNull Actions action2) {
        this.clientActionPerformed(action2, null);
    }

    public void clientActionPerformed(@NotNull Actions action2, @Nullable String context) {
        this.enqueue(ClientTelemetryPacket.forAction(action2.name(), context));
    }

    @Subscribe
    public void onServerJoin(ServerJoinEvent event) {
        final SpsAddress spsAddress = SpsAddress.parse(event.getServerData().field_3761);
        if (spsAddress != null) {
            this.enqueue(new ClientTelemetryPacket("SPS_JOIN", (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("host", spsAddress.getHost());
                }
            }));
        }
    }

    @Subscribe
    public void sendHardwareAndOSTelemetry(@NotNull TosAcceptedEvent event) {
        HashMap<String, Object> hardwareMap = new HashMap<String, Object>();
        try {
            CentralProcessor centralProcessor = new SystemInfo().getHardware().getProcessor();
            hardwareMap.put("cpu", centralProcessor.getProcessorIdentifier().getName());
        }
        catch (Throwable e) {
            Essential.logger.warn("Failed to get CPU", e);
            hardwareMap.putIfAbsent("cpu", "UNKNOWN");
        }
        hardwareMap.put("gpu", GL11.glGetString((int)7937));
        hardwareMap.put("allocatedMemory", Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        try {
            hardwareMap.put("os", System.getProperty("os.name", "UNKNOWN"));
            hardwareMap.put("osVersion", System.getProperty("os.version", "UNKNOWN"));
        }
        catch (Exception e) {
            Essential.logger.warn("Failed to get Operating System information", (Throwable)e);
            hardwareMap.putIfAbsent("os", "UNKNOWN");
            hardwareMap.putIfAbsent("osVersion", "UNKNOWN");
        }
        this.enqueue(new ClientTelemetryPacket("HARDWARE_V2", hardwareMap));
    }

    private void queueInstallerTelemetryPacket() {
        Multithreading.runAsync(() -> {
            try {
                Path installerMetadataPath = Essential.getInstance().getBaseDir().toPath().resolve("installer-metadata.json");
                if (Files.notExists(installerMetadataPath, new LinkOption[0])) {
                    return;
                }
                byte[] pathBytes = installerMetadataPath.toRealPath(new LinkOption[0]).toString().getBytes(StandardCharsets.UTF_8);
                byte[] pathChecksumBytes = MessageDigest.getInstance("SHA-1").digest(pathBytes);
                StringBuilder pathChecksumBuilder = new StringBuilder();
                for (byte checksumByte : pathChecksumBytes) {
                    pathChecksumBuilder.append(String.format(Locale.ROOT, "%02x", checksumByte));
                }
                String pathChecksum = pathChecksumBuilder.toString();
                HashMap<String, Object> telemetryMap = this.getHashMapFromJsonFile(installerMetadataPath);
                boolean hasBeenMoved = false;
                Object installPathChecksum = telemetryMap.get("installPathChecksum");
                if (installPathChecksum instanceof JsonPrimitive) {
                    String installerPathChecksum = ((JsonPrimitive)installPathChecksum).getAsString();
                    hasBeenMoved = !installerPathChecksum.equals(pathChecksum);
                }
                telemetryMap.put("installPathChecksum", pathChecksum);
                telemetryMap.put("hasBeenMoved", hasBeenMoved);
                Multithreading.scheduleOnMainThread(() -> this.enqueue(new ClientTelemetryPacket("INSTALLER", telemetryMap)), 0L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Essential.logger.warn("Error when trying to parse installer telemetry!", (Throwable)e);
            }
        });
    }

    private void queueIntegrationModTelemetryPacket() {
        Multithreading.runAsync(() -> {
            try {
                Path integrationModMetadataPath = Essential.getInstance().getBaseDir().toPath().resolve("partner-integration-mod-metadata.json");
                if (Files.notExists(integrationModMetadataPath, new LinkOption[0])) {
                    return;
                }
                HashMap<String, Object> telemetryMap = this.getHashMapFromJsonFile(integrationModMetadataPath);
                Multithreading.scheduleOnMainThread(() -> this.enqueue(new ClientTelemetryPacket("PARTNER_INTEGRATION_MOD", telemetryMap)), 0L, TimeUnit.SECONDS);
                Files.deleteIfExists(integrationModMetadataPath);
            }
            catch (Exception e) {
                Essential.logger.warn("Error when trying to parse partner integration mod telemetry!", (Throwable)e);
            }
        });
    }

    private HashMap<String, Object> getHashMapFromJsonFile(Path path) throws IOException {
        String rawFile = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        JsonObject telemetryObject = new Gson().fromJson(rawFile, JsonObject.class);
        HashMap<String, Object> telemetryMap = new HashMap<String, Object>();
        for (Map.Entry<String, JsonElement> entry2 : telemetryObject.entrySet()) {
            telemetryMap.put(entry2.getKey(), entry2.getValue());
        }
        return telemetryMap;
    }

    public static enum Actions {
        EMOTE_WHEEL_ACTIVATE,
        EMOTE_ACTIVATE,
        EMOTE_WHEEL_EDIT,
        EMOTE_WARDROBE_SECTION_VIEWED,
        CART_NOT_EMPTY_WARNING,
        PERSISTENT_TOAST_CLEARED,
        PERSISTENT_TOAST_CLICKED;

    }
}

