/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.pingproxy;

import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.pingproxy.ClientPingProxyPacket;
import gg.essential.connectionmanager.common.packet.pingproxy.ServerPingProxyResponsePacket;
import gg.essential.mixins.ext.client.multiplayer.ServerDataExtKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_2540;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\r\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ0\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\u0002\b\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010\"\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lgg/essential/network/pingproxy/ProxyPingPacketHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/buffer/ByteBuf;", "Lnet/minecraft/class_642;", "serverData", "<init>", "(Lnet/minecraft/class_642;)V", "Lio/netty/channel/ChannelHandlerContext;", "ctx", "", "channelActive", "(Lio/netty/channel/ChannelHandlerContext;)V", "msg", "channelRead0", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/buffer/ByteBuf;)V", "", "id", "Lkotlin/Function1;", "Lnet/minecraft/class_2540;", "Lkotlin/ExtensionFunctionType;", "writer", "sendPacket", "(ILkotlin/jvm/functions/Function1;)V", "Lio/netty/channel/Channel;", "channel", "Lio/netty/channel/Channel;", "getChannel", "()Lio/netty/channel/Channel;", "setChannel", "(Lio/netty/channel/Channel;)V", "", "isQuery", "Z", "Lgg/essential/connectionmanager/common/packet/pingproxy/ClientPingProxyPacket;", "pingData", "Lgg/essential/connectionmanager/common/packet/pingproxy/ClientPingProxyPacket;", "Lnet/minecraft/class_642;", "getServerData", "()Lnet/minecraft/class_642;", "Essential 1.21.7-fabric"})
public final class ProxyPingPacketHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    @NotNull
    private final class_642 serverData;
    private boolean isQuery;
    @Nullable
    private ClientPingProxyPacket pingData;
    public Channel channel;

    public ProxyPingPacketHandler(@NotNull class_642 serverData) {
        Intrinsics.checkNotNullParameter((Object)serverData, (String)"serverData");
        this.serverData = serverData;
    }

    @NotNull
    public final class_642 getServerData() {
        return this.serverData;
    }

    @NotNull
    public final Channel getChannel() {
        Channel channel2 = this.channel;
        if (channel2 != null) {
            return channel2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
        return null;
    }

    public final void setChannel(@NotNull Channel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"<set-?>");
        this.channel = channel2;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Channel channel2 = ctx2.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"channel(...)");
        this.setChannel(channel2);
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx2, @NotNull ByteBuf msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        class_2540 buf = new class_2540(msg);
        int id2 = buf.method_10816();
        if (!this.isQuery) {
            if (id2 == 0) {
                int protocolVersion = buf.method_10816();
                String string = buf.method_10800(255);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                String[] stringArray = new String[]{"\u0000"};
                String address = (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
                int port = buf.readUnsignedShort();
                int nextState = buf.method_10816();
                this.pingData = new ClientPingProxyPacket(address, port, protocolVersion);
                if (nextState == 1) {
                    this.isQuery = true;
                } else {
                    Essential.logger.warn("Invalid nextState " + nextState + " sent to pingproxy");
                    this.getChannel().close();
                }
            }
        } else {
            switch (id2) {
                case 0: {
                    ClientPingProxyPacket clientPingProxyPacket = this.pingData;
                    Intrinsics.checkNotNull((Object)clientPingProxyPacket);
                    ClientPingProxyPacket pingData = clientPingProxyPacket;
                    Essential.getInstance().getConnectionManager().send(pingData, arg_0 -> ProxyPingPacketHandler.channelRead0$lambda$0(this, pingData, arg_0), TimeUnit.SECONDS, 7L);
                    break;
                }
                case 1: {
                    long payload = buf.readLong();
                    this.sendPacket(1, (Function1<? super class_2540, Unit>)((Function1)new Function1<class_2540, Unit>(payload){
                        final /* synthetic */ long $payload;
                        {
                            this.$payload = $payload;
                            super(1);
                        }

                        public final void invoke(@NotNull class_2540 $this$sendPacket) {
                            Intrinsics.checkNotNullParameter((Object)$this$sendPacket, (String)"$this$sendPacket");
                            $this$sendPacket.method_52974(this.$payload);
                        }
                    }));
                }
            }
        }
    }

    private final void sendPacket(int id2, Function1<? super class_2540, Unit> writer) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(id2);
        writer.invoke((Object)buf);
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10804(buf.readableBytes());
        packet.method_52975((ByteBuf)buf);
        this.getChannel().writeAndFlush((Object)packet);
    }

    private static final void channelRead0$lambda$0(ProxyPingPacketHandler this$0, ClientPingProxyPacket $pingData, Optional maybeResponse) {
        ServerPingProxyResponsePacket response2;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pingData, (String)"$pingData");
        Object var4_3 = maybeResponse.orElse(null);
        ServerPingProxyResponsePacket serverPingProxyResponsePacket = response2 = var4_3 instanceof ServerPingProxyResponsePacket ? (ServerPingProxyResponsePacket)var4_3 : null;
        if (response2 != null) {
            this$0.sendPacket(0, (Function1<? super class_2540, Unit>)((Function1)new Function1<class_2540, Unit>(response2){
                final /* synthetic */ ServerPingProxyResponsePacket $response;
                {
                    this.$response = $response;
                    super(1);
                }

                public final void invoke(@NotNull class_2540 $this$sendPacket) {
                    Intrinsics.checkNotNullParameter((Object)$this$sendPacket, (String)"$this$sendPacket");
                    $this$sendPacket.method_10814(this.$response.getRawJson());
                }
            }));
            ServerDataExtKt.setPingOverride(ServerDataExtKt.getExt(this$0.serverData), response2.getLatency());
            ServerDataExtKt.setPingRegion(ServerDataExtKt.getExt(this$0.serverData), response2.getRegion());
        } else {
            this$0.getChannel().close();
            Essential.logger.info("Received no response from ping proxy for " + $pingData.getHostname() + ":" + $pingData.getPort() + " (" + $pingData.getProtocolVersion() + ")");
        }
    }
}

