/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.quic;

import gg.essential.quic.LogOnce;
import gg.essential.quic.LogOnceHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.util.concurrent.GenericFutureListener;

public class ProxyHandler
extends LogOnceHandler {
    protected Channel targetChannel;

    public ProxyHandler() {
        this(null);
    }

    public ProxyHandler(Channel targetChannel) {
        this(LogOnce.toForkedJvmDebug(), targetChannel);
    }

    public ProxyHandler(LogOnce logOnce, Channel targetChannel) {
        super(logOnce, null);
        this.targetChannel = targetChannel;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx2, Object msg) {
        this.targetChannel.writeAndFlush(msg).addListener((GenericFutureListener)((ChannelFutureListener)future2 -> {
            if (!future2.isSuccess()) {
                future2.cause().printStackTrace();
                this.targetChannel.close();
            }
        }));
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx2) {
        if (this.targetChannel != null && this.targetChannel.isActive()) {
            if (this.targetChannel instanceof QuicStreamChannel) {
                this.targetChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)QuicStreamChannel.SHUTDOWN_OUTPUT);
            } else {
                this.targetChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) {
        cause.printStackTrace();
        if (ctx2.channel().isActive()) {
            ctx2.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

