/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.slf4j;

import gg.essential.slf4j.AbstractEventLogger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ComparableTimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.channels.Channel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.LoggingEventAware;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgg/essential/slf4j/ChannelLogger;", "Lgg/essential/slf4j/AbstractEventLogger;", "Lorg/slf4j/spi/LoggingEventAware;", "level", "Lorg/slf4j/event/Level;", "channel", "Lkotlinx/coroutines/channels/Channel;", "Lkotlin/Pair;", "Lkotlin/time/ComparableTimeMark;", "Lorg/slf4j/event/LoggingEvent;", "timeSource", "Lkotlin/time/TimeSource$WithComparableMarks;", "(Lorg/slf4j/event/Level;Lkotlinx/coroutines/channels/Channel;Lkotlin/time/TimeSource$WithComparableMarks;)V", "isDebugEnabled", "", "isErrorEnabled", "isInfoEnabled", "isTraceEnabled", "isWarnEnabled", "log", "", "event", "utils"})
public final class ChannelLogger
extends AbstractEventLogger
implements LoggingEventAware {
    @NotNull
    private final Level level;
    @NotNull
    private final Channel<Pair<ComparableTimeMark, LoggingEvent>> channel;
    @NotNull
    private final TimeSource.WithComparableMarks timeSource;

    public ChannelLogger(@NotNull Level level, @NotNull Channel<Pair<ComparableTimeMark, LoggingEvent>> channel2, @NotNull TimeSource.WithComparableMarks timeSource) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(channel2, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this.level = level;
        this.channel = channel2;
        this.timeSource = timeSource;
    }

    @Override
    public void log(@NotNull LoggingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.channel.trySend-JP2dKIU((Object)new Pair((Object)this.timeSource.markNow(), (Object)event));
    }

    public boolean isTraceEnabled() {
        return this.level.compareTo((Enum)Level.TRACE) >= 0;
    }

    public boolean isDebugEnabled() {
        return this.level.compareTo((Enum)Level.DEBUG) >= 0;
    }

    public boolean isInfoEnabled() {
        return this.level.compareTo((Enum)Level.INFO) >= 0;
    }

    public boolean isWarnEnabled() {
        return this.level.compareTo((Enum)Level.WARN) >= 0;
    }

    public boolean isErrorEnabled() {
        return true;
    }
}

