/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import gg.essential.model.util.Color;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.essential.universal.render.DrawCallBuilder;
import gg.essential.universal.render.URenderPipeline;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.vertex.UBufferBuilder;
import gg.essential.universal.vertex.UBuiltBuffer;
import gg.essential.util.GuiEssentialPlatform;
import gg.essential.util.GuiRendererInfo;
import gg.essential.util.image.GpuTexture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_10366;
import net.minecraft.class_11228;
import net.minecraft.class_11246;
import net.minecraft.class_310;
import net.minecraft.class_758;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001d\u0010\t\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0015\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\"\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lgg/essential/universal/UMatrixStack;", "matrixStack", "Lgg/essential/util/image/GpuTexture;", "resultColor", "", "blitTextureToRenderTarget", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/util/image/GpuTexture;)V", "Lnet/minecraft/class_11246;", "guiRenderState", "renderGuiRenderStateToRenderTarget", "(Lgg/essential/universal/UMatrixStack;Lnet/minecraft/class_11246;)V", "renderGuiRenderStateToTexture", "(Lnet/minecraft/class_11246;)Lgg/essential/util/image/GpuTexture;", "Lgg/essential/universal/render/URenderPipeline;", "COMPOSITE_PIPELINE", "Lgg/essential/universal/render/URenderPipeline;", "Essential 1.21.7-fabric"})
public final class RenderGuiRenderStateToRenderTargetKt {
    @NotNull
    private static final URenderPipeline COMPOSITE_PIPELINE;

    public static final void renderGuiRenderStateToRenderTarget(@NotNull UMatrixStack matrixStack, @NotNull class_11246 guiRenderState) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)guiRenderState, (String)"guiRenderState");
        GpuTexture resultColor = RenderGuiRenderStateToRenderTargetKt.renderGuiRenderStateToTexture(guiRenderState);
        RenderGuiRenderStateToRenderTargetKt.blitTextureToRenderTarget(matrixStack, resultColor);
        resultColor.delete();
    }

    @NotNull
    public static final GpuTexture renderGuiRenderStateToTexture(@NotNull class_11246 guiRenderState) {
        Intrinsics.checkNotNullParameter((Object)guiRenderState, (String)"guiRenderState");
        class_310 mc = class_310.method_1551();
        GpuTexture mcColor = GuiEssentialPlatform.Companion.getPlatform().getMcFrameBufferColorTexture();
        GpuTexture gpuTexture = GuiEssentialPlatform.Companion.getPlatform().getMcFrameBufferDepthTexture();
        Intrinsics.checkNotNull((Object)gpuTexture);
        GpuTexture mcDepth = gpuTexture;
        int width2 = mcColor.getWidth();
        int height2 = mcColor.getHeight();
        GpuTexture resultColor = GuiEssentialPlatform.Companion.getPlatform().newGpuTexture(width2, height2, GpuTexture.Format.RGBA8);
        GpuTexture orgColor = GuiEssentialPlatform.Companion.getPlatform().newGpuTexture(width2, height2, GpuTexture.Format.RGBA8);
        GpuTexture orgDepth = GuiEssentialPlatform.Companion.getPlatform().newGpuTexture(width2, height2, GpuTexture.Format.DEPTH32);
        orgColor.copyFrom(mcColor);
        orgDepth.copyFrom(mcDepth);
        mcColor.clearColor-EIFkdBU(Color.constructor-impl(0));
        mcDepth.clearDepth(1.0f);
        GpuBufferSlice orgProjectionMatrixBuffer = RenderSystem.getProjectionMatrixBuffer();
        class_10366 orgProjectionType = RenderSystem.getProjectionType();
        GpuBufferSlice orgShaderFog = RenderSystem.getShaderFog();
        class_758 fogRenderer = new class_758();
        class_11228 guiRenderer = new class_11228(guiRenderState, mc.method_22940().method_23000(), CollectionsKt.emptyList());
        guiRenderer.method_70890(fogRenderer.method_71109(class_758.class_4596.field_60101));
        guiRenderer.close();
        fogRenderer.close();
        GuiRendererInfo.INSTANCE.setCustomGuiRendererUsedThisFrame(true);
        RenderSystem.setProjectionMatrix((GpuBufferSlice)orgProjectionMatrixBuffer, (class_10366)orgProjectionType);
        RenderSystem.setShaderFog((GpuBufferSlice)orgShaderFog);
        resultColor.copyFrom(mcColor);
        mcColor.copyFrom(orgColor);
        mcDepth.copyFrom(orgDepth);
        orgColor.delete();
        orgDepth.delete();
        return resultColor;
    }

    private static final void blitTextureToRenderTarget(UMatrixStack matrixStack, GpuTexture resultColor) {
        block0: {
            double scale2 = 1.0 / UResolution.getScaleFactor();
            double w = (double)resultColor.getWidth() * scale2;
            double h = (double)resultColor.getHeight() * scale2;
            UBufferBuilder buffer = UBufferBuilder.Companion.create(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE);
            buffer.pos(matrixStack, 0.0, h, 0.0).tex(0.0, 0.0).endVertex();
            buffer.pos(matrixStack, w, h, 0.0).tex(1.0, 0.0).endVertex();
            buffer.pos(matrixStack, w, 0.0, 0.0).tex(1.0, 1.0).endVertex();
            buffer.pos(matrixStack, 0.0, 0.0, 0.0).tex(0.0, 1.0).endVertex();
            UBuiltBuffer uBuiltBuffer = buffer.build();
            if (uBuiltBuffer == null) break block0;
            uBuiltBuffer.drawAndClose(COMPOSITE_PIPELINE, (Function1)new Function1<DrawCallBuilder, Unit>(resultColor){
                final /* synthetic */ GpuTexture $resultColor;
                {
                    this.$resultColor = $resultColor;
                    super(1);
                }

                public final void invoke(@NotNull DrawCallBuilder $this$drawAndClose) {
                    Intrinsics.checkNotNullParameter((Object)$this$drawAndClose, (String)"$this$drawAndClose");
                    $this$drawAndClose.texture(0, this.$resultColor.getGlId());
                }
            });
        }
    }

    static {
        URenderPipeline.Builder builder;
        URenderPipeline.Builder $this$COMPOSITE_PIPELINE_u24lambda_u240 = builder = URenderPipeline.Companion.builderWithDefaultShader("essential:gui_renderer_composite", UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE);
        boolean bl = false;
        $this$COMPOSITE_PIPELINE_u24lambda_u240.setBlendState(BlendState.PREMULTIPLIED_ALPHA);
        COMPOSITE_PIPELINE = builder.build();
    }
}

