/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.util.Sha256;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lgg/essential/util/Sha256;", "", "hexStr", "", "(Ljava/lang/String;)V", "bytes", "", "([B)V", "getBytes", "()[B", "getHexStr", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "toString", "Companion", "Serializer", "utils"})
@SourceDebugExtension(value={"SMAP\nSha256.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sha256.kt\ngg/essential/util/Sha256\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n*S KotlinDebug\n*F\n+ 1 Sha256.kt\ngg/essential/util/Sha256\n*L\n31#1:83\n31#1:84,3\n*E\n"})
public final class Sha256 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;
    public static final int BITS = 256;
    public static final int BYTES = 32;
    @NotNull
    private static final Sha256 EMPTY = Companion.compute((Function1<? super MessageDigest, Unit>)((Function1)Companion.EMPTY.1.INSTANCE));

    public Sha256(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        if (!(this.bytes.length == 32)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    /*
     * WARNING - void declaration
     */
    public Sha256(@NotNull String hexStr2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)hexStr2, (String)"hexStr");
        Iterable iterable = StringsKt.chunked((CharSequence)hexStr2, (int)2);
        Sha256 sha256 = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)Integer.parseInt((String)it, CharsKt.checkRadix((int)16)));
        }
        sha256(CollectionsKt.toByteArray((Collection)((List)destination$iv$iv)));
    }

    @NotNull
    public final String getHexStr() {
        return ArraysKt.joinToString$default((byte[])this.bytes, (CharSequence)"", null, null, (int)0, null, (Function1)hexStr.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public String toString() {
        return "sha256-" + this.getHexStr();
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Sha256)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((Sha256)other).bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001f\u0010\n\u001a\u00020\u00072\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0011J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0012J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lgg/essential/util/Sha256$Companion;", "", "()V", "BITS", "", "BYTES", "EMPTY", "Lgg/essential/util/Sha256;", "getEMPTY", "()Lgg/essential/util/Sha256;", "compute", "data", "Ljava/io/InputStream;", "block", "Lkotlin/Function1;", "Ljava/security/MessageDigest;", "", "Lkotlin/ExtensionFunctionType;", "", "serializer", "Lkotlinx/serialization/KSerializer;", "utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Sha256 compute(@NotNull Function1<? super MessageDigest, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            block.invoke((Object)messageDigest);
            byte[] byArray = messageDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return new Sha256(byArray);
        }

        @NotNull
        public final Sha256 getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final Sha256 compute(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.length == 0 ? this.getEMPTY() : this.compute((Function1<? super MessageDigest, Unit>)((Function1)new Function1<MessageDigest, Unit>(data){
                final /* synthetic */ byte[] $data;
                {
                    this.$data = $data;
                    super(1);
                }

                public final void invoke(@NotNull MessageDigest $this$compute) {
                    Intrinsics.checkNotNullParameter((Object)$this$compute, (String)"$this$compute");
                    $this$compute.update(this.$data);
                }
            }));
        }

        @NotNull
        public final Sha256 compute(@NotNull InputStream data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.compute((Function1<? super MessageDigest, Unit>)((Function1)new Function1<MessageDigest, Unit>(data){
                final /* synthetic */ InputStream $data;
                {
                    this.$data = $data;
                    super(1);
                }

                public final void invoke(@NotNull MessageDigest $this$compute) {
                    int chunkSize;
                    Intrinsics.checkNotNullParameter((Object)$this$compute, (String)"$this$compute");
                    byte[] buffer = new byte[8192];
                    while ((chunkSize = this.$data.read(buffer)) >= 0) {
                        $this$compute.update(buffer, 0, chunkSize);
                    }
                }
            }));
        }

        @NotNull
        public final KSerializer<Sha256> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgg/essential/util/Sha256$Serializer;", "Lkotlinx/serialization/KSerializer;", "Lgg/essential/util/Sha256;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "inner", "", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "utils"})
    public static final class Serializer
    implements KSerializer<Sha256> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();
        @NotNull
        private static final KSerializer<String> inner = BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE);
        @NotNull
        private static final SerialDescriptor descriptor = inner.getDescriptor();

        private Serializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        @NotNull
        public Sha256 deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            return new Sha256((String)decoder.decodeSerializableValue((DeserializationStrategy)inner));
        }

        public void serialize(@NotNull Encoder encoder, @NotNull Sha256 value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            encoder.encodeSerializableValue((SerializationStrategy)inner, (Object)value.getHexStr());
        }
    }
}

