/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util.swing;

import gg.essential.config.EssentialConfig;
import gg.essential.universal.UDesktop;
import gg.essential.util.swing.components.RoundBoi;
import gg.essential.util.swing.components.TitleBar;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.RoundRectangle2D;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import kotlin.Pair;

public class SwingUtil {
    public static final int FRAME_WIDTH = 470;
    public static final int FRAME_HEIGHT = 255;

    public static void showMessageBox(String title2, String[] message2) {
        Pair<JFrame, JPanel> initial = SwingUtil.create(title2);
        JPanel oops = (JPanel)initial.getSecond();
        int diff = ((message2.length >> 1) + 1) * -15;
        for (String s : message2) {
            oops.add(SwingUtil.simpleLabel(s, diff));
            diff += 15;
        }
        JFrame frame = (JFrame)initial.getFirst();
        oops.add(SwingUtil.okButton(frame));
        SwingUtil.display(frame);
    }

    public static void showOldModCorePopup() {
        Pair<JFrame, JPanel> initial = SwingUtil.create("Essential");
        JFrame frame = (JFrame)initial.getFirst();
        JPanel content = (JPanel)initial.getSecond();
        int diff = -30;
        for (String s : new String[]{"Essential has replaced ModCore!", "Please update all mods that use ModCore.", "You can find updated versions of all our mods at"}) {
            content.add(SwingUtil.simpleLabel(s, diff));
            diff += 15;
        }
        JLabel mods = SwingUtil.simpleLabel("<html><a href=\"https://sk1er.club/mods\"><font color=#01a552>https://sk1er.club/mods</a></html>", diff);
        mods.setCursor(new Cursor(12));
        mods.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    UDesktop.browse((URI)new URI("https://sk1er.club/mods"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        content.add(mods);
        content.add(SwingUtil.okButton(frame));
        content.add(SwingUtil.dontShowAgain(frame));
        SwingUtil.display(frame);
    }

    private static Pair<JFrame, JPanel> create(String title2) {
        try {
            UIManager.setLookAndFeel(NimbusLookAndFeel.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame frame = new JFrame();
        frame.setUndecorated(true);
        frame.setSize(470, 255);
        frame.setResizable(false);
        frame.setShape(new RoundRectangle2D.Double(0.0, 0.0, 470.0, 255.0, 16.0, 16.0));
        frame.setTitle(title2);
        Container container2 = frame.getContentPane();
        Color highlight2 = new Color(33, 34, 38);
        container2.setBackground(highlight2);
        container2.add(new TitleBar(frame));
        JPanel content = new JPanel();
        content.setLayout(null);
        content.setBackground(highlight2);
        content.setBounds(0, 32, 470, 255);
        container2.add(content);
        return new Pair((Object)frame, (Object)content);
    }

    private static JLabel simpleLabel(String text2, int pos) {
        JLabel label2 = new JLabel(text2, 0);
        label2.setForeground(new Color(187, 187, 187));
        label2.setBounds(0, 127 + pos, 470, 15);
        label2.setFont(label2.getFont().deriveFont(15.0f));
        return label2;
    }

    private static void display(final JFrame frame) {
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                frame.dispose();
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((int)(screenSize.getWidth() - 470.0) >> 1, (int)(screenSize.getHeight() - 255.0) >> 1);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    private static RoundBoi okButton(final JFrame frame) {
        RoundBoi rb = new RoundBoi("Ok");
        rb.setBounds(16, 187, 214, 53);
        Color a = new Color(1, 165, 82);
        rb.setForeground(a);
        rb.setBackground(a);
        rb.setCursor(new Cursor(12));
        rb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                frame.dispose();
            }
        });
        return rb;
    }

    private static RoundBoi dontShowAgain(final JFrame frame) {
        RoundBoi rb = new RoundBoi("Don't show again");
        rb.setBounds(240, 187, 214, 53);
        Color a = new Color(1, 165, 82);
        rb.setForeground(a);
        rb.setBackground(a);
        rb.setCursor(new Cursor(12));
        rb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EssentialConfig.INSTANCE.setModCoreWarning(false);
                frame.dispose();
            }
        });
        return rb;
    }
}

