/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.gui.screen;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.minecraft.class_2806;
import net.minecraft.class_332;
import net.minecraft.class_3928;
import net.minecraft.class_3953;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_3928.class})
public class LevelLoadingScreenMixin {
    @Mutable
    @Shadow
    @Final
    private static Object2IntMap<class_2806> field_17407;
    @Unique
    private static Reference2IntOpenHashMap<class_2806> STATUS_TO_COLOR_FAST;
    @Unique
    private static final int NULL_STATUS_COLOR;
    @Unique
    private static final int DEFAULT_STATUS_COLOR;

    @Overwrite
    public static void method_17538(class_332 graphics, class_3953 listener, int mapX, int mapY, int mapScale, int mapPadding) {
        LevelLoadingScreenMixin.sodium$drawChunkMap(listener, mapX, mapY, mapScale, mapPadding, graphics);
    }

    @Unique
    private static void sodium$drawChunkMap(class_3953 listener, int mapX, int mapY, int mapScale, int mapPadding, class_332 graphics) {
        if (STATUS_TO_COLOR_FAST == null) {
            STATUS_TO_COLOR_FAST = new Reference2IntOpenHashMap(field_17407.size());
            STATUS_TO_COLOR_FAST.put(null, NULL_STATUS_COLOR);
            field_17407.object2IntEntrySet().forEach(entry -> STATUS_TO_COLOR_FAST.put((Object)((class_2806)entry.getKey()), ColorARGB.withAlpha(entry.getIntValue(), 255)));
        }
        int centerSize = listener.method_17677();
        int size = listener.method_17678();
        int tileSize = mapScale + mapPadding;
        if (mapPadding != 0) {
            int mapRenderCenterSize = centerSize * tileSize - mapPadding;
            int radius = mapRenderCenterSize / 2 + 1;
            LevelLoadingScreenMixin.addRect(graphics, mapX - radius, mapY - radius, mapX - radius + 1, mapY + radius, DEFAULT_STATUS_COLOR);
            LevelLoadingScreenMixin.addRect(graphics, mapX + radius - 1, mapY - radius, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
            LevelLoadingScreenMixin.addRect(graphics, mapX - radius, mapY - radius, mapX + radius, mapY - radius + 1, DEFAULT_STATUS_COLOR);
            LevelLoadingScreenMixin.addRect(graphics, mapX - radius, mapY + radius - 1, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
        }
        int mapRenderSize = size * tileSize - mapPadding;
        int mapStartX = mapX - mapRenderSize / 2;
        int mapStartY = mapY - mapRenderSize / 2;
        class_2806 prevStatus = null;
        int prevColor = NULL_STATUS_COLOR;
        for (int x = 0; x < size; ++x) {
            int tileX = mapStartX + x * tileSize;
            for (int z = 0; z < size; ++z) {
                int color;
                int tileY = mapStartY + z * tileSize;
                class_2806 status = listener.method_17676(x, z);
                if (prevStatus == status) {
                    color = prevColor;
                } else {
                    color = STATUS_TO_COLOR_FAST.getInt((Object)status);
                    prevStatus = status;
                    prevColor = color;
                }
                LevelLoadingScreenMixin.addRect(graphics, tileX, tileY, tileX + mapScale, tileY + mapScale, color);
            }
        }
    }

    @Unique
    private static void addRect(class_332 graphics, int x1, int y1, int x2, int y2, int color) {
        graphics.method_25294(x1, y1, x2, y2, color);
    }

    static {
        NULL_STATUS_COLOR = ColorABGR.pack(0, 0, 0, 255);
        DEFAULT_STATUS_COLOR = ColorARGB.pack(0, 17, 255, 255);
    }
}

