/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.entity.movement;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.caffeinemc.mods.lithium.common.block.BlockCountingSection;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.shapes.VoxelShapeCaster;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_5539;
import org.jetbrains.annotations.Nullable;

public class ChunkAwareBlockCollisionSweeper
extends AbstractIterator<class_265> {
    private final class_2338.class_2339 pos = new class_2338.class_2339();
    private final class_238 box;
    private final class_265 shape;
    private final class_1937 world;
    private final class_3726 context;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private int chunkX;
    private int chunkYIndex;
    private int chunkZ;
    private int cStartX;
    private int cStartZ;
    private int cEndX;
    private int cEndZ;
    private int cX;
    private int cY;
    private int cZ;
    private int maxHitX;
    private int maxHitY;
    private int maxHitZ;
    private class_265 maxShape;
    private final boolean hideLastCollision;
    private int cTotalSize;
    private int cIterated;
    private boolean sectionOversizedBlocks;
    private class_2791 cachedChunk;
    private class_2826 cachedChunkSection;

    public ChunkAwareBlockCollisionSweeper(class_1937 world, @Nullable class_1297 entity, class_238 box) {
        this(world, entity, box, false);
    }

    public ChunkAwareBlockCollisionSweeper(class_1937 world, @Nullable class_1297 entity, class_238 box, boolean hideLastCollision) {
        this.box = box;
        this.shape = class_259.method_1078((class_238)box);
        this.context = entity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)entity);
        this.world = world;
        this.minX = class_3532.method_15357((double)(box.field_1323 - 1.0E-7));
        this.maxX = class_3532.method_15357((double)(box.field_1320 + 1.0E-7));
        this.minY = class_3532.method_15340((int)class_3532.method_15357((double)(box.field_1322 - 1.0E-7)), (int)Pos.BlockCoord.getMinY((class_5539)this.world), (int)Pos.BlockCoord.getMaxYInclusive((class_5539)this.world));
        this.maxY = class_3532.method_15340((int)class_3532.method_15357((double)(box.field_1325 + 1.0E-7)), (int)Pos.BlockCoord.getMinY((class_5539)this.world), (int)Pos.BlockCoord.getMaxYInclusive((class_5539)this.world));
        this.minZ = class_3532.method_15357((double)(box.field_1321 - 1.0E-7));
        this.maxZ = class_3532.method_15357((double)(box.field_1324 + 1.0E-7));
        this.chunkX = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minX));
        this.chunkZ = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minZ));
        this.cIterated = 0;
        this.cTotalSize = 0;
        this.maxHitX = Integer.MIN_VALUE;
        this.maxHitY = Integer.MIN_VALUE;
        this.maxHitZ = Integer.MIN_VALUE;
        this.maxShape = null;
        this.hideLastCollision = hideLastCollision;
        --this.chunkX;
    }

    public class_265 getLastCollision() {
        return this.maxShape;
    }

    public Iterator<class_265> getLastCollisionIterator() {
        return new Iterator<class_265>(){

            @Override
            public boolean hasNext() {
                return ChunkAwareBlockCollisionSweeper.this.hideLastCollision && ChunkAwareBlockCollisionSweeper.this.maxShape != null;
            }

            @Override
            public class_265 next() {
                if (this.hasNext()) {
                    class_265 previousMaxShape = ChunkAwareBlockCollisionSweeper.this.maxShape;
                    ChunkAwareBlockCollisionSweeper.this.maxShape = null;
                    return previousMaxShape;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private boolean nextSection() {
        while (true) {
            if (this.cachedChunk != null && this.chunkYIndex < Pos.SectionYIndex.getMaxYSectionIndexInclusive((class_5539)this.world) && this.chunkYIndex < Pos.SectionYIndex.fromBlockCoord((class_5539)this.world, ChunkAwareBlockCollisionSweeper.expandMax(this.maxY))) {
                ++this.chunkYIndex;
                this.cachedChunkSection = this.cachedChunk.method_12006()[this.chunkYIndex];
            } else {
                if (this.chunkX < Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMax(this.maxX))) {
                    ++this.chunkX;
                } else if (this.chunkZ < Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMax(this.maxZ))) {
                    this.chunkX = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minX));
                    ++this.chunkZ;
                } else {
                    return false;
                }
                this.cachedChunk = this.world.method_8402(this.chunkX, this.chunkZ, class_2806.field_12803, false);
                if (this.cachedChunk != null) {
                    this.chunkYIndex = class_3532.method_15340((int)Pos.SectionYIndex.fromBlockCoord((class_5539)this.world, ChunkAwareBlockCollisionSweeper.expandMin(this.minY)), (int)Pos.SectionYIndex.getMinYSectionIndex((class_5539)this.world), (int)Pos.SectionYIndex.getMaxYSectionIndexInclusive((class_5539)this.world));
                    this.cachedChunkSection = this.cachedChunk.method_12006()[this.chunkYIndex];
                }
            }
            if (this.cachedChunk == null || this.cachedChunkSection == null || this.cachedChunkSection.method_38292()) continue;
            this.sectionOversizedBlocks = ChunkAwareBlockCollisionSweeper.hasChunkSectionOversizedBlocks(this.cachedChunk, this.chunkYIndex);
            int sizeExtension = this.sectionOversizedBlocks ? 1 : 0;
            this.cEndX = Math.min(this.maxX + sizeExtension, Pos.BlockCoord.getMaxInSectionCoord(this.chunkX));
            int cEndY = Math.min(this.maxY + sizeExtension, Pos.BlockCoord.getMaxYInSectionIndex((class_5539)this.world, this.chunkYIndex));
            this.cEndZ = Math.min(this.maxZ + sizeExtension, Pos.BlockCoord.getMaxInSectionCoord(this.chunkZ));
            this.cStartX = Math.max(this.minX - sizeExtension, Pos.BlockCoord.getMinInSectionCoord(this.chunkX));
            int cStartY = Math.max(this.minY - sizeExtension, Pos.BlockCoord.getMinYInSectionIndex((class_5539)this.world, this.chunkYIndex));
            this.cStartZ = Math.max(this.minZ - sizeExtension, Pos.BlockCoord.getMinInSectionCoord(this.chunkZ));
            this.cX = this.cStartX;
            this.cY = cStartY;
            this.cZ = this.cStartZ;
            this.cTotalSize = (this.cEndX - this.cStartX + 1) * (cEndY - cStartY + 1) * (this.cEndZ - this.cStartZ + 1);
            if (this.cTotalSize != 0) break;
        }
        this.cIterated = 0;
        return true;
    }

    public class_265 computeNext() {
        while (this.cIterated < this.cTotalSize || this.nextSection()) {
            class_265 collidedShape;
            class_2680 state;
            int edgesHit;
            ++this.cIterated;
            int x = this.cX;
            int y = this.cY++;
            int z = this.cZ;
            if (this.cX < this.cEndX) {
                ++this.cX;
            } else if (this.cZ < this.cEndZ) {
                this.cX = this.cStartX;
                ++this.cZ;
            } else {
                this.cX = this.cStartX;
                this.cZ = this.cStartZ;
            }
            if ((edgesHit = this.sectionOversizedBlocks ? (x < this.minX || x > this.maxX ? 1 : 0) + (y < this.minY || y > this.maxY ? 1 : 0) + (z < this.minZ || z > this.maxZ ? 1 : 0) : 0) == 3 || !ChunkAwareBlockCollisionSweeper.canInteractWithBlock(state = this.cachedChunkSection.method_12254(x & 0xF, y & 0xF, z & 0xF), edgesHit)) continue;
            this.pos.method_10103(x, y, z);
            class_265 collisionShape = this.context.method_62878(state, (class_1941)this.world, (class_2338)this.pos);
            if (collisionShape == class_259.method_1073() || collisionShape == null || (collidedShape = ChunkAwareBlockCollisionSweeper.getCollidedShape(this.box, this.shape, collisionShape, x, y, z)) == null) continue;
            if (z >= this.maxHitZ && (z > this.maxHitZ || y >= this.maxHitY && (y > this.maxHitY || x > this.maxHitX))) {
                this.maxHitX = x;
                this.maxHitY = y;
                this.maxHitZ = z;
                class_265 previousMaxShape = this.maxShape;
                this.maxShape = collidedShape;
                if (previousMaxShape == null) continue;
                return previousMaxShape;
            }
            return collidedShape;
        }
        if (!this.hideLastCollision && this.maxShape != null) {
            class_265 previousMaxShape = this.maxShape;
            this.maxShape = null;
            return previousMaxShape;
        }
        return (class_265)this.endOfData();
    }

    private static boolean canInteractWithBlock(class_2680 state, int edgesHit) {
        return !(edgesHit == 1 && !state.method_26209() || edgesHit == 2 && state.method_26204() != class_2246.field_10008);
    }

    private static class_265 getCollidedShape(class_238 entityBox, class_265 entityShape, class_265 shape, int x, int y, int z) {
        if (shape == class_259.method_1077()) {
            return entityBox.method_1003((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0) ? shape.method_1096((double)x, (double)y, (double)z) : null;
        }
        if (shape instanceof VoxelShapeCaster) {
            if (((VoxelShapeCaster)shape).intersects(entityBox, x, y, z)) {
                return shape.method_1096((double)x, (double)y, (double)z);
            }
            return null;
        }
        if (class_259.method_1074((class_265)(shape = shape.method_1096((double)x, (double)y, (double)z)), (class_265)entityShape, (class_247)class_247.field_16896)) {
            return shape;
        }
        return null;
    }

    private static int expandMin(int coord) {
        return coord - 1;
    }

    private static int expandMax(int coord) {
        return coord + 1;
    }

    private static boolean hasChunkSectionOversizedBlocks(class_2791 chunk, int chunkY) {
        if (BlockStateFlags.ENABLED) {
            class_2826 section = chunk.method_12006()[chunkY];
            return section != null && ((BlockCountingSection)section).lithium$mayContainAny(BlockStateFlags.OVERSIZED_SHAPE);
        }
        return true;
    }

    public List<class_265> collectAll() {
        ArrayList<class_265> collisions = new ArrayList<class_265>();
        while (this.hasNext()) {
            collisions.add((class_265)this.next());
        }
        return collisions;
    }
}

