/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.components.image.ImageProvider;
import gg.essential.elementa.svg.SVGParser;
import gg.essential.elementa.svg.data.SVG;
import gg.essential.elementa.svg.data.SVGElement;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J8\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u000eJ\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgg/essential/elementa/components/SVGComponent;", "Lgg/essential/elementa/UIComponent;", "Lgg/essential/elementa/components/image/ImageProvider;", "svg", "Lgg/essential/elementa/svg/data/SVG;", "(Lgg/essential/elementa/svg/data/SVG;)V", "needsReload", "", "vboData", "", "Lgg/essential/elementa/components/SVGComponent$Companion$VBOData;", "vboID", "", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawImage", "x", "", "y", "width", "height", "color", "Ljava/awt/Color;", "finalize", "generateVBOData", "setSVG", "Companion", "Elementa"})
@SourceDebugExtension(value={"SMAP\nSVGComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGComponent.kt\ngg/essential/elementa/components/SVGComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1#2:143\n1547#3:144\n1618#3,3:145\n*S KotlinDebug\n*F\n+ 1 SVGComponent.kt\ngg/essential/elementa/components/SVGComponent\n*L\n113#1:144\n113#1:145,3\n*E\n"})
public final class SVGComponent
extends UIComponent
implements ImageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SVG svg;
    private int vboID;
    private List<Companion.VBOData> vboData;
    private boolean needsReload;

    public SVGComponent(@NotNull SVG svg) {
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        this.svg = svg;
        this.vboID = -1;
    }

    public final void setSVG(@NotNull SVG svg) {
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        this.svg = svg;
        this.needsReload = true;
    }

    @Override
    public void drawImage(@NotNull UMatrixStack matrixStack, double x, double y, double width, double height, @NotNull Color color) {
        double d;
        double d2;
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (UGraphics.isCoreProfile()) {
            return;
        }
        if (this.vboData == null || this.needsReload) {
            this.generateVBOData();
            this.needsReload = false;
        }
        Float f = this.svg.getWidth();
        if (f != null) {
            Float f2 = f;
            float it = ((Number)f2).floatValue();
            boolean bl = false;
            d2 = width / (double)it;
        } else {
            d2 = 1.0;
        }
        double xScale = d2;
        Float f3 = this.svg.getHeight();
        if (f3 != null) {
            Float f4 = f3;
            float it = ((Number)f4).floatValue();
            boolean bl = false;
            d = height / (double)it;
        } else {
            d = 1.0;
        }
        double yScale = d;
        float strokeWidth = RangesKt.coerceAtMost((float)((float)(xScale * (double)this.svg.getStrokeWidth())), (float)10.0f);
        matrixStack.push();
        UGraphics.enableBlend();
        UGraphics.disableTexture2D();
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        matrixStack.translate(x, y, 0.0);
        matrixStack.scale(xScale, yScale, 0.0);
        GL11.glPointSize((float)strokeWidth);
        GL11.glLineWidth((float)strokeWidth);
        GL11.glEnable((int)2848);
        GL11.glEnable((int)2832);
        GL15.glBindBuffer((int)34962, (int)this.vboID);
        GL11.glEnableClientState((int)32884);
        GL11.glVertexPointer((int)2, (int)5126, (int)0, (long)0L);
        matrixStack.runWithGlobalState((Function0)new Function0<Unit>(this){
            final /* synthetic */ SVGComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                List list = SVGComponent.access$getVboData$p(this.this$0);
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"vboData");
                    list = null;
                }
                Iterable iterable = list;
                SVGComponent sVGComponent = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Companion.VBOData vBOData = (Companion.VBOData)element$iv;
                    boolean bl = false;
                    int drawType = vBOData.component1();
                    int startIndex = vBOData.component2();
                    int vertexCount = vBOData.component3();
                    boolean drawPoints = vBOData.component4();
                    GL11.glDrawArrays((int)drawType, (int)startIndex, (int)vertexCount);
                    if (!drawPoints || !SVGComponent.access$getSvg$p(sVGComponent).getRoundLineJoins()) continue;
                    GL11.glDrawArrays((int)0, (int)startIndex, (int)vertexCount);
                }
            }
        });
        GL11.glDisable((int)2848);
        GL11.glDisable((int)2832);
        GL11.glDisableClientState((int)32884);
        GL15.glBindBuffer((int)34962, (int)0);
        UGraphics.enableTexture2D();
        matrixStack.pop();
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDraw(matrixStack);
        double x = this.getLeft();
        double y = this.getTop();
        double width = this.getWidth();
        double height = this.getHeight();
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            super.draw(matrixStack);
            return;
        }
        this.drawImage(matrixStack, x, y, width, height, color);
        super.draw(matrixStack);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateVBOData() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void it;
        this.vboID = GL15.glGenBuffers();
        Iterable iterable = this.svg.getElements();
        int n = 0;
        for (Object t : iterable) {
            SVGElement sVGElement = (SVGElement)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getVertexCount();
            n = n2 + n3;
        }
        int totalVertexCount = n;
        FloatBuffer vertexBuffer = BufferUtils.createFloatBuffer((int)(totalVertexCount * 2));
        int currPos = 0;
        Iterable iterable2 = this.svg.getElements();
        SVGComponent sVGComponent = this;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Companion.VBOData vBOData;
            void el;
            SVGElement sVGElement = (SVGElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int vertexCount = el.getVertexCount();
            Intrinsics.checkNotNullExpressionValue((Object)vertexBuffer, (String)"vertexBuffer");
            Companion.VBOData it2 = vBOData = new Companion.VBOData(el.createBuffer(vertexBuffer), currPos, vertexCount, el.drawSmoothPoints());
            boolean bl2 = false;
            currPos += vertexCount;
            collection.add(vBOData);
        }
        sVGComponent.vboData = (List)destination$iv$iv;
        vertexBuffer.rewind();
        GL15.glBindBuffer((int)34962, (int)this.vboID);
        GL15.glBufferData((int)34962, (FloatBuffer)vertexBuffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public final void finalize() {
        int vboID = this.vboID;
        if (vboID != -1) {
            Window.Companion.enqueueRenderOperation((Function0<Unit>)((Function0)new Function0<Unit>(vboID){
                final /* synthetic */ int $vboID;
                {
                    this.$vboID = $vboID;
                    super(0);
                }

                public final void invoke() {
                    GL15.glDeleteBuffers((int)this.$vboID);
                }
            }));
        }
    }

    public static final /* synthetic */ List access$getVboData$p(SVGComponent $this) {
        return $this.vboData;
    }

    public static final /* synthetic */ SVG access$getSvg$p(SVGComponent $this) {
        return $this.svg;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lgg/essential/elementa/components/SVGComponent$Companion;", "", "()V", "ofResource", "Lgg/essential/elementa/components/SVGComponent;", "resourcePath", "", "VBOData", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SVGComponent ofResource(@NotNull String resourcePath) {
            Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
            return new SVGComponent(SVGParser.INSTANCE.parseFromResource(resourcePath));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lgg/essential/elementa/components/SVGComponent$Companion$VBOData;", "", "drawType", "", "startIndex", "count", "drawPoints", "", "(IIIZ)V", "getCount", "()I", "getDrawPoints", "()Z", "getDrawType", "getStartIndex", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "Elementa"})
        private static final class VBOData {
            private final int drawType;
            private final int startIndex;
            private final int count;
            private final boolean drawPoints;

            public VBOData(int drawType, int startIndex, int count, boolean drawPoints) {
                this.drawType = drawType;
                this.startIndex = startIndex;
                this.count = count;
                this.drawPoints = drawPoints;
            }

            public final int getDrawType() {
                return this.drawType;
            }

            public final int getStartIndex() {
                return this.startIndex;
            }

            public final int getCount() {
                return this.count;
            }

            public final boolean getDrawPoints() {
                return this.drawPoints;
            }

            public final int component1() {
                return this.drawType;
            }

            public final int component2() {
                return this.startIndex;
            }

            public final int component3() {
                return this.count;
            }

            public final boolean component4() {
                return this.drawPoints;
            }

            @NotNull
            public final VBOData copy(int drawType, int startIndex, int count, boolean drawPoints) {
                return new VBOData(drawType, startIndex, count, drawPoints);
            }

            public static /* synthetic */ VBOData copy$default(VBOData vBOData, int n, int n2, int n3, boolean bl, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = vBOData.drawType;
                }
                if ((n4 & 2) != 0) {
                    n2 = vBOData.startIndex;
                }
                if ((n4 & 4) != 0) {
                    n3 = vBOData.count;
                }
                if ((n4 & 8) != 0) {
                    bl = vBOData.drawPoints;
                }
                return vBOData.copy(n, n2, n3, bl);
            }

            @NotNull
            public String toString() {
                return "VBOData(drawType=" + this.drawType + ", startIndex=" + this.startIndex + ", count=" + this.count + ", drawPoints=" + this.drawPoints + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.drawType);
                result = result * 31 + Integer.hashCode(this.startIndex);
                result = result * 31 + Integer.hashCode(this.count);
                result = result * 31 + Boolean.hashCode(this.drawPoints);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VBOData)) {
                    return false;
                }
                VBOData vBOData = (VBOData)other;
                if (this.drawType != vBOData.drawType) {
                    return false;
                }
                if (this.startIndex != vBOData.startIndex) {
                    return false;
                }
                if (this.count != vBOData.count) {
                    return false;
                }
                return this.drawPoints == vBOData.drawPoints;
            }
        }
    }
}

