/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.repo;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.data.repo.ChatProgressUpdates;
import at.hannibal2.skyhanni.data.repo.DiskRepoFileSystem;
import at.hannibal2.skyhanni.data.repo.RepoFileSystem;
import at.hannibal2.skyhanni.data.repo.RepoLogger;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0018\u0010!\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b$\u0010\u0006J!\u0010(\u001a\u00020\u0010*\u00020%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0002\u00a2\u0006\u0004\b(\u0010)R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010*R \u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0018\u0010/\u001a\u0004\u0018\u00010.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00061"}, d2={"Lat/hannibal2/skyhanni/data/repo/MemoryRepoFileSystem;", "Lat/hannibal2/skyhanni/data/repo/RepoFileSystem;", "Lkotlinx/coroutines/DisposableHandle;", "Ljava/io/File;", "diskRoot", "<init>", "(Ljava/io/File;)V", "", "path", "", "exists", "(Ljava/lang/String;)Z", "", "readAllBytes", "(Ljava/lang/String;)[B", "data", "", "write", "(Ljava/lang/String;[B)V", "deleteRecursively", "(Ljava/lang/String;)V", "", "list", "(Ljava/lang/String;)Ljava/util/List;", "Lat/hannibal2/skyhanni/data/repo/ChatProgressUpdates;", "progress", "zipFile", "Lat/hannibal2/skyhanni/data/repo/RepoLogger;", "logger", "loadFromZip", "(Lat/hannibal2/skyhanni/data/repo/ChatProgressUpdates;Ljava/io/File;Lat/hannibal2/skyhanni/data/repo/RepoLogger;)Z", "dispose", "()V", "transitionAfterReload", "(Lat/hannibal2/skyhanni/data/repo/ChatProgressUpdates;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "root", "saveToDisk", "Ljava/nio/file/Path;", "", "relativePaths", "createDirectoriesFor", "(Ljava/nio/file/Path;Ljava/util/Set;)V", "Ljava/io/File;", "Ljava/util/concurrent/ConcurrentHashMap;", "storage", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlinx/coroutines/Job;", "flushJob", "Lkotlinx/coroutines/Job;", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nRepoFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoFileSystem.kt\nat/hannibal2/skyhanni/data/repo/MemoryRepoFileSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n774#2:177\n865#2,2:178\n1563#2:180\n1634#2,3:181\n1617#2,9:184\n1869#2:193\n1870#2:195\n1626#2:196\n1869#2,2:197\n1#3:194\n*S KotlinDebug\n*F\n+ 1 RepoFileSystem.kt\nat/hannibal2/skyhanni/data/repo/MemoryRepoFileSystem\n*L\n123#1:177\n123#1:178,2\n125#1:180\n125#1:181,3\n170#1:184,9\n170#1:193\n170#1:195\n170#1:196\n172#1:197,2\n170#1:194\n*E\n"})
public final class MemoryRepoFileSystem
implements RepoFileSystem,
DisposableHandle {
    @NotNull
    private final File diskRoot;
    @NotNull
    private final ConcurrentHashMap<String, byte[]> storage;
    @Nullable
    private Job flushJob;

    public MemoryRepoFileSystem(@NotNull File diskRoot) {
        Intrinsics.checkNotNullParameter((Object)diskRoot, (String)"diskRoot");
        this.diskRoot = diskRoot;
        this.storage = new ConcurrentHashMap();
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.storage.containsKey(path);
    }

    @Override
    @NotNull
    public byte[] readAllBytes(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] byArray = this.storage.get(path);
        if (byArray == null) {
            throw new FileNotFoundException(path);
        }
        return byArray;
    }

    @Override
    public void write(@NotNull String path, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ((Map)this.storage).put(path, data);
    }

    @Override
    public void deleteRecursively(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (((CharSequence)path).length() == 0) {
            this.storage.clear();
        } else {
            ((ConcurrentHashMap.KeySetView)this.storage.keySet()).removeIf(arg_0 -> MemoryRepoFileSystem.deleteRecursively$lambda$1(arg_0 -> MemoryRepoFileSystem.deleteRecursively$lambda$0(path, arg_0), arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> list(@NotNull String path) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Set set = this.storage.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(StringsKt.startsWith$default((String)it, (String)(path + "/"), (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)StringsKt.removePrefix((String)it, (CharSequence)(path + "/")), (String)".json", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(StringsKt.removePrefix((String)it, (CharSequence)(path + "/")));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean loadFromZip(@NotNull ChatProgressUpdates progress, @NotNull File zipFile, @NotNull RepoLogger logger) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        progress.update("repo file system loadFromZip");
        boolean success = RepoFileSystem.DefaultImpls.loadFromZip(this, progress, zipFile, logger);
        if (this.flushJob == null) {
            progress.update("start new launchIOCoroutine task");
            this.flushJob = SkyHanniMod.INSTANCE.launchIOCoroutine-8Mi8wO0("repo file saveToDisk", DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MemoryRepoFileSystem this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            MemoryRepoFileSystem.access$saveToDisk(this.this$0, MemoryRepoFileSystem.access$getDiskRoot$p(this.this$0));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        progress.update("loadFromZip end");
        return success;
    }

    public void dispose() {
        this.storage.clear();
    }

    @Override
    @Nullable
    public Object transitionAfterReload(@NotNull ChatProgressUpdates progress, @NotNull Continuation<? super RepoFileSystem> $completion) {
        progress.update("waiting on flushJob");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MemoryRepoFileSystem this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block5: {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = MemoryRepoFileSystem.access$getFlushJob$p(this.this$0);
                            if (v0 == null) break;
                            this.label = 1;
                            v1 = v0.join((Continuation)this);
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl15:
                            // 2 sources

                            v2 = Unit.INSTANCE;
                            break block5;
                        }
                    }
                    v2 = null;
                }
                return v2;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        progress.update("dispose");
        this.dispose();
        progress.update("transitionAfterReload end");
        return new DiskRepoFileSystem(this.diskRoot);
    }

    private final void saveToDisk(File root) {
        ChatProgressUpdates progress = new ChatProgressUpdates();
        progress.start("saveToDisk start");
        Path base = root.toPath();
        progress.update("createDirectoriesFor");
        Intrinsics.checkNotNull((Object)base);
        Set set = this.storage.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        this.createDirectoriesFor(base, set);
        progress.update("parallelStream forEach resolve write");
        Set<Map.Entry<String, byte[]>> set2 = this.storage.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
        List entries = CollectionsKt.toList((Iterable)set2);
        progress.innerProgressStart(entries.size());
        entries.parallelStream().forEach(arg_0 -> MemoryRepoFileSystem.saveToDisk$lambda$5(arg_0 -> MemoryRepoFileSystem.saveToDisk$lambda$4(progress, base, arg_0), arg_0));
        progress.end("saveToDisk end");
    }

    /*
     * WARNING - void declaration
     */
    private final void createDirectoriesFor(Path $this$createDirectoriesFor, Set<String> relativePaths) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = relativePaths;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String p = (String)element$iv$iv;
            boolean bl2 = false;
            if (Paths.get(p, new String[0]).getParent() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Path dir = (Path)element$iv;
            boolean bl = false;
            Files.createDirectories($this$createDirectoriesFor.resolve(dir), new FileAttribute[0]);
        }
    }

    @Override
    public void deleteAll() {
        RepoFileSystem.DefaultImpls.deleteAll(this);
    }

    @Override
    @NotNull
    public JsonElement readAllBytesAsJsonElement(@NotNull String path, @NotNull Gson gson) {
        return RepoFileSystem.DefaultImpls.readAllBytesAsJsonElement(this, path, gson);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean deleteRecursively$lambda$0(String $path, String it) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        if (Intrinsics.areEqual((Object)it, (Object)$path)) return true;
        Intrinsics.checkNotNull((Object)it);
        if (!StringsKt.startsWith$default((String)it, (String)($path + "/"), (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean deleteRecursively$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit saveToDisk$lambda$4(ChatProgressUpdates $progress, Path $base, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)$progress, (String)"$progress");
        Intrinsics.checkNotNull((Object)entry);
        Object k = entry.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
        String relativePath = (String)k;
        Object v = entry.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
        byte[] bytes = (byte[])v;
        $progress.innerProgressStep();
        Path out = $base.resolve(relativePath);
        Files.write(out, bytes, new OpenOption[0]);
        return Unit.INSTANCE;
    }

    private static final void saveToDisk$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$saveToDisk(MemoryRepoFileSystem $this, File root) {
        $this.saveToDisk(root);
    }

    public static final /* synthetic */ File access$getDiskRoot$p(MemoryRepoFileSystem $this) {
        return $this.diskRoot;
    }

    public static final /* synthetic */ Job access$getFlushJob$p(MemoryRepoFileSystem $this) {
        return $this.flushJob;
    }
}

