/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.gui.customscoreboard;

import at.hannibal2.skyhanni.config.features.gui.customscoreboard.DisplayConfig;
import at.hannibal2.skyhanni.data.BitsApi;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.MiningApi;
import at.hannibal2.skyhanni.data.ScoreboardData;
import at.hannibal2.skyhanni.data.model.TabWidget;
import at.hannibal2.skyhanni.features.bingo.BingoApi;
import at.hannibal2.skyhanni.features.gui.customscoreboard.CustomScoreboard;
import at.hannibal2.skyhanni.features.gui.customscoreboard.ScoreboardLine;
import at.hannibal2.skyhanni.features.gui.customscoreboard.ScoreboardPattern;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001=B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001c\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u0012J\u000f\u0010\u001e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u0012J\u000f\u0010 \u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u001f\u0010\u0012J\u000f\u0010\"\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b!\u0010\u0012J\u000f\u0010$\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b#\u0010\u0012J\u000f\u0010&\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b%\u0010\u0012J\u000f\u0010(\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b'\u0010\u0012J\u000f\u0010*\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b)\u0010\u0012J\u0011\u0010,\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0004\b+\u0010\u0012J\u000f\u0010.\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b-\u0010\u0012J\u000f\u00100\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b/\u0010\u0012J\u0011\u00102\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0004\b1\u0010\u0012J\u001f\u00107\u001a\b\u0012\u0004\u0012\u0002040\f2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0004\b5\u00106J\u0015\u00108\u001a\u0004\u0018\u000104*\u00020\u0001H\u0002\u00a2\u0006\u0004\b8\u00109J\u0015\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0000\u00a2\u0006\u0004\b:\u0010;\u00a8\u0006>"}, d2={"Lat/hannibal2/skyhanni/features/gui/customscoreboard/CustomScoreboardUtils;", "", "<init>", "()V", "", "text", "number", "color", "formatNumberDisplay", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Ljava/util/regex/Pattern;", "pattern", "", "list", "group", "getGroup", "(Ljava/util/regex/Pattern;Ljava/util/List;Ljava/lang/String;)Ljava/lang/String;", "getProfileTypeSymbol", "()Ljava/lang/String;", "", "formatNumber$1_21_7", "(Ljava/lang/Number;)Ljava/lang/String;", "formatNumber", "string", "formatStringNum$1_21_7", "(Ljava/lang/String;)Ljava/lang/String;", "formatStringNum", "getMotes$1_21_7", "getMotes", "getSoulflow$1_21_7", "getSoulflow", "getBank$1_21_7", "getBank", "getBits$1_21_7", "getBits", "getBitsAvailable$1_21_7", "getBitsAvailable", "getBitsLine$1_21_7", "getBitsLine", "getCopper$1_21_7", "getCopper", "getGems$1_21_7", "getGems", "getHeat$1_21_7", "getHeat", "getNorthStars$1_21_7", "getNorthStars", "getTimeSymbol$1_21_7", "getTimeSymbol", "getTablistEvent$1_21_7", "getTablistEvent", "element", "Lat/hannibal2/skyhanni/features/gui/customscoreboard/ScoreboardLine;", "getElementsFromAny$1_21_7", "(Ljava/lang/Object;)Ljava/util/List;", "getElementsFromAny", "toScoreboardElement", "(Ljava/lang/Object;)Lat/hannibal2/skyhanni/features/gui/customscoreboard/ScoreboardLine;", "getSBLines$1_21_7", "()Ljava/util/List;", "getSBLines", "NumberDisplayFormat", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nCustomScoreboardUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomScoreboardUtils.kt\nat/hannibal2/skyhanni/features/gui/customscoreboard/CustomScoreboardUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TabWidget.kt\nat/hannibal2/skyhanni/data/model/TabWidget\n+ 4 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1563#2:115\n1634#2,3:116\n1617#2,9:140\n1869#2:149\n1870#2:151\n1626#2:152\n405#3,2:119\n407#3:123\n405#3,2:124\n407#3:129\n405#3,2:130\n407#3:134\n405#3,2:135\n407#3:139\n8#4:121\n8#4:126\n8#4:132\n8#4:137\n1#5:122\n1#5:127\n1#5:128\n1#5:133\n1#5:138\n1#5:150\n*S KotlinDebug\n*F\n+ 1 CustomScoreboardUtils.kt\nat/hannibal2/skyhanni/features/gui/customscoreboard/CustomScoreboardUtils\n*L\n50#1:115\n50#1:116,3\n102#1:140,9\n102#1:149\n102#1:151\n102#1:152\n74#1:119,2\n74#1:123\n76#1:124,2\n76#1:129\n90#1:130,2\n90#1:134\n98#1:135,2\n98#1:139\n74#1:121\n76#1:126\n90#1:132\n98#1:137\n74#1:122\n76#1:127\n90#1:133\n98#1:138\n102#1:150\n*E\n"})
public final class CustomScoreboardUtils {
    @NotNull
    public static final CustomScoreboardUtils INSTANCE = new CustomScoreboardUtils();

    private CustomScoreboardUtils() {
    }

    @NotNull
    public final String formatNumberDisplay(@NotNull String text, @NotNull String number, @NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Object formattedNumber = TimeUtils.INSTANCE.isAprilFoolsDay() ? "-" + number : number;
        return switch (WhenMappings.$EnumSwitchMapping$0[CustomScoreboard.INSTANCE.getDisplayConfig$1_21_7().getNumberDisplayFormat().ordinal()]) {
            case 1 -> "\u00a7f" + text + ": " + color + (String)formattedNumber;
            case 2 -> color + text + ": " + (String)formattedNumber;
            case 3 -> color + (String)formattedNumber + " " + color + text;
            case 4 -> color + (String)formattedNumber + " \u00a7f" + text;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final String getGroup(Pattern pattern, List<String> list, String group) {
        Object object;
        block2: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringUtils.INSTANCE.trimWhiteSpace(StringUtils.INSTANCE.removeResets((String)it)));
            }
            for (String line : (Iterable)((List)destination$iv$iv)) {
                boolean bl = false;
                object2 = RegexUtils.INSTANCE.matchGroup(pattern, line, group);
                if (object2 == null) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return object;
    }

    @NotNull
    public final String getProfileTypeSymbol() {
        String string;
        if (HypixelData.INSTANCE.getIronman()) {
            string = "\u00a77\u2672 ";
        } else if (HypixelData.INSTANCE.getStranded()) {
            string = "\u00a7a\u2600 ";
        } else if (HypixelData.INSTANCE.getBingo()) {
            Object object;
            block8: {
                for (String it : (Iterable)ScoreboardData.INSTANCE.getSidebarLinesFormatted()) {
                    boolean bl = false;
                    String string2 = BingoApi.INSTANCE.getIconFromScoreboard(it);
                    String string3 = string2 != null ? string2 + " " : null;
                    if (string3 == null) continue;
                    object = string3;
                    break block8;
                }
                object = string = null;
            }
            if (object == null) {
                string = "\u00a7e\u2764 ";
            }
        } else {
            string = "\u00a7e";
        }
        return string;
    }

    @NotNull
    public final String formatNumber$1_21_7(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return switch (WhenMappings.$EnumSwitchMapping$1[CustomScoreboard.INSTANCE.getDisplayConfig$1_21_7().getNumberFormat().ordinal()]) {
            case 1 -> NumberUtil.shortFormat$default(NumberUtil.INSTANCE, number, false, 1, null);
            case 2 -> NumberUtil.INSTANCE.addSeparators(number);
            default -> "0";
        };
    }

    @NotNull
    public final String formatStringNum$1_21_7(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.formatNumber$1_21_7(NumberUtil.INSTANCE.formatDouble(string));
    }

    @NotNull
    public final String getMotes$1_21_7() {
        String string = this.getGroup(ScoreboardPattern.INSTANCE.getMotesPattern(), this.getSBLines$1_21_7(), "motes");
        if (string == null) {
            string = "0";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getSoulflow$1_21_7() {
        String string;
        String string2;
        TabWidget this_$iv = TabWidget.SOULFLOW;
        boolean $i$f$matchMatcherFirstLine = false;
        if (this_$iv.isActive()) {
            void $this$matchMatcher$iv$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern pattern = this_$iv.getPattern();
            String text$iv$iv = (String)CollectionsKt.first(this_$iv.getLines());
            boolean $i$f$matchMatcher = false;
            Matcher it$iv$iv = $this$matchMatcher$iv$iv.matcher(text$iv$iv);
            boolean bl = false;
            if (it$iv$iv.matches()) {
                Intrinsics.checkNotNull((Object)it$iv$iv);
                Matcher $this$getSoulflow_u24lambda_u243 = it$iv$iv;
                boolean bl2 = false;
                string2 = $this$getSoulflow_u24lambda_u243.group("amount");
            } else {
                string2 = null;
            }
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "0";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getBank$1_21_7() {
        String string;
        Object object;
        TabWidget this_$iv = TabWidget.BANK;
        boolean $i$f$matchMatcherFirstLine = false;
        if (this_$iv.isActive()) {
            void $this$matchMatcher$iv$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern pattern = this_$iv.getPattern();
            String text$iv$iv = (String)CollectionsKt.first(this_$iv.getLines());
            boolean $i$f$matchMatcher = false;
            Matcher it$iv$iv = $this$matchMatcher$iv$iv.matcher(text$iv$iv);
            boolean bl = false;
            if (it$iv$iv.matches()) {
                String string2;
                Object object2;
                Intrinsics.checkNotNull((Object)it$iv$iv);
                Matcher $this$getBank_u24lambda_u245 = it$iv$iv;
                boolean bl2 = false;
                String string3 = $this$getBank_u24lambda_u245.group("amount");
                String string4 = RegexUtils.INSTANCE.groupOrNull($this$getBank_u24lambda_u245, "personal");
                if (string4 != null) {
                    void it;
                    String string5 = string4;
                    String string6 = string3;
                    boolean bl3 = false;
                    object2 = " \u00a77/ \u00a76" + (String)it;
                    string3 = string6;
                } else {
                    object2 = string2 = null;
                }
                if (object2 == null) {
                    string2 = "";
                }
                object = string3 + string2;
            } else {
                object = null;
            }
        } else {
            object = string = null;
        }
        if (object == null) {
            string = "0";
        }
        return string;
    }

    @NotNull
    public final String getBits$1_21_7() {
        return this.formatNumber$1_21_7(RangesKt.coerceAtLeast((int)BitsApi.INSTANCE.getBits(), (int)0));
    }

    @NotNull
    public final String getBitsAvailable$1_21_7() {
        return this.formatNumber$1_21_7(RangesKt.coerceAtLeast((int)BitsApi.INSTANCE.getBitsAvailable(), (int)0));
    }

    @NotNull
    public final String getBitsLine$1_21_7() {
        return CustomScoreboard.INSTANCE.getDisplayConfig$1_21_7().getShowUnclaimedBits() ? "\u00a7b" + this.getBits$1_21_7() + "\u00a77/\u00a7b" + this.getBitsAvailable$1_21_7() : "\u00a7b" + this.getBits$1_21_7();
    }

    @NotNull
    public final String getCopper$1_21_7() {
        String string = this.getGroup(ScoreboardPattern.INSTANCE.getCopperPattern(), this.getSBLines$1_21_7(), "copper");
        if (string == null) {
            string = "0";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getGems$1_21_7() {
        String string;
        String string2;
        TabWidget this_$iv = TabWidget.GEMS;
        boolean $i$f$matchMatcherFirstLine = false;
        if (this_$iv.isActive()) {
            void $this$matchMatcher$iv$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern pattern = this_$iv.getPattern();
            String text$iv$iv = (String)CollectionsKt.first(this_$iv.getLines());
            boolean $i$f$matchMatcher = false;
            Matcher it$iv$iv = $this$matchMatcher$iv$iv.matcher(text$iv$iv);
            boolean bl = false;
            if (it$iv$iv.matches()) {
                Intrinsics.checkNotNull((Object)it$iv$iv);
                Matcher $this$getGems_u24lambda_u246 = it$iv$iv;
                boolean bl2 = false;
                string2 = $this$getGems_u24lambda_u246.group("gems");
            } else {
                string2 = null;
            }
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "0";
        }
        return string;
    }

    @Nullable
    public final String getHeat$1_21_7() {
        return MiningApi.INSTANCE.getHeatDisplay();
    }

    @NotNull
    public final String getNorthStars$1_21_7() {
        String string = this.getGroup(ScoreboardPattern.INSTANCE.getNorthstarsPattern(), this.getSBLines$1_21_7(), "northStars");
        if (string == null) {
            string = "0";
        }
        return string;
    }

    @NotNull
    public final String getTimeSymbol$1_21_7() {
        String string = this.getGroup(ScoreboardPattern.INSTANCE.getTimePattern(), this.getSBLines$1_21_7(), "symbol");
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getTablistEvent$1_21_7() {
        String string;
        TabWidget this_$iv = TabWidget.EVENT;
        boolean $i$f$matchMatcherFirstLine = false;
        if (this_$iv.isActive()) {
            void $this$matchMatcher$iv$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern pattern = this_$iv.getPattern();
            String text$iv$iv = (String)CollectionsKt.first(this_$iv.getLines());
            boolean $i$f$matchMatcher = false;
            Matcher it$iv$iv = $this$matchMatcher$iv$iv.matcher(text$iv$iv);
            boolean bl = false;
            if (it$iv$iv.matches()) {
                Intrinsics.checkNotNull((Object)it$iv$iv);
                Matcher $this$getTablistEvent_u24lambda_u247 = it$iv$iv;
                boolean bl2 = false;
                string = RegexUtils.INSTANCE.groupOrNull($this$getTablistEvent_u24lambda_u247, "color") + $this$getTablistEvent_u24lambda_u247.group("event");
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ScoreboardLine> getElementsFromAny$1_21_7(@Nullable Object element) {
        List list;
        Object object = element;
        if (object == null) {
            list = CollectionsKt.emptyList();
        } else if (object instanceof List) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)element;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ScoreboardLine it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl2 = false;
                Object t = it;
                if ((t != null ? INSTANCE.toScoreboardElement(t) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOfNotNull((Object)this.toScoreboardElement(element));
        }
        return list;
    }

    private final ScoreboardLine toScoreboardElement(Object $this$toScoreboardElement) {
        Object object = $this$toScoreboardElement;
        return object instanceof String ? ScoreboardLine.Companion.align((String)$this$toScoreboardElement) : (object instanceof ScoreboardLine ? (ScoreboardLine)$this$toScoreboardElement : null);
    }

    @NotNull
    public final List<String> getSBLines$1_21_7() {
        return ScoreboardData.INSTANCE.getSidebarLinesFormatted();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\u0007j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/features/gui/customscoreboard/CustomScoreboardUtils$NumberDisplayFormat;", "", "", "displayName", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getDisplayName", "TEXT_COLOR_NUMBER", "COLOR_TEXT_NUMBER", "COLOR_NUMBER_TEXT", "COLOR_NUMBER_RESET_TEXT", "1.21.7"})
    public static final class NumberDisplayFormat
    extends Enum<NumberDisplayFormat> {
        @NotNull
        private final String displayName;
        public static final /* enum */ NumberDisplayFormat TEXT_COLOR_NUMBER = new NumberDisplayFormat("\u00a7fPurse: \u00a76123");
        public static final /* enum */ NumberDisplayFormat COLOR_TEXT_NUMBER = new NumberDisplayFormat("\u00a76Purse: 123");
        public static final /* enum */ NumberDisplayFormat COLOR_NUMBER_TEXT = new NumberDisplayFormat("\u00a76123 Purse");
        public static final /* enum */ NumberDisplayFormat COLOR_NUMBER_RESET_TEXT = new NumberDisplayFormat("\u00a76123 \u00a7fPurse");
        private static final /* synthetic */ NumberDisplayFormat[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private NumberDisplayFormat(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public String toString() {
            return this.displayName;
        }

        public static NumberDisplayFormat[] values() {
            return (NumberDisplayFormat[])$VALUES.clone();
        }

        public static NumberDisplayFormat valueOf(String value) {
            return Enum.valueOf(NumberDisplayFormat.class, value);
        }

        @NotNull
        public static EnumEntries<NumberDisplayFormat> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = numberDisplayFormatArray = new NumberDisplayFormat[]{NumberDisplayFormat.TEXT_COLOR_NUMBER, NumberDisplayFormat.COLOR_TEXT_NUMBER, NumberDisplayFormat.COLOR_NUMBER_TEXT, NumberDisplayFormat.COLOR_NUMBER_RESET_TEXT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[NumberDisplayFormat.values().length];
            try {
                nArray[NumberDisplayFormat.TEXT_COLOR_NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NumberDisplayFormat.COLOR_TEXT_NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NumberDisplayFormat.COLOR_NUMBER_TEXT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NumberDisplayFormat.COLOR_NUMBER_RESET_TEXT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DisplayConfig.NumberFormat.values().length];
            try {
                nArray[DisplayConfig.NumberFormat.SHORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayConfig.NumberFormat.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

