/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.navigation;

import at.hannibal2.skyhanni.data.model.DijkstraTree;
import at.hannibal2.skyhanni.data.model.GraphNode;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.GraphUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ3\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\fJ5\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f0\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012JE\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f0\u000f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J5\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f0\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0012J)\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J5\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f0\u000fH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ+\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ=\u0010!\u001a\u00020 2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f0\u000fH\u0002\u00a2\u0006\u0004\b!\u0010\"JM\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f0\u000f2\b\b\u0002\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/utils/navigation/NavigationUtils;", "", "<init>", "()V", "", "Lat/hannibal2/skyhanni/data/model/GraphNode;", "input", "", "maxIterations", "neighborhoodSize", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getRoute", "(Ljava/util/List;II)Ljava/util/List;", "targetNodes", "calculateTravelingSalesman", "", "", "computeDistanceMap", "(Ljava/util/List;)Ljava/util/Map;", "distanceMap", "", "improvedTSP", "(Ljava/util/Map;II)Ljava/util/List;", "computeDistanceMapOptimized", "computeClusters", "(Ljava/util/List;)Ljava/util/List;", "greedyTSP", "(Ljava/util/Map;)Ljava/util/List;", "route", "currentLocation", "adjustRouteForCurrentLocation", "(Ljava/util/List;Lat/hannibal2/skyhanni/utils/LorenzVec;)Ljava/util/List;", "", "optimizeCriticalSegments", "(Ljava/util/List;Ljava/util/Map;)V", "threeOpt", "(Ljava/util/List;Ljava/util/Map;I)Ljava/util/List;", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nNavigationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationUtils.kt\nat/hannibal2/skyhanni/utils/navigation/NavigationUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,287:1\n1563#2:288\n1634#2,3:289\n1869#2,2:292\n774#2:296\n865#2,2:297\n1617#2,9:299\n1869#2:308\n1870#2:310\n1626#2:311\n2423#2,14:312\n1563#2:326\n1634#2,3:327\n774#2:330\n865#2,2:331\n1068#2:333\n1285#2,2:334\n1299#2,4:336\n216#3,2:294\n1#4:309\n*S KotlinDebug\n*F\n+ 1 NavigationUtils.kt\nat/hannibal2/skyhanni/utils/navigation/NavigationUtils\n*L\n48#1:288\n48#1:289,3\n101#1:292,2\n177#1:296\n177#1:297,2\n179#1:299,9\n179#1:308\n179#1:310\n179#1:311\n200#1:312,14\n219#1:326\n219#1:327,3\n222#1:330\n222#1:331,2\n224#1:333\n104#1:334,2\n104#1:336,4\n169#1:294,2\n179#1:309\n*E\n"})
public final class NavigationUtils {
    @NotNull
    public static final NavigationUtils INSTANCE = new NavigationUtils();

    private NavigationUtils() {
    }

    @NotNull
    public final List<LorenzVec> getRoute(@NotNull List<GraphNode> input2, int maxIterations, int neighborhoodSize) {
        Intrinsics.checkNotNullParameter(input2, (String)"input");
        if (input2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<LorenzVec> output = this.calculateTravelingSalesman(input2, maxIterations, neighborhoodSize);
        if (input2.size() != output.size()) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"input", (Object)input2.size()), TuplesKt.to((Object)"output", (Object)output.size()), TuplesKt.to((Object)"island", (Object)((Object)SkyBlockUtils.INSTANCE.getCurrentIsland()))};
            ErrorManager.INSTANCE.skyHanniError("calculateTravelingSalesman could not reach all goals", pairArray);
            throw new KotlinNothingValueException();
        }
        return output;
    }

    public static /* synthetic */ List getRoute$default(NavigationUtils navigationUtils, List list, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 50;
        }
        if ((n3 & 4) != 0) {
            n2 = 6;
        }
        return navigationUtils.getRoute(list, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LorenzVec> calculateTravelingSalesman(List<GraphNode> targetNodes, int maxIterations, int neighborhoodSize) {
        void $this$mapTo$iv$iv;
        Map<GraphNode, Map<GraphNode, Double>> distanceMap = this.computeDistanceMap(targetNodes);
        List<GraphNode> tspRoute = this.improvedTSP(distanceMap, maxIterations, neighborhoodSize);
        this.optimizeCriticalSegments(tspRoute, distanceMap);
        Map<GraphNode, Map<GraphNode, Double>> optimizedDistanceMap = this.computeDistanceMapOptimized(tspRoute);
        tspRoute = this.improvedTSP(optimizedDistanceMap, maxIterations, neighborhoodSize);
        tspRoute = this.threeOpt(tspRoute, optimizedDistanceMap, maxIterations);
        LorenzVec currentPosition = LocationUtils.INSTANCE.playerLocation();
        List<GraphNode> adjustedRoute = this.adjustRouteForCurrentLocation(tspRoute, currentPosition);
        Iterable $this$map$iv = adjustedRoute;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GraphNode graphNode = (GraphNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPosition());
        }
        return (List)destination$iv$iv;
    }

    private final Map<GraphNode, Map<GraphNode, Double>> computeDistanceMap(List<GraphNode> targetNodes) {
        Map distanceMap = new LinkedHashMap();
        for (GraphNode node : targetNodes) {
            DijkstraTree dijkstraTree = GraphUtils.findAllShortestDistances$default(GraphUtils.INSTANCE, node, null, 2, null);
            Map nodeDistances = new LinkedHashMap();
            for (GraphNode target : targetNodes) {
                Map map = nodeDistances;
                Double d = dijkstraTree.getDistances().get(target);
                Double d2 = d != null ? d : Double.POSITIVE_INFINITY;
                map.put(target, d2);
            }
            distanceMap.put(node, nodeDistances);
        }
        return distanceMap;
    }

    private final List<GraphNode> improvedTSP(Map<GraphNode, ? extends Map<GraphNode, Double>> distanceMap, int maxIterations, int neighborhoodSize) {
        List route = CollectionsKt.toMutableList((Collection)this.greedyTSP(distanceMap));
        boolean improved = true;
        block0: for (int iteration = 0; improved && iteration < maxIterations; ++iteration) {
            improved = false;
            int n = route.size() - 1;
            for (int i2 = 1; i2 < n; ++i2) {
                int jMax = RangesKt.coerceAtMost((int)(i2 + neighborhoodSize), (int)route.size());
                for (int j = i2 + 1; j < jMax; ++j) {
                    Object object;
                    Object object2;
                    Map<GraphNode, Double> map = distanceMap.get(route.get(i2 - 1));
                    double costCurrent = (map != null && (map = map.get(route.get(i2))) != null ? (Double)((Object)map) : Double.POSITIVE_INFINITY) + ((object2 = distanceMap.get(route.get(j - 1))) != null && (object2 = object2.get(route.get(j))) != null ? (Double)object2 : Double.POSITIVE_INFINITY);
                    Map<GraphNode, Double> map2 = distanceMap.get(route.get(i2 - 1));
                    double costNew = (map2 != null && (map2 = map2.get(route.get(j))) != null ? (Double)((Object)map2) : Double.POSITIVE_INFINITY) + ((object = distanceMap.get(route.get(j - 1))) != null && (object = object.get(route.get(i2))) != null ? (Double)object : Double.POSITIVE_INFINITY);
                    if (!(costNew < costCurrent)) continue;
                    CollectionsKt.reverse(route.subList(i2, j));
                    improved = true;
                    break;
                }
                if (improved) continue block0;
            }
        }
        return route;
    }

    private final Map<GraphNode, Map<GraphNode, Double>> computeDistanceMapOptimized(List<GraphNode> targetNodes) {
        List<List<GraphNode>> clusters = this.computeClusters(targetNodes);
        Map result2 = new LinkedHashMap();
        Iterable $this$forEach$iv = clusters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List cluster = (List)element$iv;
            boolean bl = false;
            cluster.parallelStream().forEach(arg_0 -> NavigationUtils.computeDistanceMapOptimized$lambda$4$lambda$3(arg_0 -> NavigationUtils.computeDistanceMapOptimized$lambda$4$lambda$2(result2, cluster, arg_0), arg_0));
        }
        int n = ((Collection)clusters).size();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = clusters.size();
            for (int j = i2 + 1; j < n2; ++j) {
                double distance;
                List<GraphNode> clusterA = clusters.get(i2);
                List<GraphNode> clusterB = clusters.get(j);
                for (GraphNode nodeA : clusterA) {
                    DijkstraTree dijkstraTreeA = GraphUtils.findAllShortestDistances$default(GraphUtils.INSTANCE, nodeA, null, 2, null);
                    for (GraphNode nodeB : clusterB) {
                        Double d = dijkstraTreeA.getDistances().get(nodeB);
                        distance = d != null ? d : Double.POSITIVE_INFINITY;
                        Map map = (Map)result2.get(nodeA);
                        if (map == null) continue;
                        map.put(nodeB, distance);
                    }
                }
                for (GraphNode nodeB : clusterB) {
                    DijkstraTree dijkstraTreeB = GraphUtils.findAllShortestDistances$default(GraphUtils.INSTANCE, nodeB, null, 2, null);
                    for (GraphNode nodeA : clusterA) {
                        Double d = dijkstraTreeB.getDistances().get(nodeA);
                        distance = d != null ? d : Double.POSITIVE_INFINITY;
                        Map map = (Map)result2.get(nodeB);
                        if (map == null) continue;
                        map.put(nodeA, distance);
                    }
                }
            }
        }
        return result2;
    }

    private final List<List<GraphNode>> computeClusters(List<GraphNode> targetNodes) {
        List clusters = new ArrayList();
        Set visited = new LinkedHashSet();
        for (GraphNode node : targetNodes) {
            if (visited.contains(node)) continue;
            List cluster = new ArrayList();
            NavigationUtils.computeClusters$dfs(visited, targetNodes, node, cluster);
            clusters.add(cluster);
        }
        return clusters;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GraphNode> greedyTSP(Map<GraphNode, ? extends Map<GraphNode, Double>> distanceMap) {
        GraphNode startNode = (GraphNode)CollectionsKt.first((Iterable)distanceMap.keySet());
        Object[] objectArray = new GraphNode[]{startNode};
        List route = CollectionsKt.mutableListOf((Object[])objectArray);
        Object[] objectArray2 = new GraphNode[]{startNode};
        Set visited = SetsKt.mutableSetOf((Object[])objectArray2);
        GraphNode current = null;
        current = startNode;
        while (visited.size() < distanceMap.size()) {
            GraphNode it;
            Object object;
            GraphNode nextNode = null;
            double bestDistance = 0.0;
            bestDistance = Double.POSITIVE_INFINITY;
            if (distanceMap.get(current) != null) {
                Map<GraphNode, Double> $this$forEach$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<GraphNode, Double> element$iv;
                    Map.Entry<GraphNode, Double> entry = element$iv = object.next();
                    boolean bl = false;
                    GraphNode candidate = entry.getKey();
                    double distance = ((Number)entry.getValue()).doubleValue();
                    if (visited.contains(candidate) || !(distance < bestDistance)) continue;
                    bestDistance = distance;
                    nextNode = candidate;
                }
            }
            if (nextNode == null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = distanceMap.keySet();
                boolean $i$f$filter = false;
                object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GraphNode it2 = (GraphNode)element$iv$iv;
                    boolean bl = false;
                    if (!(!visited.contains(it2))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (GraphNode candidate : (List)destination$iv$iv) {
                    void $this$mapNotNullTo$iv$iv;
                    Object element$iv$iv;
                    Iterable $this$mapNotNull$iv = visited;
                    boolean $i$f$mapNotNull = false;
                    element$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Double it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        GraphNode it3 = (GraphNode)element$iv$iv2;
                        boolean bl2 = false;
                        Map<GraphNode, Double> map = distanceMap.get(it3);
                        if ((map != null ? map.get(candidate) : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    Double d = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv2));
                    double d2 = d != null ? d : Double.POSITIVE_INFINITY;
                    double candidateMinDistance = d2;
                    if (!(candidateMinDistance < bestDistance)) continue;
                    bestDistance = candidateMinDistance;
                    nextNode = candidate;
                }
            }
            if (nextNode == null) break;
            boolean bl = false;
            route.add(it);
            visited.add(it);
            current = it;
        }
        return route;
    }

    private final List<GraphNode> adjustRouteForCurrentLocation(List<GraphNode> route, LorenzVec currentLocation) {
        GraphNode graphNode;
        Object v0;
        Iterable $this$minByOrNull$iv = route;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                GraphNode it = (GraphNode)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getPosition().distanceSq(currentLocation);
                do {
                    Object e$iv = iterator$iv.next();
                    GraphNode it2 = (GraphNode)e$iv;
                    $i$a$-minByOrNull-NavigationUtils$adjustRouteForCurrentLocation$closestNode$1 = false;
                    double v$iv = it2.getPosition().distanceSq(currentLocation);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        if ((graphNode = (GraphNode)v0) == null) {
            graphNode = (GraphNode)CollectionsKt.first(route);
        }
        GraphNode closestNode = graphNode;
        int idx = route.indexOf(closestNode);
        return CollectionsKt.plus((Collection)CollectionsKt.drop((Iterable)route, (int)idx), (Iterable)CollectionsKt.take((Iterable)route, (int)idx));
    }

    /*
     * WARNING - void declaration
     */
    private final void optimizeCriticalSegments(List<GraphNode> route, Map<GraphNode, ? extends Map<GraphNode, Double>> distanceMap) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        if (route.size() < 2) {
            return;
        }
        List edgeCosts = new ArrayList();
        int n = route.size() - 1;
        for (int i2 = 0; i2 < n; ++i2) {
            Map<GraphNode, Double> map = distanceMap.get(route.get(i2));
            double cost = map != null && (map = map.get(route.get(i2 + 1))) != null ? (Double)((Object)map) : Double.POSITIVE_INFINITY;
            edgeCosts.add(new Pair((Object)i2, (Object)cost));
        }
        Map<GraphNode, Double> map = distanceMap.get(CollectionsKt.last(route));
        double cycleCost = map != null && (map = map.get(CollectionsKt.first(route))) != null ? (Double)((Object)map) : Double.POSITIVE_INFINITY;
        edgeCosts.add(new Pair((Object)(route.size() - 1), (Object)cycleCost));
        Iterable $this$map$iv = edgeCosts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getSecond()).doubleValue());
        }
        double averageCost = CollectionsKt.averageOfDouble((Iterable)((List)destination$iv$iv));
        double threshold = 1.2 * averageCost;
        Iterable $this$filter$iv = edgeCosts;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).doubleValue() > threshold)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List criticalEdges = (List)destination$iv$iv2;
        if (!((Collection)criticalEdges).isEmpty()) {
            Iterable $this$sortedByDescending$iv = criticalEdges;
            boolean $i$f$sortedByDescending = false;
            List sortedCritical = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getSecond();
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
                }
            });
            Iterator iterator2 = sortedCritical.iterator();
            while (iterator2.hasNext()) {
                int index = ((Number)((Pair)iterator2.next()).component1()).intValue();
                if (index >= route.size() - 1 || index <= 0) continue;
                int n2 = route.size();
                for (int j = index + 2; j < n2; ++j) {
                    Object object;
                    Object object2;
                    if (j - index < 2) continue;
                    Map<GraphNode, Double> map2 = distanceMap.get(route.get(index));
                    double costBefore = (map2 != null && (map2 = map2.get(route.get(index + 1))) != null ? (Double)((Object)map2) : Double.POSITIVE_INFINITY) + ((object2 = distanceMap.get(route.get(j - 1))) != null && (object2 = object2.get(route.get(j))) != null ? (Double)object2 : Double.POSITIVE_INFINITY);
                    Map<GraphNode, Double> map3 = distanceMap.get(route.get(index));
                    double costAfter = (map3 != null && (map3 = map3.get(route.get(j - 1))) != null ? (Double)((Object)map3) : Double.POSITIVE_INFINITY) + ((object = distanceMap.get(route.get(index + 1))) != null && (object = object.get(route.get(j))) != null ? (Double)object : Double.POSITIVE_INFINITY);
                    if (!(costAfter < costBefore)) continue;
                    CollectionsKt.reverse(route.subList(index + 1, j));
                }
            }
        }
    }

    private final List<GraphNode> threeOpt(List<GraphNode> route, Map<GraphNode, ? extends Map<GraphNode, Double>> distanceMap, int maxIterations) {
        boolean improved = true;
        int n = route.size();
        for (int iteration = 0; improved && iteration < maxIterations; ++iteration) {
            improved = false;
            int n2 = n - 2;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = n - 1;
                for (int j = i2 + 1; j < n3; ++j) {
                    for (int k = j + 1; k < n; ++k) {
                        Object object;
                        double costDF;
                        Object object2;
                        double costBE;
                        GraphNode a = route.get(i2);
                        GraphNode b = route.get(i2 + 1);
                        GraphNode c = route.get(j);
                        GraphNode d = route.get(j + 1);
                        GraphNode e = route.get(k);
                        GraphNode f = route.get((k + 1) % n);
                        Map<GraphNode, Double> map = distanceMap.get(a);
                        double costAB = map != null && (map = map.get(b)) != null ? (Double)((Object)map) : Double.POSITIVE_INFINITY;
                        Map<GraphNode, Double> map2 = distanceMap.get(c);
                        double costCD = map2 != null && (map2 = map2.get(d)) != null ? (Double)((Object)map2) : Double.POSITIVE_INFINITY;
                        Map<GraphNode, Double> map3 = distanceMap.get(e);
                        double costEF = map3 != null && (map3 = map3.get(f)) != null ? (Double)((Object)map3) : Double.POSITIVE_INFINITY;
                        double currentCost = costAB + costCD + costEF;
                        Map<GraphNode, Double> map4 = distanceMap.get(a);
                        double costAC = map4 != null && (map4 = map4.get(c)) != null ? (Double)((Object)map4) : Double.POSITIVE_INFINITY;
                        double newCost = costAC + (costBE = (object2 = distanceMap.get(b)) != null && (object2 = object2.get(e)) != null ? (Double)object2 : Double.POSITIVE_INFINITY) + (costDF = (object = distanceMap.get(d)) != null && (object = object.get(f)) != null ? (Double)object : Double.POSITIVE_INFINITY);
                        if (!(newCost < currentCost)) continue;
                        CollectionsKt.reverse(route.subList(i2 + 1, j + 1));
                        CollectionsKt.reverse(route.subList(j + 1, k + 1));
                        improved = true;
                    }
                }
            }
        }
        return route;
    }

    static /* synthetic */ List threeOpt$default(NavigationUtils navigationUtils, List list, Map map, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 50;
        }
        return navigationUtils.threeOpt(list, map, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit computeDistanceMapOptimized$lambda$4$lambda$2(Map $result, List $cluster, GraphNode node) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$cluster, (String)"$cluster");
        Intrinsics.checkNotNull((Object)node);
        DijkstraTree dijkstraTree = GraphUtils.findAllShortestDistances$default(GraphUtils.INSTANCE, node, null, 2, null);
        Map map = $result;
        Iterable $this$associateWith$iv = $cluster;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void target;
            GraphNode graphNode = (GraphNode)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Double d = dijkstraTree.getDistances().get(target);
            Double d2 = d != null ? d : Double.POSITIVE_INFINITY;
            map2.put(t, d2);
        }
        Map map3 = MapsKt.toMutableMap((Map)result$iv);
        map.put(node, map3);
        return Unit.INSTANCE;
    }

    private static final void computeDistanceMapOptimized$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void computeClusters$dfs(Set<GraphNode> visited, List<GraphNode> $targetNodes, GraphNode node, List<GraphNode> cluster) {
        visited.add(node);
        cluster.add(node);
        for (Map.Entry<GraphNode, Double> neighbor : node.getNeighbours().entrySet()) {
            if (!$targetNodes.contains(neighbor.getKey()) || visited.contains(neighbor.getKey())) continue;
            NavigationUtils.computeClusters$dfs(visited, $targetNodes, neighbor.getKey(), cluster);
        }
    }
}

