/*
 * Decompiled with CFR 0.152.
 */
package dev.cbyrne.kdiscordipc.core.socket.impl;

import dev.cbyrne.kdiscordipc.core.socket.RawPacket;
import dev.cbyrne.kdiscordipc.core.socket.Socket;
import dev.cbyrne.kdiscordipc.core.util.IntegerKt;
import java.io.File;
import java.io.RandomAccessFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ldev/cbyrne/kdiscordipc/core/socket/impl/WindowsSocket;", "Ldev/cbyrne/kdiscordipc/core/socket/Socket;", "<init>", "()V", "", "close", "Ljava/io/File;", "file", "connect", "(Ljava/io/File;)V", "Ldev/cbyrne/kdiscordipc/core/socket/RawPacket;", "read", "()Ldev/cbyrne/kdiscordipc/core/socket/RawPacket;", "", "bytes", "write", "([B)V", "", "_connected", "Z", "getConnected", "()Z", "connected", "Ljava/io/RandomAccessFile;", "randomAccessFile", "Ljava/io/RandomAccessFile;", "KDiscordIPC"})
public final class WindowsSocket
implements Socket {
    private RandomAccessFile randomAccessFile;
    private boolean _connected;

    @Override
    public boolean getConnected() {
        return this._connected;
    }

    @Override
    public void connect(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        this._connected = true;
    }

    @Override
    public void close() {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        if (randomAccessFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"randomAccessFile");
            randomAccessFile = null;
        }
        randomAccessFile.close();
        this._connected = false;
    }

    @Override
    @NotNull
    public RawPacket read() {
        RandomAccessFile randomAccessFile;
        while (this._connected) {
            RandomAccessFile randomAccessFile2 = this.randomAccessFile;
            if (randomAccessFile2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"randomAccessFile");
                randomAccessFile2 = null;
            }
            if (randomAccessFile2.length() != 0L) break;
            Thread.sleep(50L);
        }
        if ((randomAccessFile = this.randomAccessFile) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"randomAccessFile");
            randomAccessFile = null;
        }
        int opcode = IntegerKt.reverse(randomAccessFile.readInt());
        RandomAccessFile randomAccessFile3 = this.randomAccessFile;
        if (randomAccessFile3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"randomAccessFile");
            randomAccessFile3 = null;
        }
        int length = IntegerKt.reverse(randomAccessFile3.readInt());
        byte[] data = new byte[length];
        RandomAccessFile randomAccessFile4 = this.randomAccessFile;
        if (randomAccessFile4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"randomAccessFile");
            randomAccessFile4 = null;
        }
        randomAccessFile4.readFully(data);
        return new RawPacket(opcode, length, data);
    }

    @Override
    public void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        if (randomAccessFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"randomAccessFile");
            randomAccessFile = null;
        }
        randomAccessFile.write(bytes);
    }
}

