/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument;

import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.search.argument.Argument;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AlternativeArgument
extends ForwardingList<Argument<?, ?>> {
    static final AlternativeArgument EMPTY = new AlternativeArgument(Collections.emptyList());
    private final List<Argument<?, ?>> arguments;

    public AlternativeArgument(List<Argument<?, ?>> arguments) {
        this.arguments = arguments;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected List<Argument<?, ?>> delegate() {
        return this.arguments;
    }

    public static class Builder {
        private List<Argument.Builder<?, ?>> arguments;

        public <T, R> Builder add(Argument.Builder<T, R> argument) {
            if (this.arguments == null) {
                this.arguments = new ArrayList();
            }
            this.arguments.add(argument);
            return this;
        }

        public boolean isEmpty() {
            return this.arguments == null;
        }

        public AlternativeArgument build() {
            if (this.arguments == null) {
                return EMPTY;
            }
            if (this.arguments.size() == 1) {
                return new AlternativeArgument(List.of(this.arguments.get(0).build()));
            }
            return new AlternativeArgument(CollectionUtils.map(this.arguments, Argument.Builder::build));
        }
    }
}

