/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.settings;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.settings.EntrySettingsAdapter;
import me.shedaniel.rei.api.common.entry.settings.EntrySettingsAdapterRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import org.jetbrains.annotations.Nullable;

public class EntrySettingsAdapterRegistryImpl
implements EntrySettingsAdapterRegistry {
    private final Map<EntryStack.Settings<?>, Multimap<EntryType<?>, EntrySettingsAdapter<?, ?>>> providers = new HashMap();

    @Override
    public <T, S> void register(EntryType<T> type, EntryStack.Settings<S> settings, EntrySettingsAdapter<T, S> provider) {
        Multimap multimap = this.providers.computeIfAbsent(settings, $ -> Multimaps.newMultimap((Map)new Reference2ObjectOpenHashMap(), ArrayList::new));
        multimap.put(type, provider);
    }

    @Override
    @Nullable
    public <T, S> S adapt(EntryStack<T> stack, EntryStack.Settings<S> settings, @Nullable S value) {
        Multimap<EntryType<?>, EntrySettingsAdapter<?, ?>> multimap = this.providers.get(settings);
        if (multimap != null) {
            for (EntrySettingsAdapter adapter : multimap.get(stack.getType())) {
                value = adapter.provide(stack, settings, value);
            }
        }
        return value;
    }

    @Override
    public void startReload() {
        this.providers.clear();
    }

    @Override
    public void acceptPlugin(REICommonPlugin plugin) {
        plugin.registerEntrySettingsAdapters(this);
    }
}

