/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class MapExtendingCraftingDisplay
extends DefaultCraftingDisplay {
    public static final DisplaySerializer<MapExtendingCraftingDisplay> SERIALIZER = DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("i").forGetter(d -> d.i), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation)).apply((Applicative)instance, MapExtendingCraftingDisplay::new)), class_9139.method_56435((class_9139)class_9135.field_49675, d -> d.i, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), BasicDisplay::getDisplayLocation, MapExtendingCraftingDisplay::new));
    private final int i;

    public MapExtendingCraftingDisplay(int i, Optional<class_2960> id) {
        super(MapExtendingCraftingDisplay.getInputs(i), List.of(MapExtendingCraftingDisplay.mapWith("X", i + 1, 1)), id);
        this.i = i;
    }

    private static List<EntryIngredient> getInputs(int i) {
        EntryIngredient[] inputs = new EntryIngredient[9];
        for (int j = 0; j < 9; ++j) {
            inputs[j] = j == 4 ? MapExtendingCraftingDisplay.mapWith("X", i, 1) : EntryIngredients.of((class_1935)class_1802.field_8407);
        }
        return List.of(inputs);
    }

    @Override
    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public static EntryIngredient mapWith(String mapId, int scale, int count) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            return MapExtendingCraftingDisplay.mapWithClient(mapId, scale, count);
        }
        return EntryIngredients.of((class_1935)class_1802.field_8204, count);
    }

    @Environment(value=EnvType.CLIENT)
    public static EntryIngredient mapWithClient(String mapId, int scale, int count) {
        EntryIngredient stacks = EntryIngredients.of((class_1935)class_1802.field_8204, count);
        String unknown = class_1074.method_4662((String)"filled_map.unknown", (Object[])new Object[0]);
        for (EntryStack stack : stacks) {
            stack.tooltipProcessor(($, tooltip) -> {
                tooltip.entries().removeIf(entry -> entry.isText() && entry.getAsText().getString().equals(unknown));
                return tooltip;
            });
            stack.tooltip(new class_2561[]{class_2561.method_43469((String)"filled_map.id", (Object[])new Object[]{mapId}).method_27692(class_124.field_1080), class_2561.method_43469((String)"filled_map.scale", (Object[])new Object[]{1 << scale}).method_27692(class_124.field_1080), class_2561.method_43469((String)"filled_map.level", (Object[])new Object[]{scale, 4}).method_27692(class_124.field_1080)});
        }
        return stacks;
    }

    @Override
    public boolean isShapeless() {
        return false;
    }

    @Override
    public int getWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return 3;
    }
}

