/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.data;

import gg.essential.vigilance.data.CategoryItem;
import gg.essential.vigilance.data.PropertyData;
import gg.essential.vigilance.data.PropertyInfo;
import gg.essential.vigilance.data.PropertyType;
import gg.essential.vigilance.gui.DataBackedSetting;
import gg.essential.vigilance.gui.Setting;
import gg.essential.vigilance.gui.settings.ButtonComponent;
import gg.essential.vigilance.gui.settings.CheckboxComponent;
import gg.essential.vigilance.gui.settings.ColorComponent;
import gg.essential.vigilance.gui.settings.DecimalSliderComponent;
import gg.essential.vigilance.gui.settings.NumberComponent;
import gg.essential.vigilance.gui.settings.PercentSliderComponent;
import gg.essential.vigilance.gui.settings.SelectorComponent;
import gg.essential.vigilance.gui.settings.SettingComponent;
import gg.essential.vigilance.gui.settings.SliderComponent;
import gg.essential.vigilance.gui.settings.SwitchComponent;
import gg.essential.vigilance.gui.settings.TextComponent;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lgg/essential/vigilance/data/PropertyItem;", "Lgg/essential/vigilance/data/CategoryItem;", "data", "Lgg/essential/vigilance/data/PropertyData;", "subcategory", "", "(Lgg/essential/vigilance/data/PropertyData;Ljava/lang/String;)V", "getData", "()Lgg/essential/vigilance/data/PropertyData;", "getSubcategory", "()Ljava/lang/String;", "toSettingsObject", "Lgg/essential/vigilance/gui/Setting;", "toString", "Vigilance"})
@SourceDebugExtension(value={"SMAP\nCategories.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Categories.kt\ngg/essential/vigilance/data/PropertyItem\n+ 2 PropertyData.kt\ngg/essential/vigilance/data/PropertyData\n*L\n1#1,76:1\n27#2:77\n27#2:78\n27#2:79\n27#2:80\n27#2:81\n27#2:82\n27#2:83\n27#2:84\n27#2:85\n*S KotlinDebug\n*F\n+ 1 Categories.kt\ngg/essential/vigilance/data/PropertyItem\n*L\n31#1:77\n32#1:78\n34#1:79\n40#1:80\n45#1:81\n46#1:82\n48#1:83\n54#1:84\n65#1:85\n*E\n"})
public final class PropertyItem
extends CategoryItem {
    @NotNull
    private final PropertyData data;
    @NotNull
    private final String subcategory;

    public PropertyItem(@NotNull PropertyData data, @NotNull String subcategory) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)subcategory, (String)"subcategory");
        super(null);
        this.data = data;
        this.subcategory = subcategory;
    }

    @NotNull
    public final PropertyData getData() {
        return this.data;
    }

    @NotNull
    public final String getSubcategory() {
        return this.subcategory;
    }

    @Override
    @NotNull
    public Setting toSettingsObject() {
        SettingComponent settingComponent;
        switch (WhenMappings.$EnumSwitchMapping$0[this.data.getDataType().ordinal()]) {
            case 1: {
                settingComponent = new SwitchComponent(this.data.getAsBoolean());
                break;
            }
            case 2: {
                settingComponent = new CheckboxComponent(this.data.getAsBoolean());
                break;
            }
            case 3: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                settingComponent = new PercentSliderComponent(((Number)((Float)object)).floatValue());
                break;
            }
            case 4: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                settingComponent = new SliderComponent(((Number)((Integer)object)).intValue(), this.data.getAttributesExt().getMin(), this.data.getAttributesExt().getMax());
                break;
            }
            case 5: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                settingComponent = new DecimalSliderComponent(((Number)((Float)object)).floatValue(), this.data.getAttributesExt().getMinF(), this.data.getAttributesExt().getMaxF(), this.data.getAttributesExt().getDecimalPlaces());
                break;
            }
            case 6: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                settingComponent = new NumberComponent(((Number)((Integer)object)).intValue(), this.data.getAttributesExt().getMin(), this.data.getAttributesExt().getMax(), this.data.getAttributesExt().getIncrement());
                break;
            }
            case 7: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                settingComponent = new SelectorComponent(((Number)((Integer)object)).intValue(), CollectionsKt.toList((Iterable)this.data.getAttributesExt().getOptions()));
                break;
            }
            case 8: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.awt.Color");
                }
                settingComponent = new ColorComponent((Color)object, this.data.getAttributesExt().getAllowAlpha());
                break;
            }
            case 9: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                settingComponent = new TextComponent((String)object, this.data.getAttributesExt().getPlaceholder(), false, this.data.getAttributesExt().getProtected());
                break;
            }
            case 10: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                settingComponent = new TextComponent((String)object, this.data.getAttributesExt().getPlaceholder(), true, false);
                break;
            }
            case 11: {
                settingComponent = new ButtonComponent(this.data.getAttributesExt().getPlaceholder(), this.data);
                break;
            }
            case 12: {
                Class<? extends PropertyInfo> propertyInfoClass = this.data.getAttributesExt().getCustomPropertyInfo();
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                settingComponent = propertyInfoClass.getConstructor(new Class[0]).newInstance(new Object[0]).createSettingComponent(this_$iv.getValue().getValue(this_$iv.getInstance()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        SettingComponent component = settingComponent;
        return new DataBackedSetting(this.data, component);
    }

    @NotNull
    public String toString() {
        return (Object)((Object)this.data.getAttributesExt().getType()) + " \"" + this.data.getAttributesExt().getName() + '\"';
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PropertyType.values().length];
            try {
                nArray[PropertyType.SWITCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.CHECKBOX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.PERCENT_SLIDER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.SLIDER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DECIMAL_SLIDER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.NUMBER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.SELECTOR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.COLOR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.TEXT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.PARAGRAPH.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.BUTTON.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.CUSTOM.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

