/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.moulconfig.gui;

import java.util.List;
import java.util.Locale;
import moe.nea.firmament.deps.moulconfig.DescriptionRendereringBehaviour;
import moe.nea.firmament.deps.moulconfig.TitleRenderingBehaviour;
import moe.nea.firmament.deps.moulconfig.annotations.SearchTag;
import moe.nea.firmament.deps.moulconfig.common.IFontRenderer;
import moe.nea.firmament.deps.moulconfig.common.IMinecraft;
import moe.nea.firmament.deps.moulconfig.common.RenderContext;
import moe.nea.firmament.deps.moulconfig.common.text.StructuredText;
import moe.nea.firmament.deps.moulconfig.gui.GuiContext;
import moe.nea.firmament.deps.moulconfig.gui.KeyboardEvent;
import moe.nea.firmament.deps.moulconfig.gui.MoulConfigEditor;
import moe.nea.firmament.deps.moulconfig.gui.MouseEvent;
import moe.nea.firmament.deps.moulconfig.processor.HasDebugLocation;
import moe.nea.firmament.deps.moulconfig.processor.ProcessedOption;
import org.jetbrains.annotations.ApiStatus;

public abstract class GuiOptionEditor
implements HasDebugLocation {
    private static final int HEIGHT = 45;
    protected final ProcessedOption option;
    public MoulConfigEditor<?> activeConfigGUI;
    private String searchDescNameCache;
    private String searchTags = "";

    @Override
    public String getDebugDeclarationLocation() {
        return this.option != null ? this.option.getDebugDeclarationLocation() : null;
    }

    @ApiStatus.Internal
    public ProcessedOption getOption() {
        return this.option;
    }

    public GuiOptionEditor(ProcessedOption option) {
        this.option = option;
        for (SearchTag searchTag : option.getSearchTags()) {
            if (!this.searchTags.isEmpty()) {
                this.searchTags = this.searchTags + " ";
            }
            this.searchTags = this.searchTags + searchTag;
        }
    }

    public void render(RenderContext context, int x, int y, int width) {
        List<StructuredText> lines;
        int descriptionHeight;
        int height = this.getHeight();
        IMinecraft minecraft = context.getMinecraft();
        IFontRenderer fr = minecraft.getDefaultFontRenderer();
        boolean wideTitle = this.option.getConfig().getTitleRenderingBehaviour(this.option) != TitleRenderingBehaviour.LEFT;
        int yOffset = wideTitle ? fr.getHeight() + 1 : 5;
        context.drawDarkRect(x, y, width, height, true);
        if (wideTitle) {
            context.drawStringCenteredScaledMaxWidth(this.option.getName(), fr, x + width / 2, y + 13, true, width - 10, 0xE0E0E0);
        } else {
            context.drawStringCenteredScaledMaxWidth(this.option.getName(), fr, x + width / 6, y + 13, true, width / 3 - 10, 0xE0E0E0);
        }
        float scale = 1.0f;
        int n = descriptionHeight = this.option.getConfig().getDescriptionBehaviour(this.option) != DescriptionRendereringBehaviour.EXPAND_PANEL ? 45 : this.getHeight();
        while (!((float)(lines = fr.splitText(this.option.getDescription(), (int)((float)(width * 2 / 3) / scale - 10.0f))).size() * scale * (float)(fr.getHeight() + 1) + 10.0f < (float)descriptionHeight) && !((scale -= 0.125f) < 0.0625f)) {
        }
        context.pushMatrix();
        context.translate(x + 5 + width / 3, y + yOffset);
        context.scale(scale, scale);
        context.translate(0.0f, ((float)(descriptionHeight - 10) - (float)((fr.getHeight() + 1) * (lines.size() - 1)) * scale) / 2.0f);
        for (StructuredText line : lines) {
            context.drawString(fr, line, 0, 0, 0xC0C0C0, false);
            context.translate(0.0f, fr.getHeight() + 1);
        }
        context.popMatrix();
    }

    public int getHeight() {
        return this.getDescriptionHeight() + (this.option.getConfig().getTitleRenderingBehaviour(this.option) != TitleRenderingBehaviour.LEFT ? IMinecraft.INSTANCE.getDefaultFontRenderer().getHeight() + 1 : 5);
    }

    public int getDescriptionHeight() {
        if (this.option.getConfig().getDescriptionBehaviour(this.option) != DescriptionRendereringBehaviour.EXPAND_PANEL) {
            return 45;
        }
        IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
        return Math.max(45, fr.splitText(this.option.getDescription(), 156).size() * (fr.getHeight() + 1) + 10);
    }

    @Deprecated
    protected boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        return false;
    }

    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY, MouseEvent mouseEvent) {
        return this.mouseInput(x, y, width, mouseX, mouseY);
    }

    @Deprecated
    protected boolean keyboardInput() {
        return false;
    }

    public boolean keyboardInput(KeyboardEvent event) {
        return this.keyboardInput();
    }

    public boolean mouseInputOverlay(int x, int y, int width, int mouseX, int mouseY, MouseEvent mouseEvent) {
        return false;
    }

    public void renderOverlay(RenderContext renderContext, int x, int y, int width) {
        this.renderOverlay(x, y, width);
    }

    @Deprecated
    public void renderOverlay(int x, int y, int width) {
    }

    public boolean fulfillsSearch(String word) {
        if (this.searchDescNameCache == null) {
            this.searchDescNameCache = (this.option.getName().getText() + this.option.getDescription().getText() + this.searchTags).toLowerCase(Locale.ROOT);
        }
        return this.searchDescNameCache.contains(word);
    }

    public void setGuiContext(GuiContext guiContext) {
    }
}

