/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.repo;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import moe.nea.firmament.deps.repo.IReloadable;
import moe.nea.firmament.deps.repo.NEURepoFile;
import moe.nea.firmament.deps.repo.NEURepository;
import moe.nea.firmament.deps.repo.NEURepositoryException;
import moe.nea.firmament.deps.repo.data.NEUItem;
import moe.nea.firmament.deps.repo.util.NEUId;
import moe.nea.firmament.deps.repo.util.StreamIt;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NEUItems
implements IReloadable {
    Map<@NEUId String, NEUItem> items;

    @Override
    public void reload(NEURepository repository) throws NEURepositoryException {
        HashMap<String, NEUItem> items = new HashMap<String, NEUItem>();
        try (Stream<NEURepoFile> itemSources = repository.tree("items").filter(NEURepoFile::isFile).filter(it -> it.getFsPath().getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".json"));){
            for (NEURepoFile rf : new StreamIt<NEURepoFile>(itemSources)) {
                NEUItem item = rf.json(NEUItem.class);
                items.put(item.getSkyblockItemId(), item);
            }
        }
        this.items = items;
    }

    public @Nullable NEUItem getItemBySkyblockId(@NEUId String itemId) {
        if (this.items == null) {
            return null;
        }
        return this.items.get(itemId.toUpperCase(Locale.ROOT));
    }

    public Map<@NEUId String, NEUItem> getItems() {
        return this.items;
    }
}

