/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.repo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.nea.firmament.deps.repo.IReloadable;
import moe.nea.firmament.deps.repo.NEURepository;
import moe.nea.firmament.deps.repo.NEURepositoryException;
import moe.nea.firmament.deps.repo.data.NEUIngredient;
import moe.nea.firmament.deps.repo.data.NEUItem;
import moe.nea.firmament.deps.repo.data.NEURecipe;
import moe.nea.firmament.deps.repo.util.NEUId;

public class NEURecipeCache
implements IReloadable {
    Map<@NEUId String, Set<NEURecipe>> recipes = new HashMap<String, Set<NEURecipe>>();
    Map<@NEUId String, Set<NEURecipe>> usages = new HashMap<String, Set<NEURecipe>>();

    private NEURecipeCache() {
    }

    public static NEURecipeCache forRepo(NEURepository repository) {
        NEURecipeCache neuRecipeCache = new NEURecipeCache();
        repository.registerReloadListener(neuRecipeCache);
        return neuRecipeCache;
    }

    @Override
    public void reload(NEURepository repository) throws NEURepositoryException {
        HashMap<String, Set<NEURecipe>> recipes = new HashMap<String, Set<NEURecipe>>();
        HashMap<String, Set<NEURecipe>> usages = new HashMap<String, Set<NEURecipe>>();
        for (NEUItem item : repository.getItems().getItems().values()) {
            for (NEURecipe recipe : item.getRecipes()) {
                for (NEUIngredient input : recipe.getAllInputs()) {
                    usages.computeIfAbsent(input.getItemId(), ignored -> new HashSet()).add(recipe);
                }
                for (NEUIngredient output : recipe.getAllOutputs()) {
                    recipes.computeIfAbsent(output.getItemId(), ignored -> new HashSet()).add(recipe);
                }
            }
        }
        this.recipes = recipes;
        this.usages = usages;
    }

    public Map<@NEUId String, Set<NEURecipe>> getRecipes() {
        return this.recipes;
    }

    public Map<@NEUId String, Set<NEURecipe>> getUsages() {
        return this.usages;
    }
}

