/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.features.events.carnival;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import moe.nea.firmament.commands.CaseInsensitiveLiteralCommandNode;
import moe.nea.firmament.commands.DslKt;
import moe.nea.firmament.deps.moulconfig.common.IItemStack;
import moe.nea.firmament.deps.moulconfig.observer.ObservableList;
import moe.nea.firmament.deps.moulconfig.platform.MoulConfigPlatform;
import moe.nea.firmament.deps.moulconfig.xml.Bind;
import moe.nea.firmament.events.AttackBlockEvent;
import moe.nea.firmament.events.CommandEvent;
import moe.nea.firmament.events.EntityUpdateEvent;
import moe.nea.firmament.events.ProcessChatEvent;
import moe.nea.firmament.events.WorldReadyEvent;
import moe.nea.firmament.events.WorldRenderLastEvent;
import moe.nea.firmament.features.debug.DebugLogger;
import moe.nea.firmament.features.events.carnival.CarnivalFeatures;
import moe.nea.firmament.util.LegacyFormattingCode;
import moe.nea.firmament.util.MC;
import moe.nea.firmament.util.MoulConfigUtils;
import moe.nea.firmament.util.ScreenUtil;
import moe.nea.firmament.util.SkyblockId;
import moe.nea.firmament.util.SkyblockIdKt;
import moe.nea.firmament.util.mc.SkullItemDataKt;
import moe.nea.firmament.util.render.RenderInWorldContext;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005?@ABCB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0019\u001a\u00020\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\u00020\u00188\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001e\u0010\u001cR#\u0010!\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010&\u001a\u00020%8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020%8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b*\u0010'\u001a\u0004\b+\u0010)R\u0017\u0010-\u001a\u00020,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u001a\u00101\u001a\u00020%8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b1\u0010'\u001a\u0004\b2\u0010)R$\u00104\u001a\u0004\u0018\u0001038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0017\u0010;\u001a\u00020:8\u0006\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\u00a8\u0006D"}, d2={"Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper;", "", "<init>", "()V", "Lmoe/nea/firmament/events/CommandEvent$SubCommand;", "event", "", "onCommand", "(Lmoe/nea/firmament/events/CommandEvent$SubCommand;)V", "Lmoe/nea/firmament/events/WorldReadyEvent;", "onWorldChange", "(Lmoe/nea/firmament/events/WorldReadyEvent;)V", "Lmoe/nea/firmament/events/ProcessChatEvent;", "onChat", "(Lmoe/nea/firmament/events/ProcessChatEvent;)V", "Lmoe/nea/firmament/events/EntityUpdateEvent;", "onMobChange", "(Lmoe/nea/firmament/events/EntityUpdateEvent;)V", "Lmoe/nea/firmament/events/AttackBlockEvent;", "onBlockClick", "(Lmoe/nea/firmament/events/AttackBlockEvent;)V", "Lmoe/nea/firmament/events/WorldRenderLastEvent;", "onRender", "(Lmoe/nea/firmament/events/WorldRenderLastEvent;)V", "Lnet/minecraft/class_2338;", "sandBoxLow", "Lnet/minecraft/class_2338;", "getSandBoxLow", "()Lnet/minecraft/class_2338;", "sandBoxHigh", "getSandBoxHigh", "Lkotlin/Pair;", "", "boardSize", "Lkotlin/Pair;", "getBoardSize", "()Lkotlin/Pair;", "", "gameStartMessage", "Ljava/lang/String;", "getGameStartMessage", "()Ljava/lang/String;", "gameEndMessage", "getGameEndMessage", "Ljava/util/regex/Pattern;", "bombPattern", "Ljava/util/regex/Pattern;", "getBombPattern", "()Ljava/util/regex/Pattern;", "startGameQuestion", "getStartGameQuestion", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$GameState;", "gameState", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$GameState;", "getGameState", "()Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$GameState;", "setGameState", "(Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$GameState;)V", "Lmoe/nea/firmament/features/debug/DebugLogger;", "log", "Lmoe/nea/firmament/features/debug/DebugLogger;", "getLog", "()Lmoe/nea/firmament/features/debug/DebugLogger;", "Piece", "TutorialScreen", "DowsingMode", "BoardPosition", "GameState", "Firmament"})
@SourceDebugExtension(value={"SMAP\nMinesweeperHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinesweeperHelper.kt\nmoe/nea/firmament/features/events/carnival/MinesweeperHelper\n+ 2 regex.kt\nmoe/nea/firmament/util/RegexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n24#2,3:278\n23#2:281\n1#3:282\n*S KotlinDebug\n*F\n+ 1 MinesweeperHelper.kt\nmoe/nea/firmament/features/events/carnival/MinesweeperHelper\n*L\n241#1:278,3\n241#1:281\n241#1:282\n*E\n"})
public final class MinesweeperHelper {
    @NotNull
    public static final MinesweeperHelper INSTANCE = new MinesweeperHelper();
    @NotNull
    private static final class_2338 sandBoxLow = new class_2338(-112, 72, -11);
    @NotNull
    private static final class_2338 sandBoxHigh = new class_2338(-106, 72, -5);
    @NotNull
    private static final Pair<Integer, Integer> boardSize = new Pair((Object)(sandBoxHigh.method_10263() - sandBoxLow.method_10263()), (Object)(sandBoxHigh.method_10260() - sandBoxLow.method_10260()));
    @NotNull
    private static final String gameStartMessage = "[NPC] Carnival Pirateman: Good luck, matey!";
    @NotNull
    private static final String gameEndMessage = "Fruit Digging";
    @NotNull
    private static final Pattern bombPattern;
    @NotNull
    private static final String startGameQuestion;
    @Nullable
    private static GameState gameState;
    @NotNull
    private static final DebugLogger log;

    private MinesweeperHelper() {
    }

    @NotNull
    public final class_2338 getSandBoxLow() {
        return sandBoxLow;
    }

    @NotNull
    public final class_2338 getSandBoxHigh() {
        return sandBoxHigh;
    }

    @NotNull
    public final Pair<Integer, Integer> getBoardSize() {
        return boardSize;
    }

    @NotNull
    public final String getGameStartMessage() {
        return gameStartMessage;
    }

    @NotNull
    public final String getGameEndMessage() {
        return gameEndMessage;
    }

    @NotNull
    public final Pattern getBombPattern() {
        return bombPattern;
    }

    @NotNull
    public final String getStartGameQuestion() {
        return startGameQuestion;
    }

    @Nullable
    public final GameState getGameState() {
        return gameState;
    }

    public final void setGameState(@Nullable GameState gameState) {
        MinesweeperHelper.gameState = gameState;
    }

    @NotNull
    public final DebugLogger getLog() {
        return log;
    }

    public final void onCommand(@NotNull CommandEvent.SubCommand event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.subcommand("minesweepertutorial", (Function1<? super CaseInsensitiveLiteralCommandNode.Builder<FabricClientCommandSource>, Unit>)((Function1)MinesweeperHelper::onCommand$lambda$1));
    }

    public final void onWorldChange(@NotNull WorldReadyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        gameState = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void onChat(@NotNull ProcessChatEvent event) {
        block8: {
            void $this$useMatch$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (CarnivalFeatures.TConfig.INSTANCE.getDisplayTutorials() && Intrinsics.areEqual((Object)event.getUnformattedString(), (Object)startGameQuestion)) {
                class_5250 class_52502 = class_2561.method_43471((String)"firmament.carnival.tutorial.minesweeper").method_27694(MinesweeperHelper::onChat$lambda$2);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"styled(...)");
                MC.INSTANCE.sendChat((class_2561)class_52502);
            }
            if (!CarnivalFeatures.TConfig.INSTANCE.getEnableBombSolver()) {
                gameState = null;
                return;
            }
            if (Intrinsics.areEqual((Object)event.getUnformattedString(), (Object)gameStartMessage)) {
                gameState = new GameState(null, null, null, null, 15, null);
                log.log((Function0<String>)((Function0)MinesweeperHelper::onChat$lambda$3));
            }
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)event.getUnformattedString())).toString(), (Object)gameEndMessage)) {
                gameState = null;
                log.log((Function0<String>)((Function0)MinesweeperHelper::onChat$lambda$4));
            }
            GameState gameState = MinesweeperHelper.gameState;
            if (gameState == null) {
                return;
            }
            GameState gs = gameState;
            Pattern pattern = bombPattern;
            String string$iv = event.getUnformattedString();
            boolean $i$f$useMatch = false;
            if (string$iv == null) break block8;
            CharSequence p0$iv = string$iv;
            boolean bl = false;
            Matcher matcher = $this$useMatch$iv.matcher(p0$iv);
            if (matcher != null) {
                Matcher matcher2;
                Matcher matcher3;
                Matcher p0$iv2 = matcher3 = matcher;
                boolean bl2 = false;
                Matcher matcher4 = matcher2 = p0$iv2.matches() ? matcher3 : null;
                if (matcher2 != null) {
                    Matcher $this$onChat_u24lambda_u246 = matcher2;
                    boolean bl3 = false;
                    String string = $this$onChat_u24lambda_u246.group("bombCount");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    int bombCount = Integer.parseInt(string);
                    log.log((Function0<String>)((Function0)() -> MinesweeperHelper.onChat$lambda$6$lambda$5(gs, bombCount)));
                    BoardPosition boardPosition = gs.getLastClickedPosition();
                    if (boardPosition == null) {
                        return;
                    }
                    BoardPosition pos = boardPosition;
                    Integer n = bombCount;
                    gs.getNearbyBombs().put(pos, n);
                }
            }
        }
    }

    public final void onMobChange(@NotNull EntityUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GameState gameState = MinesweeperHelper.gameState;
        if (gameState == null) {
            return;
        }
        GameState gs = gameState;
        if (!(event instanceof EntityUpdateEvent.TrackedDataUpdate)) {
            return;
        }
    }

    public final void onBlockClick(@NotNull AttackBlockEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GameState gameState = MinesweeperHelper.gameState;
        if (gameState == null) {
            return;
        }
        GameState gs = gameState;
        BoardPosition boardPosition = BoardPosition.Companion.fromBlockPos(event.getBlockPos());
        log.log((Function0<String>)((Function0)() -> MinesweeperHelper.onBlockClick$lambda$7(event, boardPosition)));
        gs.setLastClickedPosition(boardPosition);
        class_1799 class_17992 = event.getPlayer().method_6047();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getMainHandStack(...)");
        gs.setLastDowsingMode(DowsingMode.Companion.fromItem(class_17992));
    }

    public final void onRender(@NotNull WorldRenderLastEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GameState gameState = MinesweeperHelper.gameState;
        if (gameState == null) {
            return;
        }
        GameState gs = gameState;
        RenderInWorldContext.Companion.renderInWorld(event, (Function1<? super RenderInWorldContext, Unit>)((Function1)arg_0 -> MinesweeperHelper.onRender$lambda$8(gs, arg_0)));
    }

    private static final Unit onCommand$lambda$1$lambda$0(CommandContext $this$thenExecute) {
        Intrinsics.checkNotNullParameter((Object)$this$thenExecute, (String)"$this$thenExecute");
        ScreenUtil.INSTANCE.setScreenLater(MoulConfigUtils.INSTANCE.loadScreen("carnival/minesweeper_tutorial", TutorialScreen.INSTANCE, null));
        return Unit.INSTANCE;
    }

    private static final Unit onCommand$lambda$1(CaseInsensitiveLiteralCommandNode.Builder $this$subcommand) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$subcommand), (String)"$this$subcommand");
        DslKt.thenExecute((ArgumentBuilder)$this$subcommand, (Function1<? super CommandContext<FabricClientCommandSource>, Unit>)((Function1)MinesweeperHelper::onCommand$lambda$1$lambda$0));
        return Unit.INSTANCE;
    }

    private static final class_2583 onChat$lambda$2(class_2583 it) {
        return it.method_10958((class_2558)new class_2558.class_10609("/firm minesweepertutorial"));
    }

    private static final String onChat$lambda$3() {
        return "Game started";
    }

    private static final String onChat$lambda$4() {
        return "Finished game";
    }

    private static final String onChat$lambda$6$lambda$5(GameState $gs, int $bombCount) {
        return "Marking " + $gs.getLastClickedPosition() + " as having " + $bombCount + " nearby";
    }

    private static final String onBlockClick$lambda$7(AttackBlockEvent $event, BoardPosition $boardPosition) {
        return "Breaking block at " + $event.getBlockPos() + " (" + $boardPosition + ")";
    }

    private static final Unit onRender$lambda$8(GameState $gs, RenderInWorldContext $this$renderInWorld) {
        Intrinsics.checkNotNullParameter((Object)$this$renderInWorld, (String)"$this$renderInWorld");
        for (Map.Entry<BoardPosition, Integer> entry : $gs.getNearbyBombs().entrySet()) {
            BoardPosition pos = entry.getKey();
            int bombCount = ((Number)entry.getValue()).intValue();
            class_243 class_2432 = pos.toBlockPos().method_10084().method_46558();
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"toCenterPos(...)");
            class_2561[] class_2561Array = new class_2561[]{class_2561.method_43470((String)("\u00a7a" + bombCount + " \ud83d\udca3"))};
            RenderInWorldContext.text$default($this$renderInWorld, class_2432, class_2561Array, null, 0, 12, null);
        }
        return Unit.INSTANCE;
    }

    static {
        String string = "MINES! There (are|is) (?<bombCount>[0-8]) bombs? hidden nearby\\.";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        bombPattern = pattern;
        startGameQuestion = "[NPC] Carnival Pirateman: Would ye like to do some Fruit Digging?";
        log = new DebugLogger("minesweeper");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0010\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0016J$\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001b\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0016J\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u0016R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b#\u0010\u0016\u00a8\u0006%"}, d2={"Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;", "", "", "x", "y", "<init>", "(II)V", "Lnet/minecraft/class_2338;", "toBlockPos", "()Lnet/minecraft/class_2338;", "Lnet/minecraft/class_1936;", "world", "Lnet/minecraft/class_2248;", "kotlin.jvm.PlatformType", "getBlock", "(Lnet/minecraft/class_1936;)Lnet/minecraft/class_2248;", "", "isUnopened", "(Lnet/minecraft/class_1936;)Z", "isOpened", "isScorched", "component1", "()I", "component2", "copy", "(II)Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getX", "getY", "Companion", "Firmament"})
    public static final class BoardPosition {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int x;
        private final int y;

        public BoardPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        @NotNull
        public final class_2338 toBlockPos() {
            return new class_2338(INSTANCE.getSandBoxLow().method_10263() + this.x, INSTANCE.getSandBoxLow().method_10264(), INSTANCE.getSandBoxLow().method_10260() + this.y);
        }

        public final class_2248 getBlock(@NotNull class_1936 world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return world.method_8320(this.toBlockPos()).method_26204();
        }

        public final boolean isUnopened(@NotNull class_1936 world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return Intrinsics.areEqual((Object)this.getBlock(world), (Object)class_2246.field_10102);
        }

        public final boolean isOpened(@NotNull class_1936 world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return Intrinsics.areEqual((Object)this.getBlock(world), (Object)class_2246.field_9979);
        }

        public final boolean isScorched(@NotNull class_1936 world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return Intrinsics.areEqual((Object)this.getBlock(world), (Object)class_2246.field_10142);
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        @NotNull
        public final BoardPosition copy(int x, int y) {
            return new BoardPosition(x, y);
        }

        public static /* synthetic */ BoardPosition copy$default(BoardPosition boardPosition, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = boardPosition.x;
            }
            if ((n3 & 2) != 0) {
                n2 = boardPosition.y;
            }
            return boardPosition.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "BoardPosition(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BoardPosition)) {
                return false;
            }
            BoardPosition boardPosition = (BoardPosition)other;
            if (this.x != boardPosition.x) {
                return false;
            }
            return this.y == boardPosition.y;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2338;", "blockPos", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;", "fromBlockPos", "(Lnet/minecraft/class_2338;)Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;", "Firmament"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final BoardPosition fromBlockPos(@NotNull class_2338 blockPos) {
                Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
                if (blockPos.method_10264() != INSTANCE.getSandBoxLow().method_10264()) {
                    return null;
                }
                int x = blockPos.method_10263() - INSTANCE.getSandBoxLow().method_10263();
                int y = blockPos.method_10260() - INSTANCE.getSandBoxLow().method_10260();
                if (x < 0 || x >= ((Number)INSTANCE.getBoardSize().getFirst()).intValue()) {
                    return null;
                }
                if (y < 0 || y >= ((Number)INSTANCE.getBoardSize().getSecond()).intValue()) {
                    return null;
                }
                return new BoardPosition(x, y);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00048G\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\u00020\u00048G\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000f\u001a\u0004\b\u0012\u0010\u0011j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;", "", "Lnet/minecraft/class_1792;", "itemType", "", "feature", "description", "<init>", "(Ljava/lang/String;ILnet/minecraft/class_1792;Ljava/lang/String;Ljava/lang/String;)V", "Lmoe/nea/firmament/deps/moulconfig/common/IItemStack;", "getItemStack", "()Lio/github/notenoughupdates/moulconfig/common/IItemStack;", "Lnet/minecraft/class_1792;", "getItemType", "()Lnet/minecraft/class_1792;", "Ljava/lang/String;", "getFeature", "()Ljava/lang/String;", "getDescription", "Companion", "MINES", "ANCHOR", "TREASURE", "Firmament"})
    public static final class DowsingMode
    extends Enum<DowsingMode> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final class_1792 itemType;
        @NotNull
        private final String feature;
        @NotNull
        private final String description;
        @NotNull
        private static final String id;
        public static final /* enum */ DowsingMode MINES;
        public static final /* enum */ DowsingMode ANCHOR;
        public static final /* enum */ DowsingMode TREASURE;
        private static final /* synthetic */ DowsingMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DowsingMode(class_1792 itemType, String feature, String description) {
            this.itemType = itemType;
            this.feature = feature;
            this.description = description;
        }

        @NotNull
        public final class_1792 getItemType() {
            return this.itemType;
        }

        @Bind(value="feature")
        @NotNull
        public final String getFeature() {
            return this.feature;
        }

        @Bind(value="description")
        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @Bind(value="itemType")
        @NotNull
        public final IItemStack getItemStack() {
            IItemStack iItemStack = MoulConfigPlatform.wrap(new class_1799((class_1935)this.itemType));
            Intrinsics.checkNotNullExpressionValue((Object)iItemStack, (String)"wrap(...)");
            return iItemStack;
        }

        public static DowsingMode[] values() {
            return (DowsingMode[])$VALUES.clone();
        }

        public static DowsingMode valueOf(String value) {
            return Enum.valueOf(DowsingMode.class, value);
        }

        @NotNull
        public static EnumEntries<DowsingMode> getEntries() {
            return $ENTRIES;
        }

        static {
            class_1792 class_17922 = class_1802.field_8699;
            Intrinsics.checkNotNullExpressionValue((Object)class_17922, (String)"IRON_SHOVEL");
            MINES = new DowsingMode(class_17922, "Bomb detection", "Tells you how many bombs are near the block");
            class_1792 class_17923 = class_1802.field_8250;
            Intrinsics.checkNotNullExpressionValue((Object)class_17923, (String)"DIAMOND_SHOVEL");
            ANCHOR = new DowsingMode(class_17923, "Lowest fruit", "Shows you which block nearby contains the lowest scoring fruit");
            class_1792 class_17924 = class_1802.field_8322;
            Intrinsics.checkNotNullExpressionValue((Object)class_17924, (String)"GOLDEN_SHOVEL");
            TREASURE = new DowsingMode(class_17924, "Highest fruit", "Tells you which kind of fruit is the highest scoring nearby");
            $VALUES = dowsingModeArray = new DowsingMode[]{DowsingMode.MINES, DowsingMode.ANCHOR, DowsingMode.TREASURE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            id = SkyblockId.constructor-impl("CARNIVAL_SHOVEL");
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_1799;", "itemStack", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;", "fromItem", "(Lnet/minecraft/class_1799;)Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;", "Lmoe/nea/firmament/util/SkyblockId;", "id", "Ljava/lang/String;", "getId-RS9x2LM", "()Ljava/lang/String;", "Firmament"})
        @SourceDebugExtension(value={"SMAP\nMinesweeperHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinesweeperHelper.kt\nmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getId-RS9x2LM() {
                return id;
            }

            @Nullable
            public final DowsingMode fromItem(@NotNull class_1799 itemStack) {
                Object v1;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
                    String string = SkyblockIdKt.getSkyBlockId(itemStack);
                    Object object = this.getId-RS9x2LM();
                    String string2 = string;
                    if (!(string2 == null ? false : SkyblockId.equals-impl0(string2, (String)object))) {
                        return null;
                    }
                    object = (Iterable)DowsingMode.getEntries();
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        DowsingMode it = (DowsingMode)((Object)t);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getItemType(), (Object)itemStack.method_7909())) continue;
                        v1 = t;
                        break block2;
                    }
                    v1 = null;
                }
                return v1;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014JN\u0010\u0015\u001a\u00020\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\u000eR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010\u0010R$\u0010\b\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010'R$\u0010\n\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010(\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$GameState;", "", "", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;", "", "nearbyBombs", "", "knownBombPositions", "lastClickedPosition", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;", "lastDowsingMode", "<init>", "(Ljava/util/Map;Ljava/util/Set;Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;)V", "component1", "()Ljava/util/Map;", "component2", "()Ljava/util/Set;", "component3", "()Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;", "component4", "()Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;", "copy", "(Ljava/util/Map;Ljava/util/Set;Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;)Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$GameState;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getNearbyBombs", "Ljava/util/Set;", "getKnownBombPositions", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;", "getLastClickedPosition", "setLastClickedPosition", "(Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$BoardPosition;)V", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;", "getLastDowsingMode", "setLastDowsingMode", "(Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;)V", "Firmament"})
    public static final class GameState {
        @NotNull
        private final Map<BoardPosition, Integer> nearbyBombs;
        @NotNull
        private final Set<BoardPosition> knownBombPositions;
        @Nullable
        private BoardPosition lastClickedPosition;
        @Nullable
        private DowsingMode lastDowsingMode;

        public GameState(@NotNull Map<BoardPosition, Integer> nearbyBombs, @NotNull Set<BoardPosition> knownBombPositions, @Nullable BoardPosition lastClickedPosition, @Nullable DowsingMode lastDowsingMode) {
            Intrinsics.checkNotNullParameter(nearbyBombs, (String)"nearbyBombs");
            Intrinsics.checkNotNullParameter(knownBombPositions, (String)"knownBombPositions");
            this.nearbyBombs = nearbyBombs;
            this.knownBombPositions = knownBombPositions;
            this.lastClickedPosition = lastClickedPosition;
            this.lastDowsingMode = lastDowsingMode;
        }

        public /* synthetic */ GameState(Map map, Set set, BoardPosition boardPosition, DowsingMode dowsingMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            if ((n & 2) != 0) {
                set = new LinkedHashSet();
            }
            if ((n & 4) != 0) {
                boardPosition = null;
            }
            if ((n & 8) != 0) {
                dowsingMode = null;
            }
            this(map, set, boardPosition, dowsingMode);
        }

        @NotNull
        public final Map<BoardPosition, Integer> getNearbyBombs() {
            return this.nearbyBombs;
        }

        @NotNull
        public final Set<BoardPosition> getKnownBombPositions() {
            return this.knownBombPositions;
        }

        @Nullable
        public final BoardPosition getLastClickedPosition() {
            return this.lastClickedPosition;
        }

        public final void setLastClickedPosition(@Nullable BoardPosition boardPosition) {
            this.lastClickedPosition = boardPosition;
        }

        @Nullable
        public final DowsingMode getLastDowsingMode() {
            return this.lastDowsingMode;
        }

        public final void setLastDowsingMode(@Nullable DowsingMode dowsingMode) {
            this.lastDowsingMode = dowsingMode;
        }

        @NotNull
        public final Map<BoardPosition, Integer> component1() {
            return this.nearbyBombs;
        }

        @NotNull
        public final Set<BoardPosition> component2() {
            return this.knownBombPositions;
        }

        @Nullable
        public final BoardPosition component3() {
            return this.lastClickedPosition;
        }

        @Nullable
        public final DowsingMode component4() {
            return this.lastDowsingMode;
        }

        @NotNull
        public final GameState copy(@NotNull Map<BoardPosition, Integer> nearbyBombs, @NotNull Set<BoardPosition> knownBombPositions, @Nullable BoardPosition lastClickedPosition, @Nullable DowsingMode lastDowsingMode) {
            Intrinsics.checkNotNullParameter(nearbyBombs, (String)"nearbyBombs");
            Intrinsics.checkNotNullParameter(knownBombPositions, (String)"knownBombPositions");
            return new GameState(nearbyBombs, knownBombPositions, lastClickedPosition, lastDowsingMode);
        }

        public static /* synthetic */ GameState copy$default(GameState gameState, Map map, Set set, BoardPosition boardPosition, DowsingMode dowsingMode, int n, Object object) {
            if ((n & 1) != 0) {
                map = gameState.nearbyBombs;
            }
            if ((n & 2) != 0) {
                set = gameState.knownBombPositions;
            }
            if ((n & 4) != 0) {
                boardPosition = gameState.lastClickedPosition;
            }
            if ((n & 8) != 0) {
                dowsingMode = gameState.lastDowsingMode;
            }
            return gameState.copy(map, set, boardPosition, dowsingMode);
        }

        @NotNull
        public String toString() {
            return "GameState(nearbyBombs=" + this.nearbyBombs + ", knownBombPositions=" + this.knownBombPositions + ", lastClickedPosition=" + this.lastClickedPosition + ", lastDowsingMode=" + this.lastDowsingMode + ")";
        }

        public int hashCode() {
            int result = ((Object)this.nearbyBombs).hashCode();
            result = result * 31 + ((Object)this.knownBombPositions).hashCode();
            result = result * 31 + (this.lastClickedPosition == null ? 0 : this.lastClickedPosition.hashCode());
            result = result * 31 + (this.lastDowsingMode == null ? 0 : this.lastDowsingMode.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GameState)) {
                return false;
            }
            GameState gameState = (GameState)other;
            if (!Intrinsics.areEqual(this.nearbyBombs, gameState.nearbyBombs)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.knownBombPositions, gameState.knownBombPositions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastClickedPosition, (Object)gameState.lastClickedPosition)) {
                return false;
            }
            return this.lastDowsingMode == gameState.lastDowsingMode;
        }

        public GameState() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B9\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028G\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0019\u0010\u0011R\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0014\u001a\u0004\b\u001b\u0010\u0011R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0014\u001a\u0004\b \u0010\u0011R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/\u00a8\u00060"}, d2={"Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$Piece;", "", "", "fruitName", "", "points", "specialAbility", "totalPerBoard", "textureHash", "Lmoe/nea/firmament/util/LegacyFormattingCode;", "fruitColor", "<init>", "(Ljava/lang/String;ILjava/lang/String;ILjava/lang/String;ILjava/lang/String;Lmoe/nea/firmament/util/LegacyFormattingCode;)V", "Lmoe/nea/firmament/deps/moulconfig/common/IItemStack;", "getIcon", "()Lio/github/notenoughupdates/moulconfig/common/IItemStack;", "pieceLabel", "()Ljava/lang/String;", "boardLabel", "getDescription", "Ljava/lang/String;", "getFruitName", "I", "getPoints", "()I", "getSpecialAbility", "getTotalPerBoard", "getTextureHash", "Lmoe/nea/firmament/util/LegacyFormattingCode;", "getFruitColor", "()Lmoe/nea/firmament/util/LegacyFormattingCode;", "textureUrl", "getTextureUrl", "Lnet/minecraft/class_1799;", "itemStack", "Lnet/minecraft/class_1799;", "getItemStack", "()Lnet/minecraft/class_1799;", "COCONUT", "APPLE", "WATERMELON", "DURIAN", "MANGO", "DRAGON_FRUIT", "POMEGRANATE", "CHERRY", "BOMB", "RUM", "Firmament"})
    public static final class Piece
    extends Enum<Piece> {
        @NotNull
        private final String fruitName;
        private final int points;
        @NotNull
        private final String specialAbility;
        private final int totalPerBoard;
        @NotNull
        private final String textureHash;
        @NotNull
        private final LegacyFormattingCode fruitColor;
        @NotNull
        private final String textureUrl;
        @NotNull
        private final class_1799 itemStack;
        public static final /* enum */ Piece COCONUT = new Piece("Coconut", 200, "Prevents a bomb from exploding next turn", 3, "10ceb1455b471d016a9f06d25f6e468df9fcf223e2c1e4795b16e84fcca264ee", LegacyFormattingCode.DARK_PURPLE);
        public static final /* enum */ Piece APPLE = new Piece("Apple", 100, "Gains 100 points for each apple dug up", 8, "17ea278d6225c447c5943d652798d0bbbd1418434ce8c54c54fdac79994ddd6c", LegacyFormattingCode.GREEN);
        public static final /* enum */ Piece WATERMELON = new Piece("Watermelon", 100, "Blows up an adjacent fruit for half the points", 4, "efe4ef83baf105e8dee6cf03dfe7407f1911b3b9952c891ae34139560f2931d6", LegacyFormattingCode.DARK_BLUE);
        public static final /* enum */ Piece DURIAN = new Piece("Durian", 800, "Halves the points earned in the next turn", 2, "ac268d36c2c6047ffeec00124096376b56dbb4d756a55329363a1b27fcd659cd", LegacyFormattingCode.DARK_PURPLE);
        public static final /* enum */ Piece MANGO = new Piece("Mango", 300, "Just an ordinary fruit", 10, "f363a62126a35537f8189343a22660de75e810c6ac004a7d3da65f1c040a839", LegacyFormattingCode.GREEN);
        public static final /* enum */ Piece DRAGON_FRUIT = new Piece("Dragonfruit", 1200, "Halves the points earned in the next turn", 1, "3cc761bcb0579763d9b8ab6b7b96fa77eb6d9605a804d838fec39e7b25f95591", LegacyFormattingCode.LIGHT_PURPLE);
        public static final /* enum */ Piece POMEGRANATE = new Piece("Pomegranate", 200, "Grants an extra 50% more points in the next turn", 4, "40824d18079042d5769f264f44394b95b9b99ce689688cc10c9eec3f882ccc08", LegacyFormattingCode.DARK_BLUE);
        public static final /* enum */ Piece CHERRY = new Piece("Cherry", 200, "The second cherry grants 300 bonus points", 2, "c92b099a62cd2fbf8ada09dec145c75d7fda4dc57b968bea3a8fa11e37aa48b2", LegacyFormattingCode.DARK_PURPLE);
        public static final /* enum */ Piece BOMB = new Piece("Bomb", -1, "Destroys nearby fruit", 15, "a76a2811d1e176a07b6d0a657b910f134896ce30850f6e80c7c83732d85381ea", LegacyFormattingCode.DARK_RED);
        public static final /* enum */ Piece RUM = new Piece("Rum", -1, "Stops your dowsing ability for one turn", 5, "407b275d28b927b1bf7f6dd9f45fbdad2af8571c54c8f027d1bff6956fbf3c16", LegacyFormattingCode.YELLOW);
        private static final /* synthetic */ Piece[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Piece(String fruitName, int points, String specialAbility, int totalPerBoard, String textureHash, LegacyFormattingCode fruitColor) {
            this.fruitName = fruitName;
            this.points = points;
            this.specialAbility = specialAbility;
            this.totalPerBoard = totalPerBoard;
            this.textureHash = textureHash;
            this.fruitColor = fruitColor;
            this.textureUrl = "http://textures.minecraft.net/texture/" + this.textureHash;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.itemStack = SkyblockIdKt.setSkyBlockFirmamentUiId(SkullItemDataKt.createSkullItem(uUID, this.textureUrl), "MINESWEEPER_" + this.name());
        }

        @Bind(value="fruitName")
        @NotNull
        public final String getFruitName() {
            return this.fruitName;
        }

        public final int getPoints() {
            return this.points;
        }

        @NotNull
        public final String getSpecialAbility() {
            return this.specialAbility;
        }

        public final int getTotalPerBoard() {
            return this.totalPerBoard;
        }

        @NotNull
        public final String getTextureHash() {
            return this.textureHash;
        }

        @NotNull
        public final LegacyFormattingCode getFruitColor() {
            return this.fruitColor;
        }

        @NotNull
        public final String getTextureUrl() {
            return this.textureUrl;
        }

        @NotNull
        public final class_1799 getItemStack() {
            return this.itemStack;
        }

        @Bind
        @NotNull
        public final IItemStack getIcon() {
            IItemStack iItemStack = MoulConfigPlatform.wrap(this.itemStack);
            Intrinsics.checkNotNullExpressionValue((Object)iItemStack, (String)"wrap(...)");
            return iItemStack;
        }

        @Bind
        @NotNull
        public final String pieceLabel() {
            return this.fruitColor.getFormattingCode() + this.fruitName;
        }

        @Bind
        @NotNull
        public final String boardLabel() {
            return "\u00a7a" + this.totalPerBoard + "\u00a77/\u00a7rboard";
        }

        @Bind(value="description")
        @NotNull
        public final String getDescription() {
            StringBuilder stringBuilder;
            StringBuilder $this$getDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getDescription_u24lambda_u240.append(this.specialAbility);
            if (this.points >= 0) {
                $this$getDescription_u24lambda_u240.append(" Default points: " + this.points + ".");
            }
            return stringBuilder.toString();
        }

        public static Piece[] values() {
            return (Piece[])$VALUES.clone();
        }

        public static Piece valueOf(String value) {
            return Enum.valueOf(Piece.class, value);
        }

        @NotNull
        public static EnumEntries<Piece> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pieceArray = new Piece[]{Piece.COCONUT, Piece.APPLE, Piece.WATERMELON, Piece.DURIAN, Piece.MANGO, Piece.DRAGON_FRUIT, Piece.POMEGRANATE, Piece.CHERRY, Piece.BOMB, Piece.RUM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R%\u0010\u0007\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048G\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR%\u0010\f\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b0\u00048G\u00a2\u0006\f\n\u0004\b\f\u0010\b\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$TutorialScreen;", "", "<init>", "()V", "Lmoe/nea/firmament/deps/moulconfig/observer/ObservableList;", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$Piece;", "kotlin.jvm.PlatformType", "pieces", "Lmoe/nea/firmament/deps/moulconfig/observer/ObservableList;", "getPieces", "()Lio/github/notenoughupdates/moulconfig/observer/ObservableList;", "Lmoe/nea/firmament/features/events/carnival/MinesweeperHelper$DowsingMode;", "modes", "getModes", "Firmament"})
    public static final class TutorialScreen {
        @NotNull
        public static final TutorialScreen INSTANCE = new TutorialScreen();
        @NotNull
        private static final ObservableList<Piece> pieces = new ObservableList(CollectionsKt.reversed((Iterable)CollectionsKt.toList((Iterable)((Iterable)Piece.getEntries()))));
        @NotNull
        private static final ObservableList<DowsingMode> modes = new ObservableList(CollectionsKt.toList((Iterable)((Iterable)DowsingMode.getEntries())));

        private TutorialScreen() {
        }

        @Bind(value="pieces")
        @NotNull
        public final ObservableList<Piece> getPieces() {
            return pieces;
        }

        @Bind(value="modes")
        @NotNull
        public final ObservableList<DowsingMode> getModes() {
            return modes;
        }
    }
}

