/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.gui.config.storage;

import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import moe.nea.firmament.gui.config.storage.FirmamentConfigLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u0003R\u001a\u0010\f\u001a\u00020\u000b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lmoe/nea/firmament/gui/config/storage/LegacyImporter;", "", "<init>", "()V", "Ljava/nio/file/Path;", "from", "to", "", "copyIf", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "importFromLegacy", "", "legacyConfigVersion", "I", "getLegacyConfigVersion", "()I", "kotlin.jvm.PlatformType", "backupPath", "Ljava/nio/file/Path;", "getBackupPath", "()Ljava/nio/file/Path;", "", "", "legacyStorage", "Ljava/util/List;", "getLegacyStorage", "()Ljava/util/List;", "Firmament"})
@SourceDebugExtension(value={"SMAP\nLegacyImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyImporter.kt\nmoe/nea/firmament/gui/config/storage/LegacyImporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1869#2,2:70\n774#2:72\n865#2,2:73\n1869#2,2:75\n1#3:77\n*S KotlinDebug\n*F\n+ 1 LegacyImporter.kt\nmoe/nea/firmament/gui/config/storage/LegacyImporter\n*L\n39#1:70,2\n47#1:72\n47#1:73,2\n48#1:75,2\n*E\n"})
public final class LegacyImporter {
    @NotNull
    public static final LegacyImporter INSTANCE = new LegacyImporter();
    private static final int legacyConfigVersion = 995;
    private static final Path backupPath = FirmamentConfigLoader.INSTANCE.getConfigFolder().resolveSibling("firmament-legacy-config-" + System.currentTimeMillis());
    @NotNull
    private static final List<String> legacyStorage;

    private LegacyImporter() {
    }

    public final int getLegacyConfigVersion() {
        return legacyConfigVersion;
    }

    public final Path getBackupPath() {
        return backupPath;
    }

    public final void copyIf(@NotNull Path from, @NotNull Path to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(from, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathsKt.createParentDirectories((Path)to, (FileAttribute[])new FileAttribute[0]);
            Path path = from;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, to, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
    }

    @NotNull
    public final List<String> getLegacyStorage() {
        return legacyStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importFromLegacy() {
        Path path;
        Object object;
        Iterator $this$filterTo$iv$iv;
        Path path2 = FirmamentConfigLoader.INSTANCE.getConfigFolder();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"<get-configFolder>(...)");
        Path path3 = path2;
        Object object2 = new LinkOption[]{};
        if (!Files.exists(path3, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
            return;
        }
        Path path4 = FirmamentConfigLoader.INSTANCE.getConfigFolder();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"<get-configFolder>(...)");
        path3 = path4;
        Path path5 = backupPath;
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"backupPath");
        object2 = path5;
        CopyOption[] copyOptionArray = new CopyOption[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.move(path3, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
        Path path6 = FirmamentConfigLoader.INSTANCE.getConfigFolder();
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"<get-configFolder>(...)");
        path3 = path6;
        object2 = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, (FileAttribute[])Arrays.copyOf(object2, ((LinkOption[])object2).length)), (String)"createDirectories(...)");
        Iterable $this$forEach$iv = legacyStorage;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Path path7 = backupPath.resolve(it + ".json");
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
            Path path8 = FirmamentConfigLoader.INSTANCE.getStorageFolder().resolve(it + ".json");
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
            INSTANCE.copyIf(path7, path8);
        }
        Path path9 = backupPath;
        Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"backupPath");
        Iterable $this$filter$iv = PathsKt.listDirectoryEntries((Path)path9, (String)"*.json");
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            if (!(!legacyStorage.contains(PathsKt.getNameWithoutExtension((Path)it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path bl2;
            Path path10 = (Path)element$iv;
            boolean bl3 = false;
            String name = PathsKt.getName((Path)path10);
            Path path11 = path10;
            Intrinsics.checkNotNullExpressionValue((Object)FirmamentConfigLoader.INSTANCE.getConfigFolder().resolve(name), (String)"resolve(...)");
            object = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path11, bl2, Arrays.copyOf(object, ((CopyOption[])object).length)), (String)"copy(...)");
        }
        Path it = path = backupPath.resolve("profiles");
        boolean bl4 = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path path12 = path3 = Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
        if (path3 != null) {
            path = path3;
            Closeable closeable = Files.newDirectoryStream(path, "*");
            Throwable throwable = null;
            try {
                DirectoryStream directoryStream = (DirectoryStream)closeable;
                Intrinsics.checkNotNull((Object)directoryStream);
                Iterable iterable2 = directoryStream;
                for (Path category : iterable2) {
                    boolean bl5 = false;
                    object = category;
                    Closeable closeable2 = Files.newDirectoryStream((Path)object, "*");
                    Throwable throwable2 = null;
                    try {
                        DirectoryStream directoryStream2 = (DirectoryStream)closeable2;
                        Intrinsics.checkNotNull((Object)directoryStream2);
                        Iterable iterable3 = directoryStream2;
                        for (Path profile : iterable3) {
                            boolean bl6 = false;
                            Path path13 = FirmamentConfigLoader.INSTANCE.getProfilePath().resolve(PathsKt.getNameWithoutExtension((Path)profile)).resolve(PathsKt.getName((Path)category) + ".json");
                            Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"resolve(...)");
                            INSTANCE.copyIf(profile, path13);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Path path14 = FirmamentConfigLoader.INSTANCE.getConfigVersionFile();
        Intrinsics.checkNotNullExpressionValue((Object)path14, (String)"<get-configVersionFile>(...)");
        PathsKt.writeText$default((Path)path14, (CharSequence)(legacyConfigVersion + " LEGACY"), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    static {
        Object[] objectArray = new String[]{"inventory-buttons", "macros"};
        legacyStorage = CollectionsKt.listOf((Object[])objectArray);
    }
}

