/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.util;

import com.sun.tools.attach.VirtualMachine;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import moe.nea.firmament.util.ErrorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\r\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lmoe/nea/firmament/util/JvmUtil;", "", "<init>", "()V", "", "guessJVMPid", "()Ljava/lang/String;", "Lcom/sun/tools/attach/VirtualMachine;", "getVM", "()Lcom/sun/tools/attach/VirtualMachine;", "Lkotlin/Function1;", "", "block", "useVM", "(Lkotlin/jvm/functions/Function1;)V", "Ljava/nio/file/Path;", "jarPath", "options", "loadAgent", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "Firmament"})
@SourceDebugExtension(value={"SMAP\nJvmUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmUtil.kt\nmoe/nea/firmament/util/JvmUtil\n+ 2 ErrorUtil.kt\nmoe/nea/firmament/util/ErrorUtil\n*L\n1#1,33:1\n18#2:34\n43#2,3:35\n19#2:38\n*S KotlinDebug\n*F\n+ 1 JvmUtil.kt\nmoe/nea/firmament/util/JvmUtil\n*L\n12#1:34\n12#1:35,3\n12#1:38\n*E\n"})
public final class JvmUtil {
    @NotNull
    public static final JvmUtil INSTANCE = new JvmUtil();

    private JvmUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String guessJVMPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        Intrinsics.checkNotNull((Object)name);
        String pid = StringsKt.substringBefore$default((String)name, (char)'@', null, (int)2, null);
        ErrorUtil errorUtil = ErrorUtil.INSTANCE;
        String string = "Not a valid PID: " + pid;
        boolean check$iv = StringsKt.toIntOrNull((String)pid) != null;
        boolean $i$f$softCheck = false;
        if (!check$iv) {
            void message$iv;
            void this_$iv;
            void this_$iv$iv = this_$iv;
            boolean $i$f$softError = false;
            if (this_$iv$iv.getAggressiveErrors()) {
                throw new IllegalStateException(message$iv.toString());
            }
            this_$iv$iv.logError((String)message$iv);
        }
        return pid;
    }

    @NotNull
    public final VirtualMachine getVM() {
        VirtualMachine virtualMachine = VirtualMachine.attach(this.guessJVMPid());
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"attach(...)");
        return virtualMachine;
    }

    public final void useVM(@NotNull Function1<? super VirtualMachine, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        VirtualMachine vm = this.getVM();
        block.invoke((Object)vm);
        vm.detach();
    }

    public final void loadAgent(@NotNull Path jarPath, @Nullable String options) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        this.useVM((Function1<? super VirtualMachine, Unit>)((Function1)arg_0 -> JvmUtil.loadAgent$lambda$0(jarPath, options, arg_0)));
    }

    public static /* synthetic */ void loadAgent$default(JvmUtil jvmUtil, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        jvmUtil.loadAgent(path, string);
    }

    private static final Unit loadAgent$lambda$0(Path $jarPath, String $options, VirtualMachine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.loadAgent(((Object)$jarPath.toAbsolutePath()).toString(), $options);
        return Unit.INSTANCE;
    }
}

