/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.lisp;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import moe.nea.lisp.CoreBindings;
import moe.nea.lisp.LispAst;
import moe.nea.lisp.LispData;
import moe.nea.lisp.LispExecutionContext;
import moe.nea.lisp.StackFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0002J\u0015\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u000208\u00a2\u0006\u0002\u0010<J\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u000e\u0010B\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u000e\u0010C\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u0015\u0010D\u001a\u0002062\u0006\u00107\u001a\u000208H\u0000\u00a2\u0006\u0002\bER\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0011\u00101\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u0011\u00103\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0014\u00a8\u0006F"}, d2={"Lmoe/nea/lisp/CoreBindings;", "", "()V", "add", "Lmoe/nea/lisp/LispData$LispExecutable;", "getAdd", "()Lmoe/nea/lisp/LispData$LispExecutable;", "debuglog", "getDebuglog", "def", "getDef", "defun", "getDefun", "div", "getDiv", "eq", "getEq", "falseValue", "Lmoe/nea/lisp/LispData$Atom;", "getFalseValue", "()Lmoe/nea/lisp/LispData$Atom;", "ifFun", "getIfFun", "import", "getImport", "indexList", "getIndexList", "joinList", "getJoinList", "lambda", "getLambda", "lengthList", "getLengthList", "less", "getLess", "makeList", "getMakeList", "mul", "getMul", "pure", "getPure", "reflect", "getReflect", "seq", "getSeq", "sliceList", "getSliceList", "sub", "getSub", "tostring", "getTostring", "trueValue", "getTrueValue", "atomOrStringToString", "", "thing", "Lmoe/nea/lisp/LispData;", "isTruthy", "", "data", "(Lmoe/nea/lisp/LispData;)Ljava/lang/Boolean;", "offerAllTo", "", "bindings", "Lmoe/nea/lisp/StackFrame;", "offerArithmeticTo", "offerHashesTo", "offerListTo", "stringify", "stringify$nealisp", "nealisp"})
public final class CoreBindings {
    @NotNull
    public static final CoreBindings INSTANCE = new CoreBindings();
    @NotNull
    private static final LispData.LispExecutable def = LispData.Companion.externalRawCall("def", (Function4<? super LispExecutionContext, ? super LispAst.LispNode, ? super StackFrame, ? super List<? extends LispAst.LispNode>, ? extends LispData>)((Function4)def.1.INSTANCE));
    @NotNull
    private static final LispData.Atom trueValue = new LispData.Atom("true");
    @NotNull
    private static final LispData.Atom falseValue = new LispData.Atom("false");
    @NotNull
    private static final LispData.LispExecutable ifFun = LispData.Companion.externalRawCall("if", (Function4<? super LispExecutionContext, ? super LispAst.LispNode, ? super StackFrame, ? super List<? extends LispAst.LispNode>, ? extends LispData>)((Function4)ifFun.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable pure = LispData.Companion.externalCall("pure", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)pure.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable lambda = LispData.Companion.externalRawCall("lambda", (Function4<? super LispExecutionContext, ? super LispAst.LispNode, ? super StackFrame, ? super List<? extends LispAst.LispNode>, ? extends LispData>)((Function4)lambda.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable defun = LispData.Companion.externalRawCall("defun", (Function4<? super LispExecutionContext, ? super LispAst.LispNode, ? super StackFrame, ? super List<? extends LispAst.LispNode>, ? extends LispData>)((Function4)defun.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable seq = LispData.Companion.externalRawCall("seq", (Function4<? super LispExecutionContext, ? super LispAst.LispNode, ? super StackFrame, ? super List<? extends LispAst.LispNode>, ? extends LispData>)((Function4)seq.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable tostring = LispData.Companion.externalCall("tostring", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)tostring.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable debuglog = LispData.Companion.externalRawCall("debuglog", (Function4<? super LispExecutionContext, ? super LispAst.LispNode, ? super StackFrame, ? super List<? extends LispAst.LispNode>, ? extends LispData>)((Function4)debuglog.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable add = LispData.Companion.externalCall("add", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)add.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable sub = LispData.Companion.externalCall("sub", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)sub.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable mul = LispData.Companion.externalCall("mul", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)mul.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable eq = LispData.Companion.externalCall("eq", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)eq.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable div = LispData.Companion.externalCall("div", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)div.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable less = LispData.Companion.externalCall("less", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)less.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable import = LispData.Companion.externalRawCall("import", (Function4<? super LispExecutionContext, ? super LispAst.LispNode, ? super StackFrame, ? super List<? extends LispAst.LispNode>, ? extends LispData>)((Function4)import.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable reflect = LispData.Companion.externalCall("reflect.type", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)reflect.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable makeList = LispData.Companion.externalCall("list.make", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)makeList.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable indexList = LispData.Companion.externalCall("list.at", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)indexList.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable joinList = LispData.Companion.externalCall("list.join", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)joinList.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable sliceList = LispData.Companion.externalCall("list.slice", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)sliceList.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable lengthList = LispData.Companion.externalCall("list.length", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)lengthList.1.INSTANCE));

    private CoreBindings() {
    }

    @NotNull
    public final LispData.LispExecutable getDef() {
        return def;
    }

    @Nullable
    public final Boolean isTruthy(@NotNull LispData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)data, (Object)trueValue)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)data, (Object)falseValue)) {
            return false;
        }
        return null;
    }

    @NotNull
    public final LispData.Atom getTrueValue() {
        return trueValue;
    }

    @NotNull
    public final LispData.Atom getFalseValue() {
        return falseValue;
    }

    @NotNull
    public final LispData.LispExecutable getIfFun() {
        return ifFun;
    }

    @NotNull
    public final LispData.LispExecutable getPure() {
        return pure;
    }

    @NotNull
    public final LispData.LispExecutable getLambda() {
        return lambda;
    }

    @NotNull
    public final LispData.LispExecutable getDefun() {
        return defun;
    }

    @NotNull
    public final LispData.LispExecutable getSeq() {
        return seq;
    }

    @NotNull
    public final String stringify$nealisp(@NotNull LispData thing) {
        String string;
        Intrinsics.checkNotNullParameter((Object)thing, (String)"thing");
        LispData lispData = thing;
        if (lispData instanceof LispData.Atom) {
            string = ':' + ((LispData.Atom)thing).getLabel();
        } else if (lispData instanceof LispData.JavaExecutable) {
            string = "<native function " + ((LispData.JavaExecutable)thing).getName() + '>';
        } else if (Intrinsics.areEqual((Object)lispData, (Object)LispData.LispNil.INSTANCE)) {
            string = "nil";
        } else if (lispData instanceof LispData.LispNode) {
            string = ((LispData.LispNode)thing).getNode().toSource();
        } else if (lispData instanceof LispData.LispList) {
            string = CollectionsKt.joinToString$default((Iterable)((LispData.LispList)thing).getElements(), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)stringify.1.INSTANCE, (int)24, null);
        } else if (lispData instanceof LispData.LispString) {
            string = ((LispData.LispString)thing).getString();
        } else if (lispData instanceof LispData.LispHash) {
            string = CollectionsKt.joinToString$default((Iterable)((LispData.LispHash)thing).getMap().entrySet(), (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)stringify.2.INSTANCE, (int)24, null);
        } else if (lispData instanceof LispData.LispNumber) {
            string = String.valueOf(((LispData.LispNumber)thing).getValue());
        } else if (lispData instanceof LispData.ForeignObject) {
            string = "<foreign " + ((LispData.ForeignObject)thing).getObj() + '>';
        } else if (lispData instanceof LispData.LispInterpretedCallable) {
            StringBuilder stringBuilder = new StringBuilder().append("<function ");
            String string2 = ((LispData.LispInterpretedCallable)thing).getName();
            if (string2 == null) {
                string2 = "<anonymous>";
            }
            string = stringBuilder.append(string2).append(' ').append(((LispData.LispInterpretedCallable)thing).getArgNames()).append(' ').append(((LispData.LispInterpretedCallable)thing).getBody().toSource()).append('>').toString();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final LispData.LispExecutable getTostring() {
        return tostring;
    }

    @NotNull
    public final LispData.LispExecutable getDebuglog() {
        return debuglog;
    }

    @NotNull
    public final LispData.LispExecutable getAdd() {
        return add;
    }

    @NotNull
    public final LispData.LispExecutable getSub() {
        return sub;
    }

    @NotNull
    public final LispData.LispExecutable getMul() {
        return mul;
    }

    @NotNull
    public final LispData.LispExecutable getEq() {
        return eq;
    }

    @NotNull
    public final LispData.LispExecutable getDiv() {
        return div;
    }

    @NotNull
    public final LispData.LispExecutable getLess() {
        return less;
    }

    private final String atomOrStringToString(LispData thing) {
        LispData lispData = thing;
        return lispData instanceof LispData.Atom ? ((LispData.Atom)thing).getLabel() : (lispData instanceof LispData.LispString ? ((LispData.LispString)thing).getString() : null);
    }

    @NotNull
    public final LispData.LispExecutable getImport() {
        return import;
    }

    @NotNull
    public final LispData.LispExecutable getReflect() {
        return reflect;
    }

    @NotNull
    public final LispData.LispExecutable getMakeList() {
        return makeList;
    }

    @NotNull
    public final LispData.LispExecutable getIndexList() {
        return indexList;
    }

    @NotNull
    public final LispData.LispExecutable getJoinList() {
        return joinList;
    }

    @NotNull
    public final LispData.LispExecutable getSliceList() {
        return sliceList;
    }

    @NotNull
    public final LispData.LispExecutable getLengthList() {
        return lengthList;
    }

    public final void offerListTo(@NotNull StackFrame bindings) {
        Intrinsics.checkNotNullParameter((Object)bindings, (String)"bindings");
        bindings.setValueLocal("core.list.length", lengthList);
        bindings.setValueLocal("core.list.slice", sliceList);
        bindings.setValueLocal("core.list.join", joinList);
        bindings.setValueLocal("core.list.at", indexList);
        bindings.setValueLocal("core.list.new", makeList);
    }

    public final void offerArithmeticTo(@NotNull StackFrame bindings) {
        Intrinsics.checkNotNullParameter((Object)bindings, (String)"bindings");
        bindings.setValueLocal("core.arith.add", add);
        bindings.setValueLocal("core.arith.div", div);
        bindings.setValueLocal("core.arith.mul", mul);
        bindings.setValueLocal("core.arith.sub", sub);
        bindings.setValueLocal("core.arith.less", less);
        bindings.setValueLocal("core.arith.eq", eq);
    }

    public final void offerHashesTo(@NotNull StackFrame bindings) {
        Intrinsics.checkNotNullParameter((Object)bindings, (String)"bindings");
        bindings.setValueLocal("core.newhash", LispData.Companion.externalCall("newhash", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)offerHashesTo.1.INSTANCE)));
        bindings.setValueLocal("core.gethash", LispData.Companion.externalCall("gethash", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)offerHashesTo.2.INSTANCE)));
        bindings.setValueLocal("core.mergehash", LispData.Companion.externalCall("mergehash", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)offerHashesTo.3.INSTANCE)));
    }

    public final void offerAllTo(@NotNull StackFrame bindings) {
        Intrinsics.checkNotNullParameter((Object)bindings, (String)"bindings");
        bindings.setValueLocal("core.if", ifFun);
        bindings.setValueLocal("core.nil", LispData.LispNil.INSTANCE);
        bindings.setValueLocal("core.def", def);
        bindings.setValueLocal("core.tostring", tostring);
        bindings.setValueLocal("core.pure", pure);
        bindings.setValueLocal("core.lambda", lambda);
        bindings.setValueLocal("core.defun", defun);
        bindings.setValueLocal("core.seq", seq);
        bindings.setValueLocal("core.import", import);
        bindings.setValueLocal("core.reflect.type", reflect);
        bindings.setValueLocal("core.debuglog", debuglog);
        this.offerArithmeticTo(bindings);
        this.offerListTo(bindings);
        this.offerHashesTo(bindings);
    }

    public static final /* synthetic */ String access$atomOrStringToString(CoreBindings $this, LispData thing) {
        return $this.atomOrStringToString(thing);
    }
}

