/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config.backup;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.backup.ConfigBackupManager;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ConfigBackupScreen
extends class_437 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_437 parent;
    private BackupListWidget listWidget;
    private SettingsListWidget detailsWidget;
    private Set<String> changedPaths = Collections.emptySet();

    public ConfigBackupScreen(@Nullable class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"skyblocker.config.general.backup.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        int listWidth = this.field_22789 / 2 - 4;
        int detailsWidth = this.field_22789 - listWidth - 8;
        int listHeight = this.field_22790 - 64;
        if (this.listWidget == null) {
            this.listWidget = new BackupListWidget(this.field_22787, listWidth, listHeight, 32, 24);
        } else {
            this.listWidget.method_55445(listWidth, listHeight);
            this.listWidget.updateEntries();
        }
        this.listWidget.method_46421(4);
        if (this.detailsWidget == null) {
            this.detailsWidget = new SettingsListWidget(this.field_22787, detailsWidth, listHeight, 32, 10);
        } else {
            this.detailsWidget.method_55445(detailsWidth, listHeight);
        }
        this.detailsWidget.method_46421(listWidth + 8);
        this.detailsWidget.updateEntries(this.listWidget.getSelectedPath());
        this.method_37063((class_364)this.listWidget);
        this.method_37063((class_364)this.detailsWidget);
        class_4185 restoreBtn = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.config.general.backup.restore"), b -> {
            Path selected = this.listWidget.getSelectedPath();
            if (selected != null) {
                assert (this.field_22787 != null);
                this.field_22787.method_1507((class_437)new class_410(confirm -> {
                    if (confirm) {
                        try {
                            ConfigBackupManager.restoreBackup(selected);
                        }
                        catch (IOException e) {
                            LOGGER.error("[Skyblocker] Failed to restore backup {}", (Object)selected.getFileName().toString(), (Object)e);
                            this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"skyblocker.config.backup.restore.error"), (class_2561)class_2561.method_43470((String)"Failed to restore backup")));
                            return;
                        }
                        if (this.parent != null) {
                            this.field_22787.method_1507(SkyblockerConfigManager.createGUI(this.parent));
                        } else {
                            this.field_22787.method_1507(null);
                        }
                    } else {
                        this.field_22787.method_1507((class_437)this);
                    }
                }, (class_2561)class_2561.method_43471((String)"skyblocker.config.general.backup.confirm.title"), (class_2561)class_2561.method_54159((String)"skyblocker.config.general.backup.confirm.text", (Object[])new Object[]{selected.getFileName().toString()}), class_5244.field_24336, class_5244.field_24337));
            }
        }).method_46437(90, 20).method_46433(this.field_22789 / 2 - 95, this.field_22790 - 28).method_46431();
        this.method_37063((class_364)restoreBtn);
        class_4185 done = class_4185.method_46430((class_2561)class_5244.field_24334, b -> this.method_25419()).method_46437(90, 20).method_46433(this.field_22789 / 2 + 5, this.field_22790 - 28).method_46431();
        this.method_37063((class_364)done);
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.listWidget.method_25394(context, mouseX, mouseY, delta);
        this.detailsWidget.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, -1);
    }

    private class BackupListWidget
    extends class_4265<BackupEntry> {
        BackupListWidget(class_310 client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
            this.updateEntries();
        }

        Path getSelectedPath() {
            BackupEntry entry = (BackupEntry)this.method_25334();
            return entry != null ? entry.path : null;
        }

        public void setSelected(@Nullable BackupEntry entry) {
            super.method_25313((class_350.class_351)entry);
            ConfigBackupScreen.this.detailsWidget.updateEntries(entry != null ? entry.path : null);
        }

        void updateEntries() {
            this.method_25339();
            try {
                List<Path> backups = ConfigBackupManager.listBackups();
                for (Path backup : backups) {
                    this.method_25321((class_350.class_351)new BackupEntry(backup));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int method_25322() {
            return super.method_25322();
        }

        protected int method_65507() {
            return this.method_46426() + this.method_25368() - 6;
        }
    }

    private class SettingsListWidget
    extends class_4265<StringEntry> {
        SettingsListWidget(class_310 client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
        }

        void updateEntries(@Nullable Path path) {
            this.method_25339();
            ConfigBackupScreen.this.changedPaths = Collections.emptySet();
            if (path == null) {
                return;
            }
            try {
                JsonElement backupJson = JsonParser.parseReader((Reader)Files.newBufferedReader(path));
                JsonElement currentJson = JsonParser.parseReader((Reader)Files.newBufferedReader(SkyblockerConfigManager.getConfigPath()));
                HashSet<String> diffs = new HashSet<String>();
                this.findDiffs("", backupJson, currentJson, diffs);
                ConfigBackupScreen.this.changedPaths = diffs;
                ArrayList<JsonLine> lines = new ArrayList<JsonLine>();
                this.formatJson(null, backupJson, "", 0, true, lines);
                for (JsonLine l : lines) {
                    this.method_25321((class_350.class_351)new StringEntry(l.text, l.path));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int method_25322() {
            return this.method_25368() - 10;
        }

        protected int method_65507() {
            return this.method_46426() + this.method_25368() - 6;
        }

        private void findDiffs(String pathPrefix, JsonElement backup, JsonElement current, Set<String> diffs) {
            if (backup == null) {
                return;
            }
            if (!backup.equals(current)) {
                if (backup.isJsonObject() && current != null && current.isJsonObject()) {
                    for (Map.Entry entry : backup.getAsJsonObject().entrySet()) {
                        String next = pathPrefix.isEmpty() ? (String)entry.getKey() : pathPrefix + "." + (String)entry.getKey();
                        this.findDiffs(next, (JsonElement)entry.getValue(), current.getAsJsonObject().get((String)entry.getKey()), diffs);
                    }
                } else if (backup.isJsonArray() && current != null && current.isJsonArray()) {
                    for (int i = 0; i < backup.getAsJsonArray().size(); ++i) {
                        String next = pathPrefix + "[" + i + "]";
                        JsonElement curr = i < current.getAsJsonArray().size() ? current.getAsJsonArray().get(i) : null;
                        this.findDiffs(next, backup.getAsJsonArray().get(i), curr, diffs);
                    }
                } else {
                    diffs.add(pathPrefix);
                }
            }
        }

        private void formatJson(String key, JsonElement element, String path, int indent, boolean last, List<JsonLine> out) {
            String newPath;
            String ind = "  ".repeat(indent);
            String string = key == null ? path : (newPath = path.isEmpty() ? key : path + "." + key);
            if (element.isJsonObject()) {
                String line = key == null ? ind + "{" : ind + "\"" + key + "\": {";
                out.add(new JsonLine(line, null));
                Iterator it = element.getAsJsonObject().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = (Map.Entry)it.next();
                    this.formatJson((String)e.getKey(), (JsonElement)e.getValue(), newPath, indent + 1, !it.hasNext(), out);
                }
                out.add(new JsonLine(ind + "}" + (last ? "" : ","), path.isEmpty() ? null : path));
            } else if (element.isJsonArray()) {
                String line = key == null ? ind + "[" : ind + "\"" + key + "\": [";
                out.add(new JsonLine(line, null));
                JsonArray arr = element.getAsJsonArray();
                for (int i = 0; i < arr.size(); ++i) {
                    this.formatJson(null, arr.get(i), newPath + "[" + i + "]", indent + 1, i == arr.size() - 1, out);
                }
                out.add(new JsonLine(ind + "]" + (last ? "" : ","), path));
            } else {
                String value = element.toString();
                String line = key == null ? ind + value : ind + "\"" + key + "\": " + value;
                out.add(new JsonLine(line + (last ? "" : ","), newPath));
            }
        }

        private record JsonLine(String text, @Nullable String path) {
        }
    }

    private class StringEntry
    extends class_4265.class_4266<StringEntry> {
        private final String text;
        @Nullable
        private final String path;

        StringEntry(@Nullable String text, String path) {
            this.text = text;
            this.path = path;
        }

        public List<class_364> method_25396() {
            return List.of();
        }

        public List<class_6379> method_37025() {
            return List.of();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int color = -1;
            if (this.path != null && ConfigBackupScreen.this.changedPaths.contains(this.path)) {
                color = -171;
            }
            context.method_51433(ConfigBackupScreen.this.field_22793, this.text, x + 2, y + 2, color, false);
        }
    }

    private class BackupEntry
    extends class_4265.class_4266<BackupEntry> {
        private final Path path;

        BackupEntry(Path path) {
            this.path = path;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            ConfigBackupScreen.this.listWidget.setSelected(this);
            return true;
        }

        public List<class_364> method_25396() {
            return List.of();
        }

        public List<class_6379> method_37025() {
            return List.of();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (((Object)((Object)this)).equals(ConfigBackupScreen.this.listWidget.method_25334())) {
                int textWidth = ConfigBackupScreen.this.field_22793.method_1727(this.path.getFileName().toString()) + 8;
                int highlightRight = x + Math.min(textWidth, entryWidth - 5);
                context.method_25294(x, y, highlightRight, y + entryHeight, -2130706433);
            }
            context.method_51433(ConfigBackupScreen.this.field_22793, this.path.getFileName().toString(), x + 4, y + 7, -1, false);
        }
    }
}

