/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.events;

import de.hysky.skyblocker.utils.Area;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.purse.PurseChangeCause;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;

@Environment(value=EnvType.CLIENT)
public final class SkyblockEvents {
    public static final Event<SkyblockJoin> JOIN = EventFactory.createArrayBacked(SkyblockJoin.class, callbacks -> () -> {
        for (SkyblockJoin callback : callbacks) {
            callback.onSkyblockJoin();
        }
    });
    public static final Event<SkyblockLeave> LEAVE = EventFactory.createArrayBacked(SkyblockLeave.class, callbacks -> () -> {
        for (SkyblockLeave callback : callbacks) {
            callback.onSkyblockLeave();
        }
    });
    public static final Event<SkyblockLocationChange> LOCATION_CHANGE = EventFactory.createArrayBacked(SkyblockLocationChange.class, callbacks -> location -> {
        for (SkyblockLocationChange callback : callbacks) {
            callback.onSkyblockLocationChange(location);
        }
    });
    public static final Event<SkyblockAreaChange> AREA_CHANGE = EventFactory.createArrayBacked(SkyblockAreaChange.class, callbacks -> area -> {
        for (SkyblockAreaChange callback : callbacks) {
            callback.onSkyblockAreaChange(area);
        }
    });
    public static final Event<ProfileChange> PROFILE_CHANGE = EventFactory.createArrayBacked(ProfileChange.class, callbacks -> (prev, profile) -> {
        for (ProfileChange callback : callbacks) {
            callback.onSkyblockProfileChange(prev, profile);
        }
    });
    public static final Event<ProfileInit> PROFILE_INIT = EventFactory.createArrayBacked(ProfileInit.class, callbacks -> profile -> {
        for (ProfileInit callback : callbacks) {
            callback.onSkyblockProfileInit(profile);
        }
    });
    public static final Event<PurseChange> PURSE_CHANGE = EventFactory.createArrayBacked(PurseChange.class, callbacks -> (diff, cause) -> {
        for (PurseChange callback : callbacks) {
            callback.onPurseChange(diff, cause);
        }
    });

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PurseChange {
        public void onPurseChange(double var1, PurseChangeCause var3);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ProfileInit {
        public void onSkyblockProfileInit(String var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ProfileChange {
        public void onSkyblockProfileChange(String var1, String var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SkyblockAreaChange {
        public void onSkyblockAreaChange(Area var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SkyblockLocationChange {
        public void onSkyblockLocationChange(Location var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SkyblockLeave {
        public void onSkyblockLeave();
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SkyblockJoin {
        public void onSkyblockJoin();
    }
}

