/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.OkLabColor;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.apache.commons.lang3.math.NumberUtils;

public class CompactDamage {
    private static final Pattern DAMAGE_PATTERN = Pattern.compile("[\u2727\u272f]?[\\d,]+[\u2727\u272f]?\u2764?");

    private CompactDamage() {
    }

    public static void compactDamage(class_1531 entity) {
        class_5250 prettierCustomName;
        if (!SkyblockerConfigManager.get().uiAndVisuals.compactDamage.enabled) {
            return;
        }
        if (!(entity.method_5767() && entity.method_16914() && entity.method_5807())) {
            return;
        }
        class_2561 customName = entity.method_5797();
        String customNameStringified = customName.getString();
        if (!DAMAGE_PATTERN.matcher(customNameStringified).matches()) {
            return;
        }
        List siblings = customName.method_10855();
        if (siblings.isEmpty()) {
            return;
        }
        if (siblings.size() == 1) {
            class_2561 text = (class_2561)siblings.getFirst();
            String dmg = text.getString().replace(",", "");
            if (!NumberUtils.isParsable((String)dmg)) {
                return;
            }
            String prettifiedDmg = CompactDamage.prettifyDamageNumber(Long.parseLong(dmg));
            int color = text.method_10866().method_10973() != null ? (text.method_10866().method_10973() == class_5251.method_27718((class_124)class_124.field_1080) ? SkyblockerConfigManager.get().uiAndVisuals.compactDamage.normalDamageColor.getRGB() & 0xFFFFFF : text.method_10866().method_10973().method_27716()) : SkyblockerConfigManager.get().uiAndVisuals.compactDamage.normalDamageColor.getRGB() & 0xFFFFFF;
            prettierCustomName = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)prettifiedDmg).method_10862(customName.method_10866()).method_54663(color));
        } else {
            boolean wasDoubled = customNameStringified.contains("\u2764");
            int entriesToRemove = wasDoubled ? 2 : 1;
            String dmg = siblings.subList(1, siblings.size() - entriesToRemove).stream().map(class_2561::getString).reduce("", String::concat).replace(",", "");
            if (!NumberUtils.isParsable((String)dmg)) {
                return;
            }
            String dmgSymbol = customNameStringified.charAt(0) != '\u272f' ? "\u2727" : "\u272f";
            String prettifiedDmg = dmgSymbol + CompactDamage.prettifyDamageNumber(Long.parseLong(dmg)) + dmgSymbol;
            prettierCustomName = class_2561.method_43470((String)"");
            int length = prettifiedDmg.length();
            for (int i = 0; i < length; ++i) {
                prettierCustomName.method_10852((class_2561)class_2561.method_43470((String)prettifiedDmg.substring(i, i + 1)).method_54663(OkLabColor.interpolate(SkyblockerConfigManager.get().uiAndVisuals.compactDamage.critDamageGradientStart.getRGB() & 0xFFFFFF, SkyblockerConfigManager.get().uiAndVisuals.compactDamage.critDamageGradientEnd.getRGB() & 0xFFFFFF, (float)i / ((float)length - 1.0f))));
            }
            if (wasDoubled) {
                prettierCustomName.method_10852((class_2561)class_2561.method_43470((String)"\u2764").method_27692(class_124.field_1076));
            }
            prettierCustomName.method_10862(customName.method_10866());
        }
        entity.method_5665((class_2561)prettierCustomName);
    }

    private static String prettifyDamageNumber(long damage) {
        if (damage < 1000L) {
            return String.valueOf(damage);
        }
        if (damage < 1000000L) {
            return CompactDamage.format((double)damage / 1000.0) + "k";
        }
        if (damage < 1000000000L) {
            return CompactDamage.format((double)damage / 1000000.0) + "M";
        }
        if (damage < 1000000000000L) {
            return CompactDamage.format((double)damage / 1.0E9) + "B";
        }
        return CompactDamage.format((double)damage / 1.0E12) + "T";
    }

    private static String format(double number) {
        return ("%." + SkyblockerConfigManager.get().uiAndVisuals.compactDamage.precision + "f").formatted(number);
    }
}

