/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatPositionShare {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChatPositionShare.class);
    private static final Pattern SIMPLE_COORDS_PATTERN = Pattern.compile("(?<x>-?[0-9]+) (?<y>[0-9]+) (?<z>-?[0-9]+)");
    private static final Pattern SIMPLE_COMMA_COORDS_PATTERN = Pattern.compile("(?<x>-?[0-9]+), (?<y>[0-9]+), (?<z>-?[0-9]+)");
    private static final Pattern GENERIC_COORDS_PATTERN = Pattern.compile("x: (?<x>-?[0-9]+), y: (?<y>[0-9]+), z: (?<z>-?[0-9]+)");
    private static final Pattern SKYBLOCKER_COORDS_PATTERN = Pattern.compile("x: (?<x>-?[0-9]+), y: (?<y>[0-9]+), z: (?<z>-?[0-9]+)(?: \\| (?<area>[^|]+))");
    private static final Pattern SKYHANNI_DIANA_PATTERN = Pattern.compile("A MINOS INQUISITOR has spawned near \\[(?<area>[^]]*)] at Coords (?<x>-?[0-9]+) (?<y>[0-9]+) (?<z>-?[0-9]+)");
    private static final List<Pattern> PATTERNS = List.of(SKYBLOCKER_COORDS_PATTERN, SKYHANNI_DIANA_PATTERN, GENERIC_COORDS_PATTERN, SIMPLE_COMMA_COORDS_PATTERN, SIMPLE_COORDS_PATTERN);

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"sharePosition").executes(context -> ChatPositionShare.sharePlayerPosition((FabricClientCommandSource)context.getSource())))));
        ClientReceiveMessageEvents.ALLOW_GAME.register(ChatPositionShare::onMessage);
    }

    private static int sharePlayerPosition(FabricClientCommandSource source) {
        class_243 pos = source.getPosition();
        MessageScheduler.INSTANCE.sendMessageAfterCooldown("x: " + (int)pos.method_10216() + ", y: " + (int)pos.method_10214() + ", z: " + (int)pos.method_10215() + " | " + Utils.getIslandArea(), true);
        return 1;
    }

    private static boolean onMessage(class_2561 text, boolean overlay) {
        if (Utils.isOnSkyblock() && SkyblockerConfigManager.get().uiAndVisuals.waypoints.enableWaypoints) {
            String message = text.getString();
            if (message.startsWith("[Skyblocker]") || message.startsWith("\u00a7e[NPC] Treasure Hunter\u00a7f:")) {
                return true;
            }
            for (Pattern pattern : PATTERNS) {
                Matcher matcher = pattern.matcher(message);
                if (!matcher.find()) continue;
                try {
                    String x = matcher.group("x");
                    String y = matcher.group("y");
                    String z = matcher.group("z");
                    String area = matcher.namedGroups().containsKey("area") ? matcher.group("area") : "";
                    ChatPositionShare.requestWaypoint(x, y, z, area);
                }
                catch (Exception e) {
                    LOGGER.error("[Skyblocker Chat Waypoints] Error creating chat waypoint: ", (Throwable)e);
                }
                break;
            }
        }
        return true;
    }

    private static void requestWaypoint(String x, String y, String z, @NotNull String area) {
        String command = "/skyblocker waypoints individual " + x + " " + y + " " + z + " " + area;
        class_5250 requestMessage = Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.config.chat.waypoints.display", (Object[])new Object[]{x, y, z}).method_27692(class_124.field_1075).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(command.trim()))));
        if (!area.isEmpty()) {
            requestMessage = requestMessage.method_27693(" at ").method_10852((class_2561)class_2561.method_43470((String)area).method_27692(class_124.field_1075));
        }
        class_310.method_1551().field_1724.method_7353((class_2561)requestMessage, false);
    }
}

