/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.mixins.accessors.MapStateAccessor;
import de.hysky.skyblocker.skyblock.dungeon.DungeonMapConfigScreen;
import de.hysky.skyblocker.skyblock.dungeon.DungeonScore;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonMapUtils;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonPlayerManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.HudHelper;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_10090;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_2374;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_330;
import net.minecraft.class_332;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import net.minecraft.class_9428;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DungeonMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(DungeonMap.class);
    private static final class_2960 DUNGEON_MAP = class_2960.method_60655((String)"skyblocker", (String)"dungeon_map");
    private static final class_9209 DEFAULT_MAP_ID_COMPONENT = new class_9209(1024);
    private static final class_10090 MAP_RENDER_STATE = new class_10090();
    private static class_9209 cachedMapIdComponent = null;

    @Init
    public static void init() {
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.STATUS_EFFECTS, (class_2960)DUNGEON_MAP, (context, tickCounter) -> DungeonMap.render(context));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"hud").then(ClientCommandManager.literal((String)"dungeon").executes(Scheduler.queueOpenScreenCommand(DungeonMapConfigScreen::new))))));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> DungeonMap.reset());
    }

    private static boolean shouldProcess() {
        return Utils.isInDungeons() && DungeonScore.isDungeonStarted() && !DungeonManager.isInBoss();
    }

    private static void render(class_332 context) {
        DungeonsConfig.DungeonMap dungeonMap = SkyblockerConfigManager.get().dungeons.dungeonMap;
        if (DungeonMap.shouldProcess() && dungeonMap.enableMap) {
            DungeonMap.render(context, dungeonMap.mapX, dungeonMap.mapY, dungeonMap.mapScaling, dungeonMap.fancyMap);
        }
    }

    public static void render(class_332 context, int x, int y, float scale, boolean fancy) {
        DungeonMap.render(context, x, y, scale, fancy, Integer.MIN_VALUE, Integer.MIN_VALUE, null);
    }

    @Nullable
    public static UUID render(class_332 context, int x, int y, float scale, boolean fancy, int mouseX, int mouseY, @Nullable UUID enlarge) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return null;
        }
        class_9209 mapId = DungeonMap.getMapIdComponent((class_1799)client.field_1724.method_31548().method_67533().get(8));
        class_22 state = class_1806.method_7997((class_9209)mapId, (class_1937)client.field_1687);
        if (state == null) {
            return null;
        }
        class_330 mapRenderer = client.method_61965();
        mapRenderer.method_62230(mapId, state, MAP_RENDER_STATE);
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)x, (float)y);
        context.method_51448().scale(scale, scale);
        context.method_70857(MAP_RENDER_STATE);
        UUID hoveredHead = null;
        if (fancy) {
            hoveredHead = DungeonMap.renderPlayerHeads(context, (class_1937)client.field_1687, state, (float)mouseX / scale, (float)mouseY / scale, enlarge);
        }
        context.method_51448().popMatrix();
        return hoveredHead;
    }

    public static class_9209 getMapIdComponent(class_1799 stack) {
        if (stack.method_31574(class_1802.field_8204) && stack.method_57826(class_9334.field_49646)) {
            class_9209 mapIdComponent;
            cachedMapIdComponent = mapIdComponent = (class_9209)stack.method_58694(class_9334.field_49646);
            return mapIdComponent;
        }
        return cachedMapIdComponent != null ? cachedMapIdComponent : DEFAULT_MAP_ID_COMPONENT;
    }

    @Nullable
    private static UUID renderPlayerHeads(class_332 context, class_1937 world, class_22 state, double mouseX, double mouseY, @Nullable UUID enlarge) {
        if (!DungeonManager.isClearingDungeon()) {
            return null;
        }
        int i = 1;
        UUID hovered = null;
        for (Map.Entry<String, class_20> mapDecoration : ((MapStateAccessor)state).getDecorations().entrySet()) {
            DungeonPlayerManager.DungeonPlayer dungeonPlayer = null;
            if (((class_9428)mapDecoration.getValue().comp_1842().comp_349()).equals(class_21.field_95.comp_349())) {
                if (!SkyblockerConfigManager.get().dungeons.dungeonMap.showSelfHead) continue;
                dungeonPlayer = DungeonPlayerManager.getPlayers()[0];
            } else {
                while (!(i >= DungeonPlayerManager.getPlayers().length || dungeonPlayer != null && dungeonPlayer.alive())) {
                    dungeonPlayer = DungeonPlayerManager.getPlayers()[i];
                    ++i;
                }
            }
            if (dungeonPlayer == null) {
                DungeonMap.dungeonPlayerError(mapDecoration.getKey(), "not found", i - 1, DungeonPlayerManager.getPlayers(), ((MapStateAccessor)state).getDecorations());
                continue;
            }
            if (!dungeonPlayer.alive()) {
                DungeonMap.dungeonPlayerError(mapDecoration.getKey(), "not alive", i - 1, DungeonPlayerManager.getPlayers(), ((MapStateAccessor)state).getDecorations());
                continue;
            }
            if (dungeonPlayer.uuid() == null) {
                DungeonMap.dungeonPlayerError(mapDecoration.getKey(), "has null uuid", i - 1, DungeonPlayerManager.getPlayers(), ((MapStateAccessor)state).getDecorations());
                continue;
            }
            PlayerRenderState player = PlayerRenderState.of(world, dungeonPlayer, mapDecoration.getValue());
            context.method_51448().pushMatrix();
            context.method_51448().translate((float)player.mapPos().x(), (float)player.mapPos().y());
            context.method_51448().rotate((float)Math.toRadians(player.deg() + 180.0f));
            if (player.uuid().equals(enlarge)) {
                context.method_51448().scale(2.0f, 2.0f);
            } else if (hovered == null && DungeonMap.isPlayerHovered(player, mouseX, mouseY)) {
                context.method_51448().scale(2.0f, 2.0f);
                hovered = player.uuid();
            }
            HudHelper.drawPlayerHead(context, -4, -4, 8, player.uuid());
            context.method_49601(-5, -5, 10, 10, dungeonPlayer.dungeonClass().color());
            context.method_25294(-1, -7, 1, -5, dungeonPlayer.dungeonClass().color());
            context.method_51448().popMatrix();
        }
        return hovered;
    }

    private static void dungeonPlayerError(String decorationId, String reason, int i, DungeonPlayerManager.DungeonPlayer[] dungeonPlayers, Map<String, class_20> mapDecorations) {
        LOGGER.error("[Skyblocker Dungeon Map] Dungeon player for map decoration '{}' {}. Player list index (zero-indexed): {}. Player list: {}. Map decorations: {}", new Object[]{decorationId, reason, i, Arrays.toString(dungeonPlayers), mapDecorations});
    }

    public static boolean isPlayerHovered(PlayerRenderState player, double mouseX, double mouseY) {
        return player.mapPos().distanceSquared(mouseX, mouseY) < 16.0;
    }

    private static void reset() {
        cachedMapIdComponent = null;
    }

    public record PlayerRenderState(UUID uuid, String name, Vector2dc mapPos, float deg) {
        public static PlayerRenderState of(@NotNull class_1937 world, @NotNull DungeonPlayerManager.DungeonPlayer dungeonPlayer, @NotNull class_20 mapDecoration) {
            class_1657 playerEntity = world.method_18470(dungeonPlayer.uuid());
            Vector2d mapPos = playerEntity != null ? DungeonMapUtils.getMapPosFromPhysical(DungeonManager.getPhysicalEntrancePos(), DungeonManager.getMapEntrancePos(), DungeonManager.getMapRoomSize(), (class_2374)playerEntity.method_19538()) : new Vector2d((double)mapDecoration.comp_1843() / 2.0 + 64.0, (double)mapDecoration.comp_1844() / 2.0 + 64.0);
            float deg = playerEntity != null ? playerEntity.method_36454() : (float)(mapDecoration.comp_1845() * 360) / 16.0f;
            return new PlayerRenderState(dungeonPlayer.uuid(), dungeonPlayer.name(), (Vector2dc)mapPos, deg);
        }
    }
}

