/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1577;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5575;

public class GuardianHealth {
    private static final class_238 bossRoom = new class_238(34.0, 65.0, -32.0, -32.0, 100.0, 36.0);
    private static final Pattern guardianRegex = Pattern.compile("^(.*?) Guardian (.*?)([A-Za-z])\u2764$");
    private static final Pattern professorRegex = Pattern.compile("^\ufd3e (The Professor) (.*?)([A-za-z])\u2764 \ufd3f$");
    private static boolean inBoss;

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(GuardianHealth::onChatMessage);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> GuardianHealth.reset());
        WorldRenderEvents.AFTER_ENTITIES.register(GuardianHealth::onWorldRender);
    }

    private static void onWorldRender(WorldRenderContext context) {
        if (!SkyblockerConfigManager.get().dungeons.theProfessor.floor3GuardianHealthDisplay) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (Utils.isInDungeons() && inBoss && client.field_1724 != null && client.field_1687 != null) {
            List guardians = client.field_1687.method_8390(class_1577.class, bossRoom, guardianEntity -> true);
            for (class_1577 guardian : guardians) {
                List armorStands = client.field_1687.method_18023((class_5575)class_1299.field_6131, guardian.method_5829().method_1009(0.0, 1.0, 0.0), GuardianHealth::isGuardianName);
                for (class_1531 armorStand : armorStands) {
                    Matcher matcher;
                    if (armorStand.method_5476() == null) continue;
                    String display = armorStand.method_5476().getString();
                    boolean professor = display.contains("The Professor");
                    Matcher matcher2 = matcher = professor ? professorRegex.matcher(display) : guardianRegex.matcher(display);
                    if (!matcher.matches()) continue;
                    String health = matcher.group(2);
                    String quantity = matcher.group(3);
                    double distance = context.camera().method_19326().method_1022(guardian.method_19538());
                    RenderHelper.renderText(context, (class_2561)class_2561.method_43470((String)(health + quantity)).method_27692(class_124.field_1060), guardian.method_19538(), (float)(1.0 + distance / 10.0), true);
                }
            }
        }
    }

    private static void reset() {
        inBoss = false;
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        if (Utils.isInDungeons() && SkyblockerConfigManager.get().dungeons.theProfessor.floor3GuardianHealthDisplay && !inBoss) {
            String unformatted = class_124.method_539((String)text.getString());
            inBoss = unformatted.equals("[BOSS] The Professor: I was burdened with terrible news recently...");
        }
        return true;
    }

    private static boolean isGuardianName(class_1531 entity) {
        if (entity.method_5476() == null) {
            return false;
        }
        String display = entity.method_5476().getString();
        if (display.contains("The Professor")) {
            return professorRegex.matcher(display).matches();
        }
        return !display.equals("Armor Stand") && guardianRegex.matcher(display).matches();
    }
}

