/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonMapUtils;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.skyblock.dungeon.secrets.SecretWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_2338;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.joml.Vector2ic;

public class DebugRoom
extends Room {
    private final List<Waypoint> checkedBlocks = Collections.synchronizedList(new ArrayList());

    public DebugRoom(Room.Type type, Vector2ic ... physicalPositions) {
        super(type, physicalPositions);
    }

    public static DebugRoom ofSinglePossibleRoom(Room.Type type, Vector2ic physicalPositions, String roomName, int[] roomData, Room.Direction direction) {
        return DebugRoom.ofSinglePossibleRoom(type, new Vector2ic[]{physicalPositions}, roomName, roomData, direction);
    }

    public static DebugRoom ofSinglePossibleRoom(Room.Type type, Vector2ic[] physicalPositions, String roomName, int[] roomData, Room.Direction direction) {
        DebugRoom room = new DebugRoom(type, physicalPositions);
        IntSortedSet segmentsX = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(room.segments.stream().mapToInt(Vector2ic::x).toArray()));
        IntSortedSet segmentsY = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(room.segments.stream().mapToInt(Vector2ic::y).toArray()));
        room.roomsData = Map.of(roomName, roomData);
        room.possibleRooms = List.of(MutableTriple.of((Object)((Object)direction), (Object)DungeonMapUtils.getPhysicalCornerPos(direction, segmentsX, segmentsY), List.of(roomName)));
        return room;
    }

    @Override
    protected boolean checkBlock(class_638 world, class_2338 pos) {
        byte id = DungeonManager.NUMERIC_ID.getByte((Object)class_7923.field_41175.method_10221((Object)world.method_8320(pos).method_26204()).toString());
        if (id == 0) {
            return false;
        }
        for (MutableTriple directionRooms : this.possibleRooms) {
            int block = this.posIdToInt(DungeonMapUtils.actualToRelative((Room.Direction)((Object)directionRooms.getLeft()), (Vector2ic)directionRooms.getMiddle(), pos), id);
            for (String room : (List)directionRooms.getRight()) {
                this.checkedBlocks.add(new Waypoint(pos, SecretWaypoint.TYPE_SUPPLIER, Arrays.binarySearch((int[])this.roomsData.get(room), block) >= 0 ? Room.GREEN_COLOR_COMPONENTS : Room.RED_COLOR_COMPONENTS));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(WorldRenderContext context) {
        super.render(context);
        List<Waypoint> list = this.checkedBlocks;
        synchronized (list) {
            for (Waypoint checkedBlock : this.checkedBlocks) {
                checkedBlock.render(context);
            }
        }
    }
}

